// ex03008.cpp
// Home-brew new and delete with a _new_handler
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>

static void all_gone()
{
	cerr << "\n\aThe free store is empty\n";
	exit(1);
}

extern void (*_new_handler)();

// ------------- overloaded new operator
static void *operator new(size_t size)
{
	void *rtn;
	while((rtn = malloc(size)) == NULL)
		if (_new_handler != NULL)
			(*_new_handler)();
		else
			break;
	memset(rtn, '\0', size);
	return rtn;
}

// ----------- overloaded delete operator
void operator delete(void *type)
{
	free(type);
}

main()
{
	_new_handler = all_gone;
	// ----- now get more than exists
	char *ip1 = new char[50000];
	char *ip2 = new char[50000];
}
