// ex09014.cpp
// Pure virtual function
#include <iostream.h>
#include <stdio.h>

// ------------- A Time Class
class Time	{
protected:
	int hours, minutes, seconds;
public:
	Time(int hr, int min, int sec)
		{ hours = hr; minutes = min; seconds = sec; }
	virtual void display() = 0;
};

// ------------ A TimeZone Class
enum timezone { gmt, est, cst, mst, pst };
char *TZ[] = { "GMT", "EST", "CST", "MST", "PST" };

class TimeZone	: public Time {
protected:
	 timezone zone;
public:
	TimeZone(int hr, int min, int sec, timezone zn) 
			: Time(hr, min, sec)
		{ zone = zn; }
	void display();
};

void TimeZone::display()
{
	cout << hours << ':' << minutes << ':' 
		 << seconds << ' ' << TZ [zone];
}
main()
{
	TimeZone dt(21, 42, 12, pst);
	Time&     tp = dt;
	tp.display();
	cout << '\n';
	dt.display();
}
