// ex05004.cpp
// Two structures with the same function name
#include <iostream.h>
#include <stdio.h>
#include <time.h>

// ------  date structure with a function
struct date {
	int month, day, year;
	void display(void);	   // a function to display the date
};

void date::display()
{
	static char *mon[] = {
		"January","February","March","April","May","June",
		"July","August","September","October","November",
		"December"};
	cout << mon[month] << " " << day << ", " << year;
}

// ------  time structure with a function
struct Time {
	int hour, minute, second;
	void display(void);	  // a function to display the clock
};

void Time::display()
{
	char tmsg[15];
	sprintf(tmsg, "%d:%02d:%02d %s",
		(hour > 12 ? hour - 12 : (hour == 0 ? 12 : hour)),
		minute, second,
		hour < 12 ? "am" : "pm");
	cout << tmsg;
}

main()
{
	// -------- get the current time from the OS
	time_t curtime = time((time_t *)NULL);
	struct tm tim = *localtime(&curtime);
	// --------- clock and date structures
	Time now;
	date today;
	// --------- initialize the structures
	now.hour = tim.tm_hour;
	now.minute = tim.tm_min;
	now.second = tim.tm_sec;
	today.month = tim.tm_mon;
	today.day = tim.tm_mday;
	today.year = tim.tm_year+1900;
	// ---------- display the date and time
	cout << "At the tone it will be ";
	now.display();
	cout << " on ";
	today.display();
	cout << '\a';
}
