// ex09015.cpp
// Virtual functions and multiple derived classes
#include <iostream.h>

// --------- abstract date class
class Date {
protected:
	int mo, da, yr;
public:
	Date(int m, int d, int y) {mo = m; da = d; yr = y;}
	virtual void display() = 0;
};

// --------- derived numeric date class
class NumDate : public Date {
public:
	NumDate(int m, int d, int y) : Date(m, d, y)
		{ /* ... */ }
	void display()
	{ cout << mo << '/' << da << "/" << yr; }
};

// -------- derived alphabetic date class
class AlphaDate : public Date {
public:
	AlphaDate(int m, int d, int y) : Date(m, d, y) 
		{ /* ... */ }
	void display();
};

// ------ Display function for AlphaDate
void AlphaDate::display()
{
	static char *mos[] = {
	   "January","February","March","April","May","June",
	   "July", "August","September","October","November",
	   "December"
	};
	cout << mos[Date::mo-1] << ' ' << da << ", " << yr+1900;
}


main()
{
	NumDate nd(7,29,41);
	AlphaDate ad(11,17,41);

	Date& dt1 = nd;
	Date& dt2 = ad;
	dt1.display();
	cout << '\n';
	dt2.display();
}
