/*
 *         Ansitest  --  test whether ANSI.SYS is installed
 *
 * Use --- just run the program ANSI.EXE.  It will tell you whether
 * or not ANSI.SYS has been loaded.  It sets the MSDOS ERRORLEVEL
 * variable to 0 if ANSI.SYS is active, 1 if not, so if used in a
 * batch file like
 *
 * ECHO OFF
 * ECHO This is a batch file.
 * PATH C:\;A:\;B:\
 * TESTANSI
 * IF errorlevel 1 goto NOANSI
 * ;
 * REM if TESTANSI set the errorlevel to 1, this command gets skipped
 * SET PROMPT=$e[s$e[1;68H$e[7m $t$h$h$h$e[0m$e[u$h$h$n$g
 * ;
 * :NOANSI
 * SET PATH=C:\;A:\;B:\
 *
 * the batch file can know whether ANSI.SYS is part of the
 * environment. The PROMPT is an ANSI-driven prompt that creates an
 * on-screen clock; since it requires ANSI.SYS to be loaded in order
 * to work, the batch file can skip over that command.
 *
 * Entire work (C) Copyright 1988, Loren E Heal.
 * Private hobbyists feel free to copy and distribute this material,
 * as long as NO money changes hands. This is "freeware", but not
 * Public Domain.  Commercial or government users must contact the
 * author for licensing.
 *  Loren E. Heal
 *  607 W. Healey St, #5
 *  Champaign, IL  61820
 *  EMAIL: Phoeni-Xanadu BBS, 217-
 *  July, 1988
 *
 */
/*
 *       Source Notes
 *
 * The program operates by sending to the STDOUT device the escape
 * sequence that ANSI.SYS (hereon "ANSI" or "the driver") recognizes
 * as a Device Status Request, or DSR.  The driver, if present, will
 * place an RCP, Return Cursor Position, sequence onto the input
 * stream. If ANSI (or a clone) is not active, then the DSR string
 * will have been printed to the screen and not swallowed by the
 * driver.
 *
 * I used an assembly language routine, rather than the C library
 * routines, for compactness.  The program might work as well using
 * a combination of kbhit(), getch(), and printf(), but the smaller
 * .ASM routine (included as a comment below the source) was more
 * fun to write.
 *
 */
#include <stdio.h>

#define NOT_OK          (1)
#define OK              (0)
#define EMPTY           (0)
#define GETIN           (0xff)
#define US              unsigned short
#define UL              unsigned long
#define ESC             ('\x1b')
#define DSR             ("\x1b[6n")
#define SCP             ("\x1b[s")
#define RCP             ("\x1b[u")
#define RIGHTS          ("(C) 1988 Loren E. Heal\n\r")
static char *goodmsg =  ("\x1b[1mANSI\x1b[0m active\n");
static char *badmsg  =  ("\b\b\b\b\bANSI inactive\n");

void          main(),exit();
int           print();
US            dircon();
void
main()
    {
    int c;

    print(RIGHTS);                /* send Copyright notice           */
    print(DSR);                   /* send ANSI Device Status Request */
    c = (int) dircon(GETIN);      /* check next character (kbhit()   */
                                  /* would be followed by getch())   */
    while(dircon(GETIN));         /* swallow RCP string              */
    if(c == ESC)                  /* if RCP received                 */
        {
        print(goodmsg);           /*    signal device installed      */
        c = OK;                   /*    and set exit code            */
        }
    else                          /* else                            */
        {
        print(badmsg);            /*    erase trash and give result  */
        c = NOT_OK;               /*    set exit code                */
        }
    exit(c);
    }

/* No argument or environment checks, so these routines are put
here to save a few bytes -- MSC 3.0 */
void _setenvp() { }
void _setargv() { }
void _nullcheck() { }

/*
*  PRINT:  Print a string to the console via DIRCON
*          -- Pass a string pointer
*          -- returns the number of characters printed
*/
int
print(str)
    char *str;
    {
    int i;
    for(i=0; str[i]; dircon(str[i++]))
        if(str[i] == '\n') dircon('\r');
    return(i-1);
    }
/*
 * DIRCON :    Direct console I/O  via MSDOS int21h, Fct 6
 *
 *          -- if dl is a character, it will be printed to the console
 *          -- if dl is 0xff, function returns either 0  or
 *             the character.  The following is what the assembly
 *             code looks like
 *
 * _dircon PROC NEAR
 * PUSH BP
 * MOV BP,SP
 * mov DL,[BP+4]
 * mov AH,6
 * int 21h
 * jnz D1              ; if no char waiting, zflag is set
 * mov AL,0            ;   so load a 0 into AL for return
 * d1:                 ; endif
 * mov AH,0            ; load AH with 0
 * mov SP,BP           ; and return either 0 or the char in AX
 * POP BP
 * RET
 * _dircon ENDP
 */