/*
**  LOCAL STACK ALLOCATION MACRO OR FUNCTION FOR BORLAND TURBO C
**
**  usage:  char *alloca(unsigned size);
**
**  Space is allocated on the stack and a pointer to the space is
**  returned.  The space will be freed automatically upon return from
**  the function; i.e. free() need not and should *not* be used.
**  
**  NULL is returned if there is insufficient stack space.
**
**  Written by John Navas on Thursday March 3, 1988
*/

#if 1   /* MACRO INSTEAD OF FUNCTION (CHANGE TO 0 FOR FUNCTION) */

#if defined(__TINY__) || defined(__SMALL__) || defined(__COMPACT__)
extern unsigned __brklvl;       /* stack check */
#define alloca(s) \
    ((char*)(_SP>((s)+0x1&~1)&&__brklvl<_SP-((s)+0x1&~1)? \
    (_SP-=((s)+0x1&~1)),_SP:0))
#else
#define alloca(s) \
    ((char*)(_SP>((s)+0x1&~1)? \
    (_SP-=((s)+0x1&~1),((unsigned long)_SS<<16)|_SP):0L))
#endif

#else

char *alloca(unsigned siz)      /* LOCAL STACK ALLOCATION IN TURBO C */
{
#if defined(__TINY__) || defined(__SMALL__) || defined(__COMPACT__)
    extern unsigned __brklvl;       /* stack check */
#endif
    static unsigned len;            /* length rounded to words */
    static int(*volatile rtn)();    /* return address */
    static unsigned volatile bp;    /* saved value of bp */
 
    if (_SP > (len = siz+1&~1)  /* stack check in words */
#if defined(__TINY__) || defined(__SMALL__) || defined(__COMPACT__)
    && __brklvl < _SP-len
#endif
    ) {
        rtn = *(int(**)())((char*)&siz-sizeof(int(*)()));
        bp = *(unsigned*)((char*)&siz-sizeof(int(*)())-sizeof(unsigned));
        _SP -= len;
        _BP -= len;
        *(int(**)())((char*)&siz-sizeof(int(*)())) = rtn;
        *(unsigned*)((char*)&siz-sizeof(int(*)())-sizeof(unsigned)) = bp;
        return (char*)(&siz+1);
    }
    return 0;
}

#endif

#if 0       /* test ** test ** test ** test ** test ** test ** test */
void main()
{
    char *p = alloca(80);           /* example of use */
}
#endif
