/* amfilter.c
 *
 * This file provides the hooks (system filters) for processing of menus for AddMenu.
 *
 * This program is copywrite of Robert M. Ryan, 1992.  It is provided without warrantee
 * of any sort.  This program is FreeWare, and can be used and distributed for
 * non-commercial use without fee providing that:
 *
 * 	a) it is not to be altered without my permission;
 *	b) my name remains on the package at all times;
 *	c) any programs which employ code taken from this program must credit me for
 *	   the appropriate routines; and
 *	d) no fee is ever charged for the distribution of the program short of the cost
 *	   of disk media and shipping cost (if any).
 *
 * If you want to use it for commercial purposes or have any questions about these policies,
 * do not hesitate to contact me.
 *
 * Robert M. Ryan, v0.1.0, 28 April 1992, first public release
 *
 * Rob Ryan
 *	internet:   Robert_Ryan@brown.edu
 *	bitnet:     ST802200@BROWNVM.BITNET
 *	Compu$erve: 70324,227
 */

#include <windows.h>
#include "amfilter.h"

#define PROGNAME	"AMFilter"
#define VERSION		PROGNAME " v0.1.0"
#define VERDATE		__DATE__
#define PROGRAMMER	"Robert M. Ryan"
#define MESSAGE_TYPE	WH_GETMESSAGE


/* typedefs */

/* HookData
 *
 * This is the data structure used by WH_CALLWNDPROC.  I've choosen element names
 * that coincide with the MSG structure to minimize differences between WH_CALLWNDPROC
 * filters and others.  WH_CALLWNDPROC is the only one that uses this structure.  All
 * others use the MSG structure.
 */
typedef struct tagHookData {
	WORD lParamh;
	WORD lParaml;
	WORD wParam;
	WORD message;
	WORD hwnd;
} HOOKDATA;
typedef HOOKDATA FAR *LPHOOKDATA;


/* global data */

FARPROC lpOldHook, lpCWPOldHook;	/* the old hook procs */
FARPROC lpHook,    lpCWPHook;		/* the new hook procs */
BOOL	bInstalled;			/* are the hooks installed? */
HWND	hwndHandler;			/* handle of the window processing private messages */


/* the code */

/* LibMain
 *
 * The obligatory main() proc for DLLs.
 */
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpCmdLine)
{
    UnlockData(0);
    bInstalled = FALSE;
    return 1;
} /* LibMain */


/* WEP
 *
 * The Windows Exit Procedure.  The DLL calls this before it removes itself from memory.
 * It makes sense to make sure the hook is removed before removing the code for that
 * hook.
 */
#pragma argsused
int FAR PASCAL WEP(int nParameter)
{
    if (bInstalled)			/* remove hooks if any */
	FreeHook();
    return 1;
} /* WEP */


/* SetHook
 *
 * This returns TRUE if the hooks are set correctly, FALSE if an error occurs.  Must be
 * provided a handle of a window that can understand the private messages PM_ADDTOMENU
 * and PM_MENUOPTION.
 */
BOOL FAR PASCAL SetHook(HWND hWnd)
{
    HANDLE  hModule;

    if (bInstalled)
	return TRUE;

    hwndHandler = hWnd;				/* set handle of private message handler */

    hModule = GetModuleHandle(PROGNAME);

    lpHook = GetProcAddress(hModule, "MessageFilter");
    if (!lpHook) {
	MessageBox(NULL, PROGNAME ": Error getting MessageFilter address", "Error", MB_OK | MB_ICONINFORMATION);
	return FALSE;
    }
    lpOldHook = SetWindowsHook(MESSAGE_TYPE, lpHook);

    lpCWPHook = GetProcAddress(hModule, "CWPMessageFilter");
    if (!lpCWPHook) {
	MessageBox(NULL, PROGNAME ": Error getting CWPMessageFilter address", "Error", MB_OK | MB_ICONINFORMATION);
	return FALSE;
    }
    lpCWPOldHook = SetWindowsHook(WH_CALLWNDPROC, lpCWPHook);

    bInstalled = TRUE;
    return TRUE;
} /* SetHook */


/* FreeHook
 *
 * Unhook any windows hooks used by this program
 */
void FAR PASCAL FreeHook(void)
{
    if (!bInstalled)
	return;
    UnhookWindowsHook(MESSAGE_TYPE, lpHook);
    UnhookWindowsHook(WH_CALLWNDPROC, lpCWPHook);
    bInstalled = FALSE;
} /* FreeHook */


/* HookInstalled
 *
 * Returns TRUE if the hook is currently installed.  FALSE if not.
 */
BOOL FAR PASCAL HookInstalled(void)
{
    return bInstalled;
} /* HookInstalled */


/* CWPMessageFilter
 *
 * This is the filter function for the WH_CALLWNDPROC hook.  This function determines when a
 * menu is supposed to be initialized.
 *
 * Sends private message to AddMenu with the hwnd of window to be initialized in wParam.
 */
void FAR PASCAL CWPMessageFilter(int nCode, WORD wParam, DWORD lParam)
{
    LPHOOKDATA	lpMsg = (LPHOOKDATA) lParam;

    if ((nCode >= 0) && (lpMsg->message == WM_INITMENU))
	SendMessage(hwndHandler, PM_ADDTOMENU, lpMsg->hwnd, 0L);

    DefHookProc(nCode, wParam, lParam, &lpCWPOldHook);
    return;
} /* CWPMessageFilter */


/* MessageFilter
 *
 * This is a hook function for WH_GETMESSAGE that traps the WM_SYSCOMMAND message.  Basically,
 * this function determines when the user has selected a private message from the system menu.
 *
 * Sends private message to AddMenu with the id of the menu option in wParam.
 */
void FAR PASCAL MessageFilter(int nCode, WORD wParam, DWORD lParam)
{
    LPMSG	lpMsg = (LPMSG) lParam;

    if ((nCode >= 0) && (lpMsg->message == WM_SYSCOMMAND) && (lpMsg->wParam < 0xf000))
	PostMessage(hwndHandler, PM_MENUOPTION, lpMsg->wParam & 0xfff0, 0L);

    DefHookProc(nCode, wParam, lParam, &lpOldHook);
} /* MessageFilter */
