/*		   ACK-3D ( Animation Construction Kit 3D )		      */
/* Initialization     */
/* Author: Lary Myers */

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys\stat.h>
#include "ack3d.h"
#include "ackext.h"


unsigned char far *ScreenBuffer;

	int	VidRow[200];

/****************************************************************************
**									   **
****************************************************************************/
int BuildTables(void)
{
    int	    i;
    int	    result;
    long    height;

if (GetTables() == -1)
    return(-1);

ScreenBuffer = malloc(64000);
if (ScreenBuffer == NULL)
    return(-1);

memset(ScreenBuffer,0,64000);

for (i = 0; i < 200; i++)
    VidRow[i] = i * 320;


height = 18000;
height = 14000;

DistanceTable[0] = MAX_HEIGHT;

/************** 64 * 65536 ************/
AdjustTable[0] = 4194304L / height;

for (i = 1; i < MAX_DISTANCE; i++)
    {
    DistanceTable[i] = height / i;
    if (height - (DistanceTable[i] * i) > (i / 2))
	DistanceTable[i]++;

    if (DistanceTable[i] < MIN_HEIGHT)
	DistanceTable[i] = MIN_HEIGHT;

    if (DistanceTable[i] > MAX_HEIGHT)
	DistanceTable[i] = MAX_HEIGHT;

    AdjustTable[i] = 4194304L / DistanceTable[i];
    }


return(0);
}

/****************************************************************************
**									   **
****************************************************************************/
void InitializeMouse(void)
{

memset(&mouse,0,sizeof(MOUSE));
HaveMouse = 0;
if (mouse_installed() == -1)
    {
    HaveMouse = 1;
    CheckMouse(&mouse);
    }

}


/****************************************************************************
**									   **
****************************************************************************/
void BuildXYgrid(void)
{
	    int	    i,j,CurIndex,pos,x1,y1;
unsigned    char    MapCode;

for (i = 0; i < MAX_DOORS; i++)
    {
    Door[i].ColOffset = 0;
    Door[i].mPos = Door[i].mPos1 = -1;
    }

i = (GRID_WIDTH+1) * (GRID_HEIGHT+1);
memset(xGrid,0,i);
memset(yGrid,0,i);
memset(xObjGrid,0,i);
memset(yObjGrid,0,i);

CurIndex     = 1;
TotalSpecial = 0;
TotalSecret  = 0;

for (i = 0; i < GRID_HEIGHT; i++)
    {
    for (j = 0; j < GRID_WIDTH; j++)
	{
	pos	= (i * GRID_WIDTH) + j;
	MapCode = Grid[pos];

	if (MapCode == MAP_STARTCODE)
	    {
	    StartY = pos & 0xFFC0;
	    StartX = (pos - StartY) << 6;
	    StartY += 32;
	    StartX += 32;
	    continue;
	    }

	if (MapCode == MAP_UPCODE ||
	    MapCode == MAP_DOWNCODE ||
	    MapCode == MAP_GOALCODE)
	    {
	    SpecialCodes[TotalSpecial].mPos = pos;
	    SpecialCodes[TotalSpecial++].mCode = MapCode;
	    continue;
	    }

	if (MapCode)		    /* Something is in map */
	    {
	    if (MapCode < 0x80)	    /* Wall codes range from 1-7F */
		{
		if (MapCode != DOOR_YCODE)
		    {
		    if (xGrid[pos] != DOOR_SIDECODE)
			xGrid[pos] = MapCode;

		    xGrid[pos+1] = MapCode;
		    }
		else
		    {
		    xGrid[pos]	 = DOOR_SIDECODE;
		    xGrid[pos+1] = DOOR_SIDECODE;
		    }

		if (MapCode != DOOR_XCODE)
		    {
		    if (yGrid[pos] != DOOR_SIDECODE)
			yGrid[pos] = MapCode;
		    yGrid[pos+GRID_WIDTH] = MapCode;
		    }
		else
		    {
		    yGrid[pos]		  = DOOR_SIDECODE;
		    yGrid[pos+GRID_WIDTH] = DOOR_SIDECODE;
		    }
		}
	    else		    /* > 0x80 means an object code */
		{
		CurIndex = MapCode & 0x3F;
		if (CurIndex < MAX_OBJECTS)
		    {
		    Grid[pos] = 0x80;
		    if (MapCode & 0x40)
			Grid[pos] |= 0x40;

		    xObjGrid[pos]	     = CurIndex;
		    xObjGrid[pos+1]	     = CurIndex;
		    yObjGrid[pos]	     = CurIndex;
		    yObjGrid[pos+GRID_WIDTH] = CurIndex;

		    x1 = (j << 6) + 32;	    /* Place object in center of */
		    y1 = (i << 6) + 32;	    /* the current map square	 */
		    ObjList[CurIndex].x	     = x1;
		    ObjList[CurIndex].y	     = y1;

		    ObjList[CurIndex].mPos   = pos;
		    ObjList[CurIndex].VidRow = CenterRow;
		    ObjList[CurIndex].Active = 1;
		    }
		}
	    }
	}
    }

}

