//--------------------------------- ABTBOX.CPP ---------------------------------
// Implementation for a centered bitmap containing aboutbox
// by Albert Bupp	& Dan Hoviss
// Copyright Dosolutions 1994
#include "abtbox.h"
#include "abtbox.rh"

void TCtrBitmapAboutBox::SetupWindow()
{														  
	TDialog::SetupWindow();									 

	// Move about box to center of screen.
	GetWindowRect(rcDlg);                    // Find rect for dialog box.
	w = rcDlg.right - rcDlg.left;
	h = rcDlg.bottom - rcDlg.top;

	x = (rcDesk.right - w) / 2;              // Calculate centered position
	y = (rcDesk.bottom - h) / 2;             // for dialog box

	if ((x < 0) || (y < 0) ||			           // Center dialog using new coords
		(x + w > rcDesk.right) ||              // if by centering the dialog
		(y + h > rcDesk.bottom))               // on top of the desktop would not
	{                                		     // be 100% visable then center on
		 x = (rcDesk.right - w) / 2;           // the windows desktop instead.
		 y = (rcDesk.bottom - h) / 2;
	}
	MoveWindow(x, y, w, h, TRUE);

	// OK, now center the bitmap in its frame
	hWnd = GetDlgItem(IDD_BMPFRAME);
	::GetWindowRect(hWnd, &rcFrame);            // rcFrame is in SCREEN coords
	int cxFrame = rcFrame.right - rcFrame.left; // get frame width & hieght
	int cyFrame = rcFrame.bottom - rcFrame.top;

	hWnd = GetDlgItem(IDD_ABOUTBITMAP);      // Get handle of a dlg item,
	::GetWindowRect(hWnd, &rcBmp);           // in this case item is a bitmap.
	cxBmp = rcBmp.right - rcBmp.left;        // Find dlg item's size
	cyBmp = rcBmp.bottom - rcBmp.top;

	TPoint ptBmp(rcFrame.left, rcFrame.top); // Have to convert to the about
	ScreenToClient(ptBmp);                   // box's client coords!!
	x = ptBmp.x + ((cxFrame - cxBmp) / 2);   // Calculate centered position
	y = ptBmp.y + ((cyFrame - cyBmp) / 2);   // for dialog box item

	::MoveWindow(hWnd, x, y, cxBmp, cyBmp, TRUE);
}

// The dialog can now be instantiated
class TMyWindow : public TFrameWindow
{
public:
	TMyWindow(TWindow* parent, const char* title, TModule* = 0)
	        : TFrameWindow(parent, title, 0, FALSE, module) {}
	UseAbtBox();
};

void TMyWindow::UseAbtBox()
{
	TCtrBitmapAboutBox* about = new TCtrBitmapAboutBox(this, "ABOUT");	
	about->Execute();
}