/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <stdlib.h>
#include "abm.h"
#include "city.h"
#include "missile.h"
#include "scud.h"
#include "smartbom.h"
#include "wave.h"

static  int  protectedCities[3];

/*************************************************************
WaveData  Waves[] =
 {
*************************************************************/
/*************************************************************
  { 1400,  0, 0, 14,
    { {   0,  1, 'B'},
      { 500,  1, 'B'},
      {1000,  1, 'B'},
      {1500,  1, 'B'},
      {2000,  1, 'B'},
      {2500,  1, 'B'},
      {3000,  1, 'B'},
      {32000,0,  0 } }
  }
 };
*************************************************************/
/*************************************************************
  { 1400,  0, 1, 14,
    { { 40,  7, 'S'},
      {110,  3, 'S'},
      {610,  7, 'S'},
      {670,  3, 'S'},
      {32000,0,  0 } }
  },
  { 1400,  0, 2, 14,
    { { 40,  7, 'S'},
      {110,  3, 'S'},
      {610,  7, 'S'},
      {670,  3, 'S'},
      {32000,0,  0 } }
  },
  { 1100,  0, 3, 28,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {32000,0,  0 } }
  },
  { 1100,  0, 4, 28,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {32000,0,  0 } }
  },
  { 1000,  5, 5, 42,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {32000,0,  0 } }
  }
 };
*************************************************************/

/*************************************************************/
WaveData  Waves[] =
 {
  { 1400,  0, 0, 14,
    { { 40,  7, 'S'},
      {110,  3, 'S'},
      {610,  7, 'S'},
      {670,  3, 'S'},
      {32000,0,  0 } }
  },
  { 1400,  0, 0, 14,
    { { 40,  7, 'S'},
      {110,  3, 'S'},
      {610,  7, 'S'},
      {670,  3, 'S'},
      {32000,0,  0 } }
  },
  { 1100,  0, 0, 28,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {32000,0,  0 } }
  },
  { 1100,  0, 0, 28,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {450,  1, 'B'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {32000,0,  0 } }
  },
  { 1000,  5, 0, 42,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {700,  1, 'B'},
      {800,  1, 'B'},
      {32000,0,  0 } }
  },
  { 1000,  5, 0, 42,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {700,  1, 'B'},
      {800,  1, 'B'},
      {32000,0,  0 } }
  },
  { 1000,  0, 0, 42,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {500,  1, 'B'},
      {530,  1, 'B'},
      {560,  1, 'B'},
      {810,  6, 'S'},
      {870,  5, 'S'},
      {32000,0,  0 } }
  },
  { 1000,  5, 0, 42,
    { { 40, 10, 'S'},
      {110,  5, 'S'},
      {610, 10, 'S'},
      {670,  5, 'S'},
      {700,  1, 'B'},
      {800,  1, 'B'},
      {32000,0,  0 } }
  }
 };
/*************************************************************/

int       MAXLEVELS;
WaveType  Wave;


void InitWave(void)
{
  MAXLEVELS = sizeof(Waves) / sizeof(WaveData);
  Wave.level = 0;
  Wave.round = 0;
}

static int _Cdecl qsort_LaunchNodes(const void *v1, const void *v2)
{
  return (((LaunchNode *)v1)->time - ((LaunchNode *)v2)->time);
}

void NewWave(void)
{
  int  i,lvl, r,rTime;

  Wave.time = -3;
  if (++Wave.level > MAXLEVELS)
    {
    Wave.level -= 3;
    if (Wave.level < 0)
      Wave.level = 1;
    }  
  Wave.round++;
  Wave.bonusMult = (Wave.round + 1) / 2;
  if (Wave.bonusMult > 6)
    Wave.bonusMult = 6;
  lvl = Wave.level - 1;
  Wave.waveLength = Waves[lvl].waveLength;
  Wave.scudAdvance = Waves[lvl].scudAdvance;

  //-- copy and total Launches
  for (Wave.nLaunches=0; Waves[lvl].launches[Wave.nLaunches].time<32000;
                                                            Wave.nLaunches++)
    Wave.launches[Wave.nLaunches] = Waves[lvl].launches[Wave.nLaunches];

  //-- generate random Scud launches
  r = Waves[lvl].randScuds;
  while (r)  {
    rTime = random(Wave.waveLength-2) + 1;
    for (i=0; i<Wave.nLaunches; i++)
      if (Wave.launches[i].time == rTime)
        break;
    if (i < Wave.nLaunches)
      continue;
    Wave.launches[i].time = rTime;
    Wave.launches[i].nLaunches = 1;
    Wave.launches[i].type = 'S';
    Wave.nLaunches++;
    r--;
  }

  //-- generate random SmartBomb launches
  r = Waves[lvl].randSmartBombs;
  while (r)  {
    rTime = random(Wave.waveLength-2) + 1;
    for (i=0; i<Wave.nLaunches; i++)
      if (Wave.launches[i].time == rTime)
        break;
    if (i < Wave.nLaunches)
      continue;
    Wave.launches[i].time = rTime;
    Wave.launches[i].nLaunches = 1;
    Wave.launches[i].type = 'B';
    Wave.nLaunches++;
    r--;
  }

  qsort(Wave.launches,Wave.nLaunches,sizeof(LaunchNode),qsort_LaunchNodes);

  //-- count total launches
  Wave.nScuds = Wave.nSmartBombs = 0;
  for (i=0; i<Wave.nLaunches; i++)  {
    if (Wave.launches[i].type == 'S')
      Wave.nScuds += Wave.launches[i].nLaunches;
    else
      Wave.nSmartBombs += Wave.launches[i].nLaunches;
  }

  //-- generate protected Cities, Scuds do not attack protected Cities
  //-- if no Missile Bases are left, empty Cities will not be targetted.
  {
    int  j,k;
    for (i=0; i<3; i++)
      if (Cities[MissileBase[i]-1] != -1)
        BaseMissiles[i] = 10;
    i = 0;
    j = 1;
    if (BaseMissiles[0]+BaseMissiles[1]+BaseMissiles[2] == 0)  {
      while ((i < 3) && (j < 8))  {
        if (Cities[j] == -1)
          protectedCities[i++] = j;
        j++;
        if (j == 4)
          j++;
      }
      if (i < 3)
        protectedCities[i++] = 0;
      if (i < 3)
        protectedCities[i++] = 4;
      if (i < 3)
        protectedCities[i++] = 8;
    }
    else  {
      while (i < 3)  {
        j = random(6) + 1;
        if (j >= 4)
          j++;
        for (k=0; k<i; k++)
          if (j == protectedCities[k])
            break;
        if (k == i)  {
          protectedCities[i] = j;
          i++;
        }
      }
    }
  }

  Wave.nextLaunch = 0;
}

void AdvanceWave(void)
{
  int  i;

  if (Wave.nextLaunch == Wave.nLaunches)
    return;

  if (++Wave.time >= Wave.launches[Wave.nextLaunch].time)  {
    if (nCities == 0)  {
      while (Wave.nextLaunch < Wave.nLaunches)
        Wave.nextLaunch++;
      return;
    }
    Wave.time = Wave.launches[Wave.nextLaunch].time;
    i = Wave.launches[Wave.nextLaunch].nLaunches;
    if (Wave.launches[Wave.nextLaunch].type == 'S')  {
      POINT  start,end;
      int  j,k;
      while (i--)  {
        start.x = random(client.right - 50) + 25;
        start.y = 0;
        do  {                     //-- do not target protected Cities
          j = random(9);
          for (k=0; k<3; k++)
            if (j == protectedCities[k])
              break;
        } while (k < 3);
        end.x = client.right * (j + 1) / 10;
        end.y = client.bottom * 39 / 40 - 20;
        NewScud(&start,&end,Wave.scudAdvance,1);
      }
    }
    else  {                       //-- SmartBombs
      POINT  target;
      int  j,k;
      while (i--)  {
        do  {                     //-- do not target protected Cities
          j = random(9);
          for (k=0; k<3; k++)
            if (j == protectedCities[k])
              break;
        } while (k < 3);
        target.x = client.right * (j + 1) / 10;
        target.y = client.bottom * 39 / 40 - 20;
        NewSmartBomb(&target,Wave.level);
      }
    }

    Wave.noEnemies = 0;
    Wave.nextLaunch++;
    return;
  }

  if ((nScuds == 0) && (nSmartBombs == 0))  {
    i = Wave.noEnemies++ / 3;
    while ((i--) && (Wave.time < Wave.launches[Wave.nextLaunch].time))
      Wave.time++;
  }
}
