/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <limits.h>
#include <math.h>
#include <stdio.h>                 //**** temp
#include <stdlib.h>
#include <string.h>                //**** temp
#include "abm.h"
#include "city.h"
#include "explode.h"
#include "game.h"
#include "smartbom.h"
#include "wave.h"

#define  NALTX       17

static  int   smartBombSpeed[] = {72},  NSPEED,
              smartBombDecelMax[] = {2},  NDECEL;

SmartBomb SmartBombs[MAXSMARTBOMBS];
HBITMAP   hBmpSmartBomb;
int       bmpSmartBombW,bmpSmartBombH, bmpSmartBombRad,bmpSmartBombLogRad2,logBmpSmartBombW,
          nSmartBombs,
          altPathX[NALTX], logLookAhead;
long      altPathSlope[NALTX];


static void CalculateLine(SmartBomb *sb, POINT *startLog, POINT *endLog)
{
  double  dx,dy;
//******  long  startLogX,startLogY, endLogX,endLogY;

//******  startLogX = (long)startPhy->x * XLOG / (long)client.right;
//******  startLogY = (long)startPhy->y * YLOG / (long)client.bottom;
//******  endLogX = (long)endPhy->x * XLOG / (long)client.right;
//******  endLogY = (long)endPhy->y * YLOG / (long)client.bottom;
  sb->dx = endLog->x - startLog->x;
  sb->dy = endLog->y - startLog->y;
  if (sb->dy == 0)
    sb->dy = 1;
  sb->slope = sb->dx * 1000 / sb->dy;
  sb->xIntercept = startLog->x - (sb->dx * sb->lastLog.y / sb->dy);
  dx = labs(sb->dx);
  dy = labs(sb->dy);
  sb->yAdvLog = (long)(cos(atan(dx/dy)) * (double)sb->speedLog);
}

static void ResizeSmartBombs(void)
{
  int   i,j, e;

  //-- recalculate physical destinations from logical coordinates
  for (i=0; i<nSmartBombs; i++)  {
    SmartBombs[i].lastPhy.x = (int)((long)SmartBombs[i].lastLog.x * client.right / XLOG);
    SmartBombs[i].lastPhy.y = (int)((long)SmartBombs[i].lastLog.y * client.bottom / YLOG);
    SmartBombs[i].targetPhy.x = (int)((long)SmartBombs[i].targetLog.x * client.right / XLOG);
    SmartBombs[i].targetPhy.y = (int)((long)SmartBombs[i].targetLog.y * client.bottom / YLOG);
  }

  logBmpSmartBombW = (int)((long)bmpSmartBombW * XLOG / client.right) / 2;

  e = GetBiggestExplosion();
  logLookAhead = (e * 9) / 10;
  e = e / (NALTX / 2 - 1);
  for (i=0,j=-(NALTX/2); i<NALTX; i++,j++)  {
    altPathX[i] = e * j;
    altPathSlope[i] = (long)altPathX[i] * 1000 / logLookAhead;
  }
}

void LoadSmartBombs(void)
{
  BITMAP   BMP;
  
  hBmpSmartBomb = LoadBitmap(hInst,"BMP_SmartBomb");
  ResizeSmartBombs();
  GetObject(hBmpSmartBomb,sizeof BMP,(LPSTR)&BMP);
  bmpSmartBombW = BMP.bmWidth;
  bmpSmartBombH = BMP.bmHeight;
  bmpSmartBombRad = bmpSmartBombW / 2 + 1;
  bmpSmartBombLogRad2 = (int)((long)bmpSmartBombRad * XLOG / client.right);
  bmpSmartBombLogRad2 *= bmpSmartBombLogRad2;
}

void InitSmartBombs(void)
{
  nSmartBombs = 0;
  NSPEED = sizeof(smartBombSpeed) / sizeof(smartBombSpeed[0]);
  NDECEL = sizeof(smartBombDecelMax) / sizeof(smartBombDecelMax[0]);
}

void DeleteSmartBombs(void)
{
  DeleteObject(hBmpSmartBomb);
}

void PaintSmartBombs(HDC hDC)
{
  HDC  hDCsrc;
  int  i;

  hDCsrc = CreateCompatibleDC(hDC);
  SelectObject(hDCsrc,hBmpSmartBomb);

  for (i=0; i<nSmartBombs; i++)
    BitBlt(hDC, SmartBombs[i].lastPhy.x-bmpSmartBombW/2,
                SmartBombs[i].lastPhy.y-bmpSmartBombH/2,
                bmpSmartBombW,bmpSmartBombH,
           hDCsrc, 0,0, SRCINVERT);

  DeleteDC(hDCsrc);
}

int NewSmartBomb(POINT *target, int level)
{
  SmartBomb  *sb;

  if (nSmartBombs == MAXSMARTBOMBS)
    return -99;

  sb = &SmartBombs[nSmartBombs++];
  sb->targetPhy = *target;
  sb->targetLog.x = (int)((long)sb->targetPhy.x * XLOG / client.right);
  sb->targetLog.y = (int)((long)sb->targetPhy.y * YLOG / client.bottom);
  for (sb->lastPhy.x=0; 
       (sb->lastPhy.x < 10) || (sb->lastPhy.x > client.right - 10);
       sb->lastPhy.x = sb->targetPhy.x - (random(client.bottom) - client.bottom / 2));
  sb->lastLog.x = (int)((long)sb->lastPhy.x * XLOG / client.right);
  sb->lastLog.y = (int)((long)sb->lastPhy.y * YLOG / client.bottom);
  sb->speedLog = smartBombSpeed[((level<NSPEED) ? level-1 : NSPEED-1)];
  sb->lastAlt = -1;

  sb->lastLog.y = 0;
  CalculateLine(sb,&sb->lastLog,&sb->targetLog);
  sb->lastLog.y = -1;
  sb->decel = 1;
  sb->decelMax = smartBombDecelMax[((level<NDECEL) ? level-1 : NDECEL-1)];

  return 0;
}

#define  LEVELS   4
int CheckPath(SmartBomb *sb, int altX, HDC hDC)
{
  int  i,a,total,totalDec, currX,currY, dX,dY;

  hDC=hDC;

  currX = sb->lastLog.x;
  currY = sb->lastLog.y;
  dX = altX / LEVELS;
  dY = logLookAhead / LEVELS;
  for (total=totalDec=0,i=LEVELS; i>0; i--)  {
    if (i != LEVELS)
      currY += dY;
    if (i != (LEVELS - 1))
      currX += dX;
    if (((long)abs(currX - sb->targetLog.x) * 3) > ((long)(sb->targetLog.y - currY) * 5))
      a = i;
    else
      a = InsideExplosionLogMax(currX,currY,bmpSmartBombLogRad2+500,hDC) * i * 2;
    total += a;
    if ((i == LEVELS) || (i == LEVELS - 1))
      totalDec += total;
  }

  return (total | ((total > totalDec) ? 0x80 : 0));
}
#undef  LEVELS

void LookAhead(SmartBomb *sb, HDC hDC)
{
  int  i,t, newAlt,pathTotal[NALTX],altTargetX[NALTX], explosion,blocked;

//*******************************************************  if (Whiskers(sb,hDC))
//*******************************************************    return;

  memset(pathTotal, 0, NALTX*sizeof(int));
  explosion = blocked = 0;
  i = 0;
  t = CheckPath(sb, altPathX[i], hDC);
  if (t)  {
    if (t & 0x80)  {
      blocked++;
      t &= 0x7F;
    }
    pathTotal[i] += t;
    pathTotal[i+1]++;
    explosion++;
  }
  for (i++; i<NALTX-1; i++)  {
    t = CheckPath(sb, altPathX[i], hDC);
    if (t)  {
      if (t & 0x80)  {
        blocked++;
        t &= 0x7F;
      }
      pathTotal[i-1]++;
      pathTotal[i] += t;
      pathTotal[i+1]++;
      explosion++;
    }
  }
  t = CheckPath(sb, altPathX[i], hDC);
  if (t)  {
    if (t & 0x80)  {
      blocked++;
      t &= 0x7F;
    }
    pathTotal[i-1]++;
    pathTotal[i] += t;
    explosion++;
  }

  newAlt = -1;
  if (sb->lastAlt != -1)
    CalculateLine(sb, &sb->lastLog, &sb->targetLog);

  if (explosion)  {
    POINT  newTarget;
    long   diff,t;
    int    pathMin, mid;
    for (i=0; i<NALTX; i++)
      altTargetX[i] = altPathX[i] + sb->lastLog.x;
    diff = 9999999L;
    for (i=0; i<NALTX; i++)  {
      if ((t=labs(sb->slope - altPathSlope[i])) < diff)
        diff = t;
      else
        break;
    }
    mid = i - 1;
    if (mid == -1)
      mid = 0;
    diff = 99;
    pathMin = 9999;
    for (i=mid; ((i >= 0) && (altTargetX[i] >= 0)); i--)
      if (pathTotal[i] < pathMin)  {
        newAlt = i;
        pathMin = pathTotal[i];
        diff = mid - i;
      }
    for (i=mid+1; ((i < NALTX) && (altTargetX[i] <= XLOG)); i++)
      if ((pathTotal[i] < pathMin) || ((pathTotal[i] == pathMin) && ((i-mid) < diff)))  {
        newAlt = i;
        pathMin = pathTotal[i];
        diff = i - mid;
      }
    sb->lastAlt = newAlt;
    newTarget.x = altTargetX[newAlt];
    newTarget.y = sb->lastLog.y + logLookAhead;
    CalculateLine(sb, &sb->lastLog, &newTarget);
  }
  if ((blocked == NALTX) && ((sb->targetLog.y - sb->lastLog.y) > logLookAhead))  {
    if (sb->decel < sb->decelMax)
      sb->decel++;
  }
  else  {
    if (sb->decel > 1)
      sb->decel--;
  }
}

void AdvanceSmartBombs(HDC hDC)
{
  SmartBomb  *sb;
  POINT  newPhy;
  HDC    hDCsrc;
  int    i;

  hDCsrc = CreateCompatibleDC(hDC);
  SelectObject(hDCsrc,hBmpSmartBomb);

  for (sb=&SmartBombs[0],i=0; i<nSmartBombs; i++,sb++)  {
    if (sb->lastLog.y == -1)  {
      BitBlt(hDC, sb->lastPhy.x-bmpSmartBombW/2,sb->lastPhy.y-bmpSmartBombH/2, 
                  bmpSmartBombW,bmpSmartBombH,
             hDCsrc, 0,0, SRCINVERT);
      sb->lastLog.y = 0;
    }

    LookAhead(sb,hDC);

    sb->lastLog.y += (int)(sb->yAdvLog / sb->decel);
    newPhy.y = (int)(sb->lastLog.y * (long)client.bottom / YLOG);
    sb->lastLog.x = (int)(sb->dx * sb->lastLog.y / sb->dy + sb->xIntercept);
    newPhy.x = (int)((long)sb->lastLog.x * (long)client.right / XLOG);

    BitBlt(hDC, sb->lastPhy.x-bmpSmartBombW/2,sb->lastPhy.y-bmpSmartBombH/2,
                bmpSmartBombW,bmpSmartBombH,
           hDCsrc, 0,0, 0x220326L);
    BitBlt(hDC, newPhy.x-bmpSmartBombW/2,newPhy.y-bmpSmartBombH/2,
                bmpSmartBombW,bmpSmartBombH,
           hDCsrc, 0,0, SRCINVERT);
    sb->lastPhy = newPhy;

/****************************************************
    {
      char  buf[71];
      sprintf(buf,"start %d,%d  target %d,%d",
              sb->lastLog.x, sb->lastLog.y, sb->targetLog.x, sb->targetLog.y);
      TextOut(hDC,500,20,buf,strlen(buf));
      sprintf(buf,"yAdvLog %ld  decel %ld", sb->yAdvLog, sb->decel);
      TextOut(hDC,500,35,buf,strlen(buf));
    }
****************************************************/

    if (sb->lastPhy.y >= sb->targetPhy.y)  {
      BitBlt(hDC, sb->lastPhy.x-bmpSmartBombW/2,sb->lastPhy.y-bmpSmartBombH/2, 
                  bmpSmartBombW,bmpSmartBombH,
             hDCsrc, 0,0, 0x220326L);
      RemoveSmartBomb(sb,0,hDC);
      sb--;
      i--;
    }
    else  {
//******      {
//******        char  buf[71];
//******        sprintf(buf,"CheckAgainstExplosion() == %ld", l);
//******        TextOut(hDC,500,50,buf,strlen(buf));
//******      }
      if (InsideExplosion(sb->lastPhy.x,sb->lastPhy.y,bmpSmartBombRad))  {
        score += SCORE_SMARTBOMB * Wave.bonusMult;
        BitBlt(hDC, sb->lastPhy.x-bmpSmartBombW/2,sb->lastPhy.y-bmpSmartBombH/2,
                    bmpSmartBombW,bmpSmartBombH,
               hDCsrc, 0,0, 0x220326L);
        RemoveSmartBomb(sb,1,hDC);
        sb--;
        i--;
      }
    }
  }

  DeleteDC(hDCsrc);
}

void RemoveSmartBomb(SmartBomb *sb, int explode, HDC hDC)
{
  if (sb->lastPhy.y >= sb->targetPhy.y)  {
    if (labs(sb->lastLog.x - sb->targetLog.x) < 450)
      RemoveCity(sb->targetPhy.x);
    else
      NewExplosion(sb->lastPhy.x,sb->lastPhy.y,SMARTBOMB,hDC);
  }
  else  {
    if (explode)
      NewExplosion(sb->lastPhy.x,sb->lastPhy.y,SMARTBOMB,hDC);
  }

  nSmartBombs--;
  if ((nSmartBombs) && (sb != &SmartBombs[nSmartBombs]))
    *sb = SmartBombs[nSmartBombs];
}
