/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <stdlib.h>
#include "abm.h"
#include "city.h"
#include "explode.h"
#include "game.h"
#include "scud.h"
#include "trail.h"
#include "wave.h"


int   nScuds;
Scud  Scuds[MAXSCUDS];


void InitScuds(void)
{
  nScuds = 0;
}

void LoadScuds(void)
{
  POINT  far *ptCurr, far *ptLast;
  Scud  *scud;
  int  i,j, dx,dy;

  for (i=0,scud=Scuds; i<nScuds; i++,scud++)  {
    GlobalFree(scud->pHandle);

    scud->startPhy.x = (int)((long)scud->startLog.x * client.right / XLOG);
    scud->startPhy.y = (int)((long)scud->startLog.y * client.bottom / YLOG);
    scud->endPhy.x = (int)((long)scud->endLog.x * client.right / XLOG);
    scud->endPhy.y = (int)((long)scud->endLog.y * client.bottom / YLOG);

    dx = abs(scud->startPhy.x - scud->endPhy.x);
    dy = abs(scud->startPhy.y - scud->endPhy.y);
    if (dx > dy)  {
      scud->deltaBig = dx;
      scud->deltaSmall = dy;
      scud->xBig = 1;
      scud->currPhy = (int)((long)scud->currLog * client.right / XLOG);
    }
    else  {
      scud->deltaBig = dy;
      scud->deltaSmall = dx;
      scud->xBig = 0;
      scud->currPhy = (int)((long)scud->currLog * client.bottom / YLOG);
    }
    scud->nPointsPhy = scud->deltaBig + 1;
    scud->error = (int)(scud->nPointsPhy / 2);
    scud->xDir = (scud->startPhy.x < scud->endPhy.x) ? 1 : -1;
    scud->yDir = (scud->startPhy.y < scud->endPhy.y) ? 1 : -1;
    scud->pHandle = GlobalAlloc(GMEM_MOVEABLE,sizeof(POINT) * scud->nPointsPhy);
    scud->pointsPhy = (LPPOINT)GlobalLock(scud->pHandle);
    scud->pointsPhy[0] = scud->startPhy;

    ptCurr = &scud->pointsPhy[0];
    ptLast = ptCurr - 1;
    j = 0;
    if (scud->xBig)  {
      while (j < scud->currPhy)  {
        j++;
        if (j == scud->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (scud->error > 0)  {
          ptCurr->x = ptLast->x + scud->xDir;
          ptCurr->y = ptLast->y;
          scud->error -= scud->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + scud->xDir;
          ptCurr->y = ptLast->y + scud->yDir;
          scud->error += scud->deltaBig - scud->deltaSmall;
        }
      }
    }
    else  {
      while (j < scud->currPhy)  {
        j++;
        if (j == scud->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (scud->error > 0)  {
          ptCurr->x = ptLast->x;
          ptCurr->y = ptLast->y + scud->yDir;
          scud->error -= scud->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + scud->xDir;
          ptCurr->y = ptLast->y + scud->yDir;
          scud->error += scud->deltaBig - scud->deltaSmall;
        }
      }
    }
  }
}

void FreeScuds(void)
{
  for (nScuds--; nScuds>=0; nScuds--)
    GlobalFree(Scuds[nScuds].pHandle);

  nScuds = 0;
}

int NewScud(POINT *startPhy, POINT *endPhy, long scudAdvance, int allowMirv)
{
  Scud  *scud;
  int  dx,dy;

  if (nScuds == MAXSCUDS)
    return -99;

  scud = &Scuds[nScuds++];
  scud->startPhy = *startPhy;
  scud->endPhy = *endPhy;
  scud->startLog.x = (int)((long)scud->startPhy.x * XLOG / client.right);
  scud->startLog.y = (int)((long)scud->startPhy.y * YLOG / client.bottom);
  scud->endLog.x = (int)((long)scud->endPhy.x * XLOG / client.right);
  scud->endLog.y = (int)((long)scud->endPhy.y * YLOG / client.bottom);
  scud->color = RGB(0,255,0);
  scud->advLog = scudAdvance;

  dx = abs(scud->startPhy.x - scud->endPhy.x);
  dy = abs(scud->startPhy.y - scud->endPhy.y);
  if (dx > dy)  {
    scud->deltaBig = dx;
    scud->deltaSmall = dy;
    scud->xBig = 1;
  }
  else  {
    scud->deltaBig = dy;
    scud->deltaSmall = dx;
    scud->xBig = 0;
  }
  scud->nPointsPhy = scud->deltaBig + 1;
  scud->currPhy = -1;
  scud->currLog = 0;
  scud->error = (int)(scud->nPointsPhy / 2);
  scud->xDir = (scud->startPhy.x < scud->endPhy.x) ? 1 : -1;
  scud->yDir = (scud->startPhy.y < scud->endPhy.y) ? 1 : -1;
  scud->pHandle = GlobalAlloc(GMEM_MOVEABLE,sizeof(POINT) * scud->nPointsPhy);
  scud->pointsPhy = (LPPOINT)GlobalLock(scud->pHandle);
  scud->pointsPhy[0] = scud->startPhy;

  scud->mirvLog = 32000;           //-- max value
  if (Wave.level > 1)
    if (allowMirv)
      if (random(90) == 0)
        scud->mirvLog = random(3500) + 1500;

  return 0;
}

int AdvanceScuds(HDC hDC)
{
  POINT  far *ptCurr, far *ptLast;
  Scud  *scud;
  long  adv;
  int  i;

  scud = Scuds;
  for (i=0; i<nScuds; i++,scud++)  {
    ptCurr = &scud->pointsPhy[0];
    if (scud->currPhy == -1)  {
      SetPixel(hDC,ptCurr->x,ptCurr->y,scud->color);
      scud->currPhy = 0;
    }

    scud->currLog += scud->advLog;
    if (scud->currLog > scud->mirvLog)  {
      POINT  startPhy,endPhy;
      int  q,r, dupes[11],nDupes,dupI;
      startPhy = scud->pointsPhy[(int)scud->currPhy];
      nDupes = 0;
      for (q=random(3)+3; q>0; q--)  {
        do  {
          r = random(9);
          for (dupI=0; dupI<nDupes; dupI++)
            if (dupes[dupI] == r)
              break;
        }  while (dupI < nDupes);
        dupes[nDupes] = r;
        nDupes++;
        endPhy.x = client.right * (r + 1) / 10;
        endPhy.y = client.bottom * 37 / 40;
        NewScud(&startPhy,&endPhy,scud->advLog,0);
      }
      RemoveScud(scud,0,hDC);
      scud--;
      i--;
      continue;
    }

    if (scud->xBig)  {
      adv = scud->currLog * client.right / XLOG;
      if (adv > scud->nPointsPhy)
        adv = scud->nPointsPhy;
      ptCurr = &scud->pointsPhy[(int)scud->currPhy];
      ptLast = ptCurr - 1;
      while (scud->currPhy < adv)  {
        scud->currPhy++;
        if (scud->currPhy == scud->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (scud->error > 0)  {
          ptCurr->x = ptLast->x + scud->xDir;
          ptCurr->y = ptLast->y;
          scud->error -= scud->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + scud->xDir;
          ptCurr->y = ptLast->y + scud->yDir;
          scud->error += scud->deltaBig - scud->deltaSmall;
        }
        SetPixel(hDC,ptCurr->x,ptCurr->y,scud->color);
      }
    }
    else  {
      adv = scud->currLog * client.bottom / YLOG;
      if (adv > scud->nPointsPhy)
        adv = scud->nPointsPhy;
      ptCurr = &scud->pointsPhy[(int)scud->currPhy];
      ptLast = ptCurr - 1;
      while (scud->currPhy < adv)  {
        scud->currPhy++;
        if (scud->currPhy == scud->nPointsPhy)
          break;
        ptCurr++;
        ptLast++;
        if (scud->error > 0)  {
          ptCurr->x = ptLast->x;
          ptCurr->y = ptLast->y + scud->yDir;
          scud->error -= scud->deltaSmall;
        }
        else  {     //-- error <= 0
          ptCurr->x = ptLast->x + scud->xDir;
          ptCurr->y = ptLast->y + scud->yDir;
          scud->error += scud->deltaBig - scud->deltaSmall;
        }
        SetPixel(hDC,ptCurr->x,ptCurr->y,scud->color);
      }
    }

    if (scud->currPhy == scud->nPointsPhy)  {
      RemoveScud(scud,1,hDC);
      scud--;
      i--;
    }
    else
      if (InsideExplosion(ptCurr->x,ptCurr->y,0))  {
        score += SCORE_SCUD * Wave.bonusMult;
        RemoveScud(scud,1,hDC);
        scud--;
        i--;
      }
  }

  return 0;
}

void RemoveScud(Scud *scud, int explode, HDC hDC)
{
  POINT  far *pt;

  if (scud->currPhy < scud->nPointsPhy)
    scud->nPointsPhy = scud->currPhy + 1;

  while (NewTrail(scud->pointsPhy,scud->pHandle,(int)scud->nPointsPhy) != 0)
    AdvanceTrails(hDC);

  if (scud->currPhy == scud->nPointsPhy)   //-- the scud reached its target
    RemoveCity(scud->pointsPhy[(int)scud->currPhy-1].x);
  else  {
    if (explode)  {
      pt = &scud->pointsPhy[(int)scud->currPhy];
      NewExplosion(pt->x,pt->y,SCUD,hDC);
    }
  }

  nScuds--;
  if ((nScuds) && (scud != &Scuds[nScuds]))
    *scud = Scuds[nScuds];
}

void PaintScuds(HDC hDC)
{
  int  i,j;
  
  for (i=nScuds-1; i>=0; i--)
    for (j=(int)Scuds[i].currPhy; j>=0; j--)
      SetPixel(hDC,Scuds[i].pointsPhy[j].x,Scuds[i].pointsPhy[j].y,
                   Scuds[i].color);
}
