/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include "abm.h"
#include "city.h"
#include "mushroom.h"

int  nMushrooms;
Mushroom Mushrooms[MAXCITIES];

HBITMAP  MushroomBmps[NMUSHROOMBMPS];
int      mushroomW,mushroomH;

void LoadMushrooms(void)
{
  HBITMAP  tmpBmps[NMUSHROOMBMPS];
  BITMAP  bmp;
  HDC  hDCsrc,hDCdst;
  int  i, w,h, planes,bpp;

  i = 0;
  MushroomBmps[i++] = LoadBitmap(hInst,"BMP_Mushroom1");
  MushroomBmps[i++] = LoadBitmap(hInst,"BMP_Mushroom2");
  MushroomBmps[i++] = LoadBitmap(hInst,"BMP_Mushroom3");
  MushroomBmps[i++] = LoadBitmap(hInst,"BMP_Mushroom4");
  MushroomBmps[i++] = LoadBitmap(hInst,"BMP_Mushroom5");
  MushroomBmps[i++] = LoadBitmap(hInst,"BMP_Mushroom6");
  GetObject(MushroomBmps[0],sizeof bmp,(LPSTR)&bmp);
  mushroomW = bmp.bmWidth;
  mushroomH = bmp.bmHeight;

  hDCsrc = GetDC(hWndMain);
  planes = GetDeviceCaps(hDCsrc,PLANES);
  bpp = GetDeviceCaps(hDCsrc,BITSPIXEL);
  hDCdst = CreateCompatibleDC(hDCsrc);
  ReleaseDC(hWndMain,hDCsrc);
  hDCsrc = CreateCompatibleDC(hDCdst);
  w = (int)((long)mushroomW * (long)client.right / 640L);
  h = (int)((long)mushroomH * (long)client.right / 640L);
  for (i=0; i<NMUSHROOMBMPS; i++)  {
    tmpBmps[i] = CreateBitmap(w,h,planes,bpp,NULL);
    SelectObject(hDCsrc,MushroomBmps[i]);
    SelectObject(hDCdst,tmpBmps[i]);
    StretchBlt(hDCdst,0,0,w,h,
               hDCsrc,0,0,mushroomW,mushroomH, SRCCOPY);
  }
  mushroomW = w;
  mushroomH = h;
  DeleteDC(hDCsrc);
  DeleteDC(hDCdst);
  for (i=0; i<NMUSHROOMBMPS; i++)  {
    DeleteObject(MushroomBmps[i]);
    MushroomBmps[i] = tmpBmps[i];
  }
}

void InitMushrooms(void)
{
  int  i;

  for (i=0; i<MAXCITIES; i++)  {
    Mushrooms[i].bmp = -1;
    Mushrooms[i].time = 0;
  }
  nMushrooms = 0;
}

void DeleteMushrooms(void)
{
  int  i;

  for (i=0; i<NMUSHROOMBMPS; i++)
    DeleteObject(MushroomBmps[i]);
}

void NewMushroom(int pos)
{
  Mushrooms[pos].time = 1;
  nMushrooms++;
}

int AdvanceMushrooms(HDC hDC)
{
  HDC  hDCsrc;
  int  i, x,y;

  if (nMushrooms == 0)
    return 0;

  hDCsrc = 0;
  for (i=0; i<MAXCITIES; i++)  {
    if (Mushrooms[i].time)
      if (++Mushrooms[i].time / 5 > Mushrooms[i].bmp)  {
        if (!hDCsrc)
          hDCsrc = CreateCompatibleDC(hDC);
        x = client.right * (i+1) / 10 - mushroomW / 2;
        y = client.bottom - 20 - mushroomH;
        if (Mushrooms[i].bmp > -1)  {
          SelectObject(hDCsrc,MushroomBmps[Mushrooms[i].bmp]);
          BitBlt(hDC, x,y, mushroomW,mushroomH, hDCsrc, 0,0, 0x220326L);
        }

        if (++Mushrooms[i].bmp == NMUSHROOMBMPS)  {
          Mushrooms[i].bmp = -1;
          Mushrooms[i].time = 0;
          nMushrooms--;
          continue;
        }
        SelectObject(hDCsrc,MushroomBmps[Mushrooms[i].bmp]);
        BitBlt(hDC, x,y, mushroomW,mushroomH, hDCsrc, 0,0, SRCPAINT);
      }
  }
  
  if (hDCsrc)
    DeleteDC(hDCsrc);

  return 0;
}

void PaintMushrooms(HDC hDC)
{
  HDC  hDCsrc;
  int  i, x,y;

  hDCsrc = CreateCompatibleDC(hDC);

  for (i=0; i<MAXCITIES; i++)
    if (Mushrooms[i].bmp > -1)  {
      x = client.right * (i+1) / 10 - mushroomW / 2;
      y = client.bottom - 20 - mushroomH;
      SelectObject(hDCsrc,MushroomBmps[Mushrooms[i].bmp]);
      BitBlt(hDC, x,y, mushroomW,mushroomH, hDCsrc, 0,0, SRCPAINT);
    }

  DeleteDC(hDCsrc);
}
