/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "abm.h"
#include "city.h"
#include "explode.h"
#include "game.h"
#include "menu.h"
#include "missile.h"
#include "mushroom.h"
#include "scud.h"
#include "smartbom.h"
#include "strmisc.h"
#include "trail.h"
#include "wave.h"

#define  MISSILETOTAL_Y   195
#define  CITYTOTAL_Y      235
#define  SCORETOTAL_Y     275
#define  BONUSCITY_Y      335

  long    score,scoreLast,scoreDisplayed;


void InitGame(void)
{
  score = scoreDisplayed = scoreLast = 0;
}

BOOL FAR PASCAL _export AboutDlgProc(HWND hDlg, WORD msg, WORD wp, LONG lp)
{
  lp=lp;

  switch (msg)  {
    case WM_COMMAND :
        switch (wp)  {
          case 1 : EndDialog(hDlg,0);
                   return TRUE;
        }
  }
  return FALSE;
}

void AboutBox(void)
{
  FARPROC  lpfn;

  lpfn = MakeProcInstance((FARPROC)AboutDlgProc,hInst);
  DialogBox(hInst,"DLG_About",(int)NULL,lpfn);
  FreeProcInstance(lpfn);
}

void GameMenu(HWND hWnd, WORD msg, WORD wp, LONG lp)
{
  hWnd=hWnd;
  msg=msg;
  lp=lp;

  switch (wp)  {
    case IDM_GameNew : FreeMissiles();
                       FreeTrails();
                       
                       InitCities();
                       InitExplosions();
                       InitGame();
                       InitMissiles();
                       InitMushrooms();
                       InitScuds();
                       InitSmartBombs();
                       InitTrails();
                       InitWave();

                       NewWave();

                       InvalidateRect(hWndMain,&client,1);
                       paused = 0;
                       gameState = GAME_PLAYING;
                       break;
    case IDM_GamePause : paused = !paused;
                         break;
    case IDM_ShowHighScores : ShowHighScores();
                              break;
    case IDM_GameExit : DestroyWindow(hWndMain);
                        break;
    case IDM_GameAbout : paused = 1;
                         AboutBox();
                         paused = 0;
                         break;
  }
}

void ScoreGame(HDC hDC)
{
  HFONT  hFont,hFontSave;
  DWORD  timer;
  char  buf[31];
  long  l;
  HDC  hDCsrc;
  int  i,c, x,y, tHeight, lCol,rCol,mLevel,cLevel,sLevel,bLevel;

  timer = GetTickCount();
  while (GetTickCount() < timer + 750)
    Yield();

  hDCsrc = CreateCompatibleDC(hDC);

  hFont = CreateFontIndirect(&FontHelv24);
  hFontSave = SelectObject(hDC,hFont);

  SetTextColor(hDC,RGB(255,255,255));
  SetBkColor(hDC,RGB(0,0,0));
  lCol = bmpMissileW * 22;
  strcpy(buf,"   ");
  l = GetTextExtent(hDC,buf,strlen(buf));
  rCol = lCol + LOWORD(l);
  tHeight = HIWORD(l);
  cLevel = (client.bottom - 20) / 2;
  mLevel = cLevel - tHeight * 2;
  sLevel = cLevel + tHeight * 2;
  bLevel = cLevel + tHeight * 5;
  l = client.bottom - 20 - 5 - tHeight - bLevel;
  if (l < 0)  {
    cLevel += (int)l;
    mLevel += (int)l;
    sLevel += (int)l;
    bLevel += (int)l;
    l = mLevel - bmpMissileH;
    if (l < 0)  {
      mLevel = bmpMissileH + 3;
      cLevel = mLevel + tHeight * 1.6;
    }
  }
  strcpy(buf,"SCORE");
  l = GetTextExtent(hDC,buf,strlen(buf));
  TextOut(hDC,lCol-LOWORD(l),sLevel,buf,strlen(buf));
  Commas(buf,score);
  TextOut(hDC,rCol,sLevel,buf,strlen(buf));

  if (Wave.bonusMult > 1)  {
    SetTextColor(hDC,RGB(100,100,255));
    SetBkColor(hDC,RGB(0,0,0));
    strcpy(buf,"BONUS MULTIPLIER");
    i = LOWORD(GetTextExtent(hDC,buf,strlen(buf)));
    x = lCol - i;
    if (x < 0)
      x = -x;
    else
      x = 0;
    TextOut(hDC,lCol-i+x,sLevel+tHeight,buf,strlen(buf));
    sprintf(buf,"%d",Wave.bonusMult);
    TextOut(hDC,rCol+x,sLevel+tHeight,buf,strlen(buf));
    SetTextColor(hDC,RGB(255,255,255));
    SetBkColor(hDC,RGB(0,0,0));
  }

  //-- count Missiles
  SelectObject(hDCsrc,hBmpMissile);
  i = BaseMissiles[0] + BaseMissiles[1] + BaseMissiles[2];
  for (c=1,x=lCol-bmpMissileW,y=mLevel; i>0; i--,c++)  {
    timer = GetTickCount() + 40;
    BitBlt(hDC,x,y,bmpMissileW,bmpMissileH,hDCsrc,0,0,SRCCOPY);
    sprintf(buf,"%d x %d = %d  ",c,SCORE_MISSILE,c*SCORE_MISSILE);
    TextOut(hDC,rCol,mLevel+bmpMissileH-tHeight,buf,strlen(buf));

    score += SCORE_MISSILE * Wave.bonusMult;
    Commas(buf,score);
    TextOut(hDC,rCol,sLevel,buf,strlen(buf));

    while (GetTickCount() < timer)
      Yield();

    x -= bmpMissileW + 1;
    if (x < bmpMissileW / 2)  {
      y -= bmpMissileH;
      x = lCol - bmpMissileW;
    }
  }

  //-- count Cities
  SelectObject(hDCsrc,hBmpCity[CITY]);
  for (c=1,i=0; c<8; c++)  {
    if (c == 4)
      continue;
    if (Cities[c] == CITY)
      i++;
  }
  for (c=1,x=lCol-bmpCityW[CITY],y=cLevel; i>0; i--,c++,x-=bmpCityW[CITY]*1.4)  {
    timer = GetTickCount() + 200;
    BitBlt(hDC,x,y,bmpCityW[CITY],bmpCityH[CITY],hDCsrc,0,0,SRCCOPY);
    sprintf(buf,"%d x %d = %d  ",c,SCORE_CITY,c*SCORE_CITY);
    TextOut(hDC,rCol,cLevel+bmpCityH[CITY]-tHeight,buf,strlen(buf));

    score += SCORE_CITY * Wave.bonusMult;
    Commas(buf,score);
    TextOut(hDC,rCol,sLevel,buf,strlen(buf));

    while (GetTickCount() < timer)
      Yield();
  }

  timer = GetTickCount() + 3000;
  while (GetTickCount() < timer)
    Yield();

  if (score/10000 > scoreLast/10000)  {
    BonusCity(1);
    SetTextColor(hDC,RGB(0,255,0));
    SetBkColor(hDC,RGB(0,0,0));
    
    //-- write text BONUS CITY
    strcpy(buf,"BONUS CITY");
    i = LOWORD(GetTextExtent(hDC,buf,strlen(buf)));
    TextOut(hDC,(client.right-i)/2,bLevel-tHeight,buf,strlen(buf));
    //-- put CITY bitmap on screen
    SelectObject(hDCsrc,hBmpCity[CITY]);
    BitBlt(hDC, (client.right-i)/2+i+bmpCityW[CITY],bLevel-bmpCityH[CITY],
                bmpCityW[CITY],bmpCityH[CITY],
           hDCsrc, 0,0, SRCPAINT);

    timer = GetTickCount() + 3000;
    while (GetTickCount() < timer)
      Yield();

  }
  else  {
    BonusCity(0);
    i = (Cities[1]==CITY) + (Cities[2]==CITY) + (Cities[3]==CITY) +
        (Cities[5]==CITY) + (Cities[6]==CITY) + (Cities[7]==CITY);
    if (i == 0)
      gameState = GAME_OVER;
  }

  SelectObject(hDC,hFontSave);
  DeleteObject(hFont);
  DeleteDC(hDCsrc);

  InvalidateRect(hWndMain,&client,1);

  scoreLast = score;
}

//=============================================================================
//=============================================================================
//=============================================================================

typedef struct { long  score;
                 char  name[31];
               } HighScore;
HighScore  HighScores[10];
char  *namePtr;

void LoadScores(void)
{
  OFSTRUCT  of;
  char  *cp, ScoreFile[255];
  int   handle;

  memset(HighScores, 0, sizeof(HighScores));
  strcpy(ScoreFile, _argv[0]);
  cp = strrchr(ScoreFile, '.') + 1;
  strcpy(cp, "DAT");
  handle = OpenFile(ScoreFile, &of, OF_READ);
  if (handle == -1)
    return;

  _lread(handle, (LPSTR)HighScores, sizeof(HighScores));
  _lclose(handle);
}

void SaveScores(void)
{
  OFSTRUCT  of;
  char  *cp, ScoreFile[255];
  int   handle;

  strcpy(ScoreFile, _argv[0]);
  cp = strrchr(ScoreFile, '.') + 1;
  strcpy(cp, "DAT");
  handle = OpenFile(ScoreFile, &of, OF_CREATE|OF_WRITE);
  if (handle == -1)
    return;

  _lwrite(handle, (LPSTR)HighScores, sizeof(HighScores));
  _lclose(handle);
}

int FAR PASCAL Dialog_HighScores(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  lParam=lParam;      //-- prevent compiler warning

  switch (wMsg)  {
    case WM_INITDIALOG :  {
        char scoreText[15];
        int  i;

        for (i=0; i<10; i++)  {
          Commas(scoreText, HighScores[i].score);
          SetDlgItemText(hDlg, ID_Score1+i, scoreText);
          SetDlgItemText(hDlg, ID_Name1+i,  HighScores[i].name);
        }
        return TRUE;
    }

    case WM_COMMAND :
        switch (wParam)  {
          case IDOK :
              EndDialog(hDlg,0);
              return TRUE;

          default :
              return FALSE;
        }

    default :
        return FALSE;
  }
}

void ShowHighScores(void)
{
  FARPROC  lpfn;

  LoadScores();

  lpfn = MakeProcInstance(Dialog_HighScores, hInst);
  DialogBox(hInst, "DLG_HighScores", hWndMain, lpfn);
  FreeProcInstance(lpfn);
}

//=============================================================================
//=============================================================================
//=============================================================================

int DialogCommand_NewHighScore(HWND hDlg, WORD wp, WORD lphi, WORD lplo)
{
  lphi=lphi;      //-- prevent compiler warning
  lplo=lplo;

  switch (wp)  {
    case IDOK :
        GetDlgItemText(hDlg, ID_NewName, namePtr, 31);
        EndDialog(hDlg,0);
        return TRUE;

    default :
        return FALSE;
  }
}

int FAR PASCAL Dialog_NewHighScore(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  switch (wMsg)  {
    case WM_INITDIALOG :
        SendDlgItemMessage(hDlg, ID_NewName, EM_LIMITTEXT, 30, 0);
        return TRUE;

    case WM_COMMAND :
        return DialogCommand_NewHighScore(hDlg, wParam, HIWORD(lParam), LOWORD(lParam));

    default :
        return FALSE;
  }
}

void CheckHighScores(void)
{
  FARPROC  lpfn;
  int      i,j;

  LoadScores();

  //-- check list of high scores
  for (i=9; i>=0; i--)
    if (HighScores[i].score >= score)
      break;
  if (i == 9)
    return;
  i++;

  //-- adjust high scores list
  for (j=9; j>i; j--)
    HighScores[j] = HighScores[j-1];

  namePtr = HighScores[i].name;
  HighScores[i].score = score;

  lpfn = MakeProcInstance(Dialog_NewHighScore, hInst);
  DialogBox(hInst, "DLG_NewHighScore", hWndMain, lpfn);
  FreeProcInstance(lpfn);

  SaveScores();

  ShowHighScores();
}

