/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/


#include <windows.h>
#pragma  hdrstop

#include <math.h>
#include <stdlib.h>
#include "abm.h"
#include "city.h"
#include "missile.h"
#include "mushroom.h"


int      Cities[MAXCITIES], nCities;
HBITMAP  hBmpCity[2];
int      bmpCityW[2],bmpCityH[2];

static  int  bonusCities;

void InitCities(void)
{
  int  i;
  
  for (i=0; i<MAXCITIES; i++)
    Cities[i] = CITY;
  nCities = 6;
  bonusCities = 0;

  Cities[0] = Cities[4] = Cities[8] = MBASE;
  for (i=0; i<3; i++)
    if (Cities[MissileBase[i]-1] != -1)
      BaseMissiles[i] = 10;
}

void LoadCities(void)
{
  HBITMAP  newBitmaps[2];
  BITMAP   BMP;
  HDC  hDCsrc,hDCdst;
  int  h,w, planes,bpp;

  hBmpCity[CITY] = LoadBitmap(hInst,"BMP_City");
  GetObject(hBmpCity[CITY],sizeof BMP,(LPSTR)&BMP);
  bmpCityW[CITY] = BMP.bmWidth;
  bmpCityH[CITY] = BMP.bmHeight;
  hBmpCity[MBASE] = LoadBitmap(hInst,"BMP_MBase");
  GetObject(hBmpCity[MBASE],sizeof BMP,(LPSTR)&BMP);
  bmpCityW[MBASE] = BMP.bmWidth;
  bmpCityH[MBASE] = BMP.bmHeight;

  hDCsrc = GetDC(hWndMain);
  planes = GetDeviceCaps(hDCsrc,PLANES);
  bpp = GetDeviceCaps(hDCsrc,BITSPIXEL);
  hDCdst = CreateCompatibleDC(hDCsrc);
  ReleaseDC(hWndMain,hDCsrc);
  hDCsrc = CreateCompatibleDC(hDCdst);
  h = (int)((long)bmpCityH[CITY] * (long)client.right / 640L);
  w = (int)((long)bmpCityW[CITY] * (long)client.right / 640L);
  newBitmaps[CITY] = CreateBitmap(w,h,planes,bpp,NULL);
  SelectObject(hDCsrc,hBmpCity[CITY]);
  SelectObject(hDCdst,newBitmaps[CITY]);
  StretchBlt(hDCdst,0,0,w,h,
             hDCsrc,0,0,bmpCityW[CITY],bmpCityH[CITY], SRCCOPY);
  bmpCityW[CITY] = w;
  bmpCityH[CITY] = h;
  h = (int)((long)bmpCityH[MBASE] * (long)client.right / 640L);
  w = (int)((long)bmpCityW[MBASE] * (long)client.right / 640L);
  newBitmaps[MBASE] = CreateBitmap(w,h,planes,bpp,NULL);
  SelectObject(hDCsrc,hBmpCity[MBASE]);
  SelectObject(hDCdst,newBitmaps[MBASE]);
  StretchBlt(hDCdst,0,0,w,h,
             hDCsrc,0,0,bmpCityW[MBASE],bmpCityH[MBASE], SRCCOPY);
  bmpCityW[MBASE] = w;
  bmpCityH[MBASE] = h;
  DeleteDC(hDCsrc);
  DeleteDC(hDCdst);
  DeleteObject(hBmpCity[CITY]);
  hBmpCity[CITY] = newBitmaps[CITY];
  DeleteObject(hBmpCity[MBASE]);
  hBmpCity[MBASE] = newBitmaps[MBASE];
}

void DeleteCities(void)
{
  DeleteObject(hBmpCity[CITY]);
  DeleteObject(hBmpCity[MBASE]);
}

void PaintCities(HDC hDC)
{
  int  i,x;
  HDC  hDCsrc;
  
  hDCsrc = CreateCompatibleDC(hDC);

  for (i=0; i<MAXCITIES; i++)
    if (Cities[i] > -1)  {
      SelectObject(hDCsrc,hBmpCity[Cities[i]]);
      x = client.right * (i+1) / 10;
      BitBlt(hDC, x-bmpCityW[Cities[i]]/2,client.bottom-20-bmpCityH[Cities[i]], 
                  bmpCityW[Cities[i]],bmpCityH[Cities[i]],
             hDCsrc, 0,0, SRCCOPY);
    }
    
  DeleteDC(hDCsrc);
}

void RemoveCity(int x)
{
  long  dx,newdx;
  int  i,j;

  dx = 9999;
  for (i=0; i<MAXCITIES; i++)  {
    newdx = labs((long)client.right * (i+1L) / 10L - x);
    if (newdx > dx)
      break;
    dx = newdx;
  }
  i--;

  if (Cities[i] != -1)  {
    NewMushroom(i);
    if (Cities[i] == CITY)
      nCities--;
    Cities[i] = -1;
    for (j=0; j<3; j++)
      if (MissileBase[j] == (i + 1))  {
        BaseMissiles[j] = 0;
        break;
      }
  }
}

void BonusCity(int bc)
{
  int  i;

  bonusCities += bc;
  while ((bonusCities) && (nCities < 6))  {
    i = random(6) + 1;
    if (i >= 4)
      i++;
    if (Cities[i] == -1)  {
      Cities[i] = CITY;
      bonusCities--;
      nCities++;
    }
  }
}
