/*[]=========================================================================[]
  ||                 Copyright (c) 1992-1994, Kent Rollins                   ||
  ||         Please see accompanying LICENSE.TXT for more information.       ||
  ||                    This notice may not be removed.                      ||
  []=========================================================================[]
*/

#include <windows.h>
#pragma hdrstop

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "abm.h"
#include "city.h"
#include "explode.h"
#include "game.h"
#include "menu.h"
#include "missile.h"
#include "mushroom.h"
#include "options.h"
#include "scud.h"
#include "smartbom.h"
#include "strmisc.h"
#include "trail.h"
#include "wave.h"

static  char  strGameOver[] = "GAME OVER";
static  int   loaded, border,captionMenu,
              showAboutBox, currInterval;

  HANDLE  hInst;
  HICON   hIcon;
  HCURSOR hCursor;
  HMENU   hMNU;
  HWND    hWndMain;
  RECT    client;
  char    sHelpFile[151];
  char    appName[] = "ABMCommand";
  LOGFONT FontHelv24 = {24,0,0,0,700,0,0,0,ANSI_CHARSET,
                        OUT_DEFAULT_PRECIS,CLIP_STROKE_PRECIS,
                        DRAFT_QUALITY,VARIABLE_PITCH+FF_SWISS,"Helv"},
          FontHelv20 = {20,0,0,0,700,0,0,0,ANSI_CHARSET,
                        OUT_DEFAULT_PRECIS,CLIP_STROKE_PRECIS,
                        DRAFT_QUALITY,VARIABLE_PITCH+FF_SWISS,"Helv"};

  int     paused,gameState;
  long    currTimer;


//============================================================================
long FAR PASCAL _export ABMCommand(HWND hWnd, WORD msg, WORD wp, LONG lp)
{
  switch (msg)  {
    case WM_COMMAND :
        if (wp < IDM_GameMenu+999)
          GameMenu(hWnd,msg,wp,lp);
        if (wp < IDM_OptsMenu+999)
          OptionsMenu(hWnd,msg,wp,lp);
        if (wp == IDM_Help)
          WinHelp( hWnd, sHelpFile, HELP_CONTENTS, 0);
        return 0;
    case WM_RBUTTONDOWN :
        ShowWindow(hWndMain,SW_SHOWMINIMIZED);
        return 0;
    case WM_LBUTTONDOWN :  {
        char  buf[10];
        HDC  hDC;
        int  i;
        if (gameState != GAME_PLAYING)
          return 0;
        if (paused)
          paused = 0;
        i = NewMissile(-1,(POINT *)&lp);
        if (i < 0)
          MessageBeep(0);
        else  {
          hDC = GetDC(hWnd);
          itoa(BaseMissiles[i],buf,10);
          strcat(buf,"  ");
          TextOut(hDC, client.right*MissileBase[i]/10-10,client.bottom-16,
                      buf,strlen(buf));
          ReleaseDC(hWnd,hDC);
        }
        return 0;
      }
    case WM_KEYDOWN :  {
        char  buf[10];
        HDC  hDC;
        int  i;
        if (wp == VK_F2)  {
          GameMenu(hWnd,WM_COMMAND,IDM_GameNew,0);
          return 0;
        }
        else if (wp == VK_F3)  {
          GameMenu(hWnd,WM_COMMAND,IDM_GamePause,0);
          return 0;
        }
        if (gameState != GAME_PLAYING)
          return 0;
        if (paused)
          paused = 0;
/*************************************************/
        if (wp == VK_SPACE)  {
          KillTimer(hWnd,1);
          currInterval = (currInterval==500) ? 50 : 500;
          SetTimer(hWndMain,1,currInterval,NULL);
          return 0;
        }
/*************************************************/
        GetCursorPos((LPPOINT)&lp);
        ScreenToClient(hWndMain,(LPPOINT)&lp);
        i = -1;
        if ((wp=='1')||(wp=='Q')||(wp=='A')||(wp=='Z'))  {
          if (BaseMissiles[0] > 0)
            i = NewMissile(0,(POINT *)&lp);
        }
        else if ((wp=='2')||(wp=='W')||(wp=='S')||(wp=='X'))  {
          if (BaseMissiles[1] > 0)
            i = NewMissile(1,(POINT *)&lp);
        }
        else if ((wp=='3')||(wp=='E')||(wp=='D')||(wp=='C'))  {
          if (BaseMissiles[2] > 0)
            i = NewMissile(2,(POINT *)&lp);
        }
        if (i == -1)
          MessageBeep(0);
        else  {
          hDC = GetDC(hWnd);
          itoa(BaseMissiles[i],buf,10);
          strcat(buf,"  ");
          TextOut(hDC, client.right*MissileBase[i]/10-10,client.bottom-16,
                       buf,strlen(buf));
          ReleaseDC(hWnd,hDC);
        }
        return 0;
      }
    case WM_TIMER :  {
        HDC  hDC;
        if ((paused) || (gameState != GAME_PLAYING))
          return 0;
        currTimer = GetTickCount();
        hDC = GetDC(hWnd);
        if (Wave.time < -1)  {
          HFONT  hFont,hFontSave;
          char  buf[21];
          long  timer;
          int  x;
          if (Wave.time == -3)  {
            sprintf(buf,"ROUND %d",Wave.round);
            x = LOWORD(GetTextExtent(hDC,buf,strlen(buf)));
            hFont = CreateFontIndirect(&FontHelv24);
            hFontSave = SelectObject(hDC,hFont);
            SetTextColor(hDC,RGB(0,255,0));
            SetBkColor(hDC,RGB(0,0,0));
            TextOut(hDC, (client.right-x)/2,client.bottom/2, buf,strlen(buf));
            SelectObject(hDC,hFontSave);
            DeleteObject(hFont);
            SetTextColor(hDC,RGB(0,0,0));
            SetBkColor(hDC,GetPixel(hDC,client.left+1,client.bottom-1));
            timer = GetTickCount() + 1500;
            while (GetTickCount() < timer)
              Yield();
            InvalidateRect(hWnd,&client,1);
            ReleaseDC(hWnd,hDC);
            Wave.time = -2;
            return 0;
          }
        }
        AdvanceWave();
        AdvanceMissiles(hDC);
        AdvanceExplosions(hDC);
        AdvanceMushrooms(hDC);
        AdvanceScuds(hDC);
        AdvanceSmartBombs(hDC);
        AdvanceTrails(hDC);
        if (GetTickCount() < currTimer + 50)
          if (scoreDisplayed != score)  {
            HFONT  hFont,hFontSave;
            char  buf[10];
            Commas(buf,score);
            hFont = CreateFontIndirect(&FontHelv20);
            hFontSave = SelectObject(hDC,hFont);
            TextOut(hDC, client.right/5,client.bottom-18, buf,strlen(buf));
            SelectObject(hDC,hFontSave);
            DeleteObject(hFont);
            scoreDisplayed = score;
          }
        if (Wave.nextLaunch == Wave.nLaunches)  {
          if ((!nScuds) && (!nSmartBombs) && (!nMushrooms) &&
              (!nTrails) && (!nExplosions) && (!nMissiles))  {
            ScoreGame(hDC);
            NewWave();
          }
        }
        ReleaseDC(hWnd,hDC);
        return 0;
      }
    case WM_PAINT :  {
        PAINTSTRUCT  ps;
        HBRUSH  hBr;
        RECT  rect;
        char  buf[11];
        HDC  hDC;
        int  i;
        if (client.top == -99)
          return 0;
        hDC = BeginPaint(hWnd,&ps);
        rect.top = (int)((long)client.bottom - 20);
        SetRect(&rect,0,rect.top,client.right,client.bottom);
        hBr = GetStockObject(LTGRAY_BRUSH);
        PaintCities(hDC);
        PaintExplosions(hDC);
        PaintMissiles(hDC);
        PaintMushrooms(hDC);
        PaintScuds(hDC);
        PaintSmartBombs(hDC);
        FillRect(hDC,&rect,hBr);
        SetTextColor(hDC,RGB(0,0,0));
        SetBkColor(hDC,GetPixel(hDC,client.left+1,client.bottom-1));
        for (i=0; i<3; i++)  {
          itoa(BaseMissiles[i],buf,10);
          TextOut(hDC, client.right*MissileBase[i]/10-10,client.bottom-16,
                       buf,strlen(buf));
        }
        if ((gameState != GAME_PLAYING) && (score))  {
          HFONT  hFont,hFontSave;
          long  l;
          hFont = CreateFontIndirect(&FontHelv24);
          hFontSave = SelectObject(hDC,hFont);
          SetTextColor(hDC,RGB(255,0,0));
          SetBkColor(hDC,RGB(0,0,0));
          l = GetTextExtent(hDC,strGameOver,strlen(strGameOver));
          TextOut(hDC, (client.right-LOWORD(l))/2,(client.bottom-HIWORD(l))/2,
                       strGameOver,strlen(strGameOver));
          SelectObject(hDC,hFontSave);
          DeleteObject(hFont);

          if (gameState == GAME_OVER)  {
            gameState = GAME_SCORED;
            CheckHighScores();
          }
        }
        EndPaint(hWnd,&ps);
        scoreDisplayed = 0;
        if (Wave.time == -2)
          Wave.time = -1;
        return 0;
      }
    case WM_GETMINMAXINFO :  {
        LPPOINT pt;
        int i;
        i = GetSystemMetrics(SM_CXSCREEN) / 2 +
            GetSystemMetrics(SM_CXFRAME) * 2;
        pt = (LPPOINT)lp;
        pt[3].x = i;
        pt[3].y = i * .75;
        return 0;
      }
    case WM_SIZE :  {
        RECT  newClient;
        if (wp == SIZEICONIC)  {
          paused = 1;
          return 0;
        }
        GetClientRect(hWnd,&newClient);
        client.top = newClient.top;
        if (wp != SIZEFULLSCREEN)  {
          if (memcmp(&newClient,&client,sizeof(RECT)) != 0)  {
            client.top = GetSystemMetrics(SM_CXSCREEN) / 2;
            if (newClient.right < client.top)
              newClient.right = client.top;
            newClient.bottom = (int)((long)newClient.right * YLOG / XLOG);
            client = newClient;
            client.top = -99;
            newClient.right += border * 2;
            newClient.bottom += border * 2 + captionMenu;
            SetWindowPos(hWnd,0,0,0,newClient.right,newClient.bottom,SWP_NOMOVE);
            return 0;
          }
        }
        client = newClient;
        if (!loaded)  {
          LoadExplosions();
          LoadCities();
          LoadSmartBombs();
          LoadMissiles();
          LoadMushrooms();
          GetWindowRect(hWnd,&newClient);
          captionMenu = newClient.bottom + newClient.top - client.bottom;
          border = -newClient.top;
          loaded = 1;
        }
        else  {
          DeleteCities();
          LoadCities();
          DeleteExplosions();
          LoadExplosions();
          DeleteMissiles();
          LoadMissiles();
          DeleteMushrooms();
          LoadMushrooms();
          LoadScuds();
          FreeTrails();
        }
/************************************************************************
        if (showAboutBox)  {
          MessageBox(hWnd,"If this is the first time you are running\r"
                          "ABM Command, please see the About Box.",
                          "Please read the About Box",MB_OK+MB_ICONSTOP);
          showAboutBox = 0;
        }
************************************************************************/
        return 0;
      }
    case WM_CREATE :
        break;

    case WM_DESTROY :
        KillTimer(hWnd,1);
        PostQuitMessage(0);
        return 0;
  }
  return DefWindowProc(hWnd,msg,wp,lp);
}

//============================================================================
void FAR PASCAL InitializeInstance(void)
{
  WNDCLASS  wndClass;

  wndClass.style =         CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wndClass.lpfnWndProc =   (WNDPROC)ABMCommand;
  wndClass.cbClsExtra =    0;
  wndClass.cbWndExtra =    0;
  wndClass.hInstance =     hInst;
  wndClass.hIcon =         hIcon;
  wndClass.hCursor =       hCursor;
  wndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
  wndClass.lpszMenuName =  "MNU_ABMCommand";
  wndClass.lpszClassName = appName;
  RegisterClass(&wndClass);

  hWndMain = CreateWindow(appName,"ABM Command",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          0, 0,
                          hInst, NULL);

  paused = gameState = loaded = 0;
  randomize();

  InitCities();
  InitExplosions();
  InitGame();
  InitMissiles();
  InitMushrooms();
  InitScuds();
  InitSmartBombs();
  InitTrails();
  InitWave();
}

//============================================================================
int PASCAL WinMain(HANDLE hInstance,
                   HANDLE hPrevInstance,
                   LPSTR  lpszCmdLine,
                   int    nCmdShow)
{
  MSG  msg;

  nCmdShow = nCmdShow;
  lpszCmdLine = lpszCmdLine;

  if (hPrevInstance)  {
    MessageBeep(0);
    return FALSE;
  }

    {
    char *cp;
    strcpy( sHelpFile, _argv[0]);
    cp = strrchr( sHelpFile, '.');
    strcpy( cp, ".HLP");
    }

  hInst = hInstance;
  hIcon = LoadIcon(hInst,"ICO_ABMCommand");
  hCursor = LoadCursor(hInst,"CUR_ABMCommand");
  InitializeInstance();

  showAboutBox = 0;

  ShowWindow(hWndMain,SW_SHOWMAXIMIZED);
  UpdateWindow(hWndMain);

  SetTimer(hWndMain,1,50,NULL);

  while (GetMessage(&msg,0,0,0))  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  DeleteExplosions();
  DeleteCities();
  DeleteSmartBombs();
  DeleteMissiles();
  DeleteMushrooms();
  FreeScuds();
  FreeTrails();

  DestroyWindow(hWndMain);
  UnregisterClass(appName,hInst);
  DestroyIcon(hIcon);
  DestroyCursor(hCursor);

  return FALSE;
}
