/*Video MCGA toolbox v1.0 / BC4.0 in 32bits&flat memory model*/
/*(c)94 Rsc Research , Cedric Rime - Dixence21-1950 Sion-Switzerland*/

int co80=3;
int mono80=7;

void clear(int color)
{
_asm push es;
_asm mov es,SEGA000;
_asm mov edi,0;
_asm mov eax,color;

bcl:
_asm mov es:[edi],eax;
_asm add edi,4
_asm cmp edi,64000
_asm jl  bcl

_asm pop es;
}



void initvideo(void)
{
 _AX=0x13;
 geninterrupt(0x10);
}

void setvideo(int mode)
{
 _AX=mode;
 geninterrupt(0x10);
}

void putpixel (int x,int y,int co)
{
asm { 
mov eax,y;
mov ecx,320;
mul ecx;
add eax,x;
mov edi,eax;
push es;
mov es,SEGA000;
mov eax,co;
mov byte ptr es:[edi],al;
pop es;
}
}

void box (int x1,int y1,int x2,int y2,int co)
{
 int q;
 
 _asm push es;
 _asm mov es,SEGA000;

 for (q=x1;q<x2;q++)
 { 
 _asm mov eax,y1;
 _asm mov ecx,320;
 _asm mul ecx;
 _asm add eax,q;
 _asm mov edi,eax;
 _asm mov eax,co;
 _asm mov byte ptr es:[edi],al;

 _asm mov eax,y2;
 _asm mov ecx,320;
 _asm mul ecx;
 _asm add eax,q;
 _asm mov edi,eax;
 _asm mov eax,co;
 _asm mov byte ptr es:[edi],al;

 }
 for (q=y1;q<y2;q++)
 {
 _asm mov eax,q;
 _asm mov ecx,320;
 _asm mul ecx;
 _asm add eax,x1;
 _asm mov edi,eax;
 _asm mov eax,co;
 _asm mov byte ptr es:[edi],al;

 _asm mov eax,q;
 _asm mov ecx,320;
 _asm mul ecx;
 _asm add eax,x2;
 _asm mov edi,eax;
 _asm mov eax,co;
 _asm mov byte ptr es:[edi],al;

 }
 _asm pop es;
}

void fbox (int x1,int y1,int x2,int y2,int co)   
{
 int q,w;
 
 _asm push es;
 _asm mov es,SEGA000;
 
 for (q=x1;q<=x2;q++)
 { 
 for (w=y1;w<=y2;w++)
 {
 _asm mov eax,w;
 _asm mov ecx,320;
 _asm mul ecx;
 _asm add eax,q;
 _asm mov edi,eax;
 _asm mov eax,co;
 _asm mov byte ptr es:[edi],al;
 }}
 _asm pop es;
}


void line(int x1,int y1,int x2,int y2,int co)
{ int incrx=1;
  int incry=1;
  int x=x1;
  int y=y1;
  int delta,dx,dy,i1;

 _asm push es;
 _asm mov es,SEGA000;

/*putpixel (x,y,co);*/
 _asm mov eax,y;
 _asm mov ecx,320;
 _asm mul ecx;
 _asm add eax,x;
 _asm mov edi,eax;
 _asm mov eax,co;
 _asm mov byte ptr es:[edi],al;
 
  if (x1 >x2) incrx=-1;
  if (y1 >y2) incry=-1;
  
  dx=abs(x1-x2);
  dy=abs(y1-y2);
  if (dx>dy) 
   {
    delta=dx /2;
    for (i1=1;i1<dx;i1++)
     {
      x=x+incrx;
      delta=delta+dy;
      if (delta>=dx)
        {
         delta=delta-dx;
         y=y+incry;
        }
      /*putpixel(x,y,co);*/
      _asm mov eax,y;
      _asm mov ecx,320;
      _asm mul ecx;
      _asm add eax,x;
      _asm mov edi,eax;
      _asm mov eax,co;
      _asm mov byte ptr es:[edi],al;

     }
   }
  else
   {
   delta=dy/2;
   for (i1=1;i1<dy;i1++)
    {
     y=y+incry;
     delta=delta+dx;
     if (delta>=dy)
      {
       delta=delta-dy;
       x=x+incrx;
      }
     /*putpixel(x,y,co);*/
     _asm mov eax,y;
     _asm mov ecx,320;
     _asm mul ecx;
     _asm add eax,x;
     _asm mov edi,eax;
     _asm mov eax,co;
     _asm mov byte ptr es:[edi],al;

    }
   }
 _asm pop es;
}

void circle(int cx,int cy,int rad,int co)
{
 int x=rad;
 int y=0;
 int c=3-2*rad;
 
 while (x>=y)
  {if (x!=y) 
     {
     putpixel(cx+x,cy+y,co);
     putpixel(cx+y,cy-x,co);
     putpixel(cx-x,cy-y,co);
     putpixel(cx-y,cy+x,co);
     }
   if (y!=0) 
     {
     putpixel(cx+x,cy-y,co);
     putpixel(cx-y,cy-x,co);
     putpixel(cx-x,cy+y,co);
     putpixel(cx+y,cy+x,co);
     }
   if (c<=0) 
           {
           c=c+4*y+6;
           } else 
           {
           c=c-4*x+4*y+10;
           x=x-1;
           }
   y=y+1;
  }
}

void setrgb(char co,char r,char g,char b)
{
asm
{ mov dx,0x3c8;
  mov al,co
  out dx,al
  mov dx,0x3c9
  mov al,r
  out dx,al
  mov al,g
  out dx,al
  mov al,b
  out dx,al
}
}



