#define INCL_USER
#include <ntbc.h>

#include <string.h>
#include <stdlib.h>

extern unsigned char __isGUI;   /* defined in c0nt.asm, to determine at runtime
				   if we're a GUI or Console mode application */

void _RTLENTRY _EXPFUNC _ErrorMessage(const char *s)
{
    DWORD nwritten;
    HANDLE herr;

    herr = GetStdHandle(STD_ERROR_HANDLE);

    WriteFile(herr, "\r\n", 2, &nwritten, NULL);
    WriteFile(herr, (PVOID)s, strlen(s), &nwritten, NULL);
    WriteFile(herr, "\r\n", 2, &nwritten, NULL);
}

/* The following function is present only for compatibility with CLASSLIBS.
 */
void _RTLENTRY _EXPFUNC __ErrorMessage(const char *s)
{
    _ErrorMessage(s);
}


/*-----------------------------------------------------------------------*

Name            _ErrorExit - print an error message to console

Usage           void _ErrorExit(const char *s);

Prototype in    _io.h

Description     _ErrorExit writes the specified string to the
		console device.  If the program is running on
		a windowing system, a pop-up message box is displayed.
		Otherwise, the message is displayed on the screen,
		preceded and followed by newlines.

Return value    None.

*------------------------------------------------------------------------*/

void _EXPFUNC _ErrorExit(const char *s)
{
    _ErrorMessage(s);
    _exit(1);
}
