/* menu definition file for $2MENUB.C */

/* Written by David Gwillim  8 June 1990  */
/* Copyright (C) 1990 by David Gwillim    */

  /*************************************************************************/
  /* Each entry in the menu requires a menu entry and a matching command.  */
  /* If a command is preceded by a 'c' then the screen will be cleared     */
  /* by $2MENU.COM before running it. If there is 'p' preceeding the       */
  /* command then $2MENU.COM will insert a DOS pause command in the        */
  /* working batch file. This is for use with programs that write          */
  /* to the screen and then exit to DOS, so that the output can be viewed. */
  /* You may directly execute a batch file as a menu command as the work   */
  /* batch file is CALLed by the main batch file running $2MENU and can    */
  /* regain control when the application batch file completes.             */
  /* The last menu entry MUST be a null string.                            */
  /*************************************************************************/

#define MENU01 (char *) 0
#define MENU02 (char *) 1
#define MENU03 (char *) 2
#define MAXMENU 2

char *menu01[] =
  {
    /* MENU TITLE */
   " SAMPLE MENU ",
    /* MENU ENTRY */           /* MENU COMMAND */
   "XyWrite III Plus WP",     "",     "c EDITOR",
   "Turbo Power MAKEMENU",    "",     " C:\\BIN\\MAKEMENU", /* note \\ for \ */
   "Paradox Database",        "",     " @PARADOX",
   "QEDIT Editor",            "",     "c@Q",    /* CLS before running */
   "LIST File Browser",       "",     " @LIST",
   "PMAP Memory Map Utility", "",     "p@PMAP", /* CLS, PAUSE after running */
   ">> SUBMENU TWO",          MENU02, "",
   ">> SUBMENU THREE",        MENU03, "",

   ""  /* menu list MUST end with a null string */
  };

char *menu02[] =
  {
    /* MENU TITLE */
    " LEVEL TWO MENU ",
    /* MENU ENTRY */           /* MENU COMMAND */
    "Menu Entry One",         "",                   "p@dir /w",
    "Menu Entry Two",         "",                   "p@dir",
    ">> MAIN MENU",           MENU01,               "",

    ""   /* menu list MUST end with a null string */
  };

char *menu03[] =
  {
    /* MENU TITLE */
    " LEVEL THREE MENU ",
    /* MENU ENTRY */           /* MENU COMMAND */
    "Menu Entry Three",       "",             "p@dir /w",
    "Menu Entry Four",        "",             "p@dir",
    ">> MAIN MENU",           MENU01,         "",

    ""   /* menu list MUST end with a null string */
  };

char **menu[] = {menu01,menu02,menu03,NULL};

    /* see boxchar[] definition in drawbox.c for box line styles */

                               /* Color  Mono */
unsigned char MenuTitleColor[2] = {0x1E, 0x70}; /* color for the title        */
unsigned char MenuTitleLine[2]  = {   0,    0}; /* title pos (0=menu box top) */

unsigned char ScrnColor[2]      = {0x71, 0x07}; /* color of the screen        */
unsigned char ScrnChar[2]       = { '',  ' '}; /* fill character for screen  */
unsigned char ScrnBoxColor[2]   = {0x11, 0x07}; /* color of box around screen */
unsigned char ScrnBoxStyle[2]   = {   4,    0}; /* box style for above        */

unsigned char MenuColor[2]      = {0x4F, 0x70}; /* color for menu entries     */
unsigned char MenuBoxColor[2]   = {0x4E, 0x70}; /* color for box around them  */
unsigned char MenuBoxStyle[2]   = {   1,    1}; /* box style for above        */

unsigned char MenuBorderTop[2]  = {   2,    1}; /* space above menu items     */
unsigned char MenuBorderBot[2]  = {   2,    1}; /* space below menu items     */
unsigned char MenuBorderLt[2]   = {   6,    4}; /* spaces to the left         */
unsigned char MenuBorderRt[2]   = {   6,    4}; /* spaces to the right        */

unsigned char LightBarColor[2]  = {0x2F, 0x07}; /* color for the light bar    */

