/* MEMRLS.C releasing the memory above the data segment end   */
/* in a COM format program requires that the stack be shifted */
/* below that point first, or you will crash the system!      */

/* Copyright (C) 1990 by David Gwillim    */
/* Released as part of the $2MENU package */

#pragma inline

/* need to declare the Turbo C compiler's special inline function */
/* so the compiler doesn't complain.                              */
void cdecl __int__(int intnum);

/* this global is defined in TEENY.ASM in segment _BSSEND   */
/* and is located at the first paragraph boundary following */
/* the static data segments (_DATA and _BSS) of the program */
extern unsigned int _ENDDATA;

int memrls()
{
   /* tell DOS to release all memory above our data segment */
   /* compute paragraphs to keep value */
   _BX = (int) &_ENDDATA;
   _BX >>= 4;
   _AX = 0x4A00;
   /* call DOS */
   __int__(0x21);

   /* check if there was a problem */
   asm jc error
   return(0);

   error:
   return(1);
}

