/* EXEC.C the bare minimum DOS exec call  */
/* Copyright (C) 1990 by David Gwillim    */
/* Released as part of the $2MENU package */

#pragma inline

/* need to declare Turbo C compiler's special inline function */
/* so the compiler doesn't complain.                          */
void cdecl __int__(int intnum);

/* this program's first default fcb PSP offset */
#define FCB1OFS  0x005C

int exec(char *progname,char *cmdtail)
{
   /* parameter block for the DOS exec function */
   struct
     {
       /* all declared as int to make the */
       /* assignments easier in the code  */
       unsigned int envseg;
       unsigned int cmdtailofs;
       unsigned int cmdtailseg;
       unsigned int fcb1ofs;
       unsigned int fcb1seg;
       unsigned int fcb2ofs;
       unsigned int fcb2seg;
     } execparmblk;
   unsigned char doscmdtail[80];
   int n;

   /* convert the command tail to the format DOS expects */
   n = 0;
   while (cmdtail[n] != 0 && n < 79)
   {
      doscmdtail[n+1] = cmdtail[n++];
   }
   doscmdtail[0] = (char) n;
   doscmdtail[++n] = '\r';

   execparmblk.envseg = 0;
   (char *) execparmblk.cmdtailofs = doscmdtail;
   execparmblk.cmdtailseg = _CS;
   execparmblk.fcb1seg    = _CS;
   execparmblk.fcb1ofs    = FCB1OFS;  /* re-use parent's FCB to save space */
   execparmblk.fcb2seg    = _CS;
   execparmblk.fcb2ofs    = FCB1OFS;  /* re-use parent's FCB to save space */

   /* Normally in a .COM file we can assume CS=DS=SS=ES */
   /* unless we have directly fiddled with any of them, */
   /* but just in case we forgot what we did ...        */
   asm push cs
   asm pop es

   /* tell DOS to do the exec call */
   _BX = (int) &execparmblk;
   _DX = (int) progname;
   _AX = 0x4B00;
   /* call DOS */
   __int__(0x21);

   /* check for problems */
   asm jc error
   return(0);

   error:
   return(_AX);
}

