; FPUTSH.ASM is a replacement for the standard C function fputs() to work
; with TEENY.ASM Turbo C minimum startup code, as the standard fputs()
; requires support from the normal startup code.

; written by David Gwillim  28 May 1990
; Copyright (C) 1990 by David Gwilim

; Distributed as part of the $2MENU package

; declare the standard Turbo C segments
_DATA	SEGMENT WORD PUBLIC 'DATA'
_DATA	ENDS
_BSS	SEGMENT WORD PUBLIC 'BSS'
_BSS	ENDS

; declare the standard Tiny model group
DGROUP  GROUP   _TEXT, _DATA, _BSS

; declare our functions public so we can use it
; in our C code as puts()
public _fputsh

extrn _strlen:near

_TEXT segment byte PUBLIC 'CODE'
assume cs:_TEXT,ds:DGROUP

_fputsh proc near
; string pointer parameter equate
StrToPrint equ [bp+4]
Handle     equ [bp+6]

   push bp                ; save environment
   mov bp,sp
   push si                ; save register we'll use

; this is the TEENY model so we assume all strings will be
; allocated space in _DATA and so can be accessed with a near
; pointer. TEENY.ASM does not have any support for dynamic
; memory allocation.

   mov dx,StrToPrint      ; point to string

; first, find the length of the string we have to print

   push dx
   call _strlen
   add sp,2        ; remove passed parameter
   push ax         ; save the string length to return as function result
   mov cx,ax

; when we get to here cx contains the string length

   mov bx,Handle          ; file handle to use
   mov ah,40h             ; DOS write to file/device function
   int 21h                ; write the string

   pop ax                 ; string length is function result

   pop si                 ; restore register
   mov sp,bp              ; restore environment
   pop bp
   ret

_fputsh endp

_TEXT ends
end
