; STRLEN.ASM

; Teeny model _strlen

; written by David Gwillim  28 May 1990
; Copyright (C) 1990 by David Gwillim

; Distributed as part of the $2MENU package

; declare the standard Turbo C segments
_DATA	SEGMENT WORD PUBLIC 'DATA'
_DATA	ENDS
_BSS	SEGMENT WORD PUBLIC 'BSS'
_BSS	ENDS

; declare the standard Tiny model group
DGROUP  GROUP   _TEXT, _DATA, _BSS

; declare our functions public so we can use it
; in our C code as strlen()
public _strlen

_TEXT segment byte PUBLIC 'CODE'
assume cs:_TEXT,ds:DGROUP

_strlen proc near
; string pointer parameter equate
StrToSize equ [bp+4]

   push bp                ; save environment
   mov bp,sp
   push si                ; save register we'll use

   mov si,StrToSize       ; get the string offset
   sub cx,cx              ; set string length to 0

L1:
   lodsb                  ; put in al the character pointed to by ds:si
   cmp al,0               ; is it a 0? (end of string)
   je L2                  ; if yes, we have the string length in cx
   inc cx                 ; if no, increment string length
   jmp L1                 ; and keep going

L2:
   mov ax,cx              ; return the length in ax

   pop si                 ; restore register
   mov sp,bp              ; restore environment
   pop bp
   ret
_strlen endp

_TEXT ends
end
