/* $2MENU.C */
/* Copyright (C) 1990 by David Gwillim */

/* Comment this next line out to use exec() instead of batch file approach */
/* #define BATCH 1 */

#define UpArrow  0x4800
#define DnArrow  0x5000
#define PgUp     0x4900
#define PgDn     0x5100
#define EscKey   0x011B
#define EnterKey 0x1C0D

#define NULL (void *)0

#define TRUE  1
#define FALSE 0

#define STDOUT 1
#define STDERR 2

#define Color 0
#define Mono  1

/* functions in TEENYLIB.LIB */
int fputsh(char *str,int handle);                 /* FPUTSH.ASM */
int strlen(char *str);                            /* STRLEN.ASM */
void exit(unsigned char ExitCode);                /* EXIT.C     */
unsigned int bioskey();                           /* BIOSKEY.C  */
void initscrn(void);                              /* INITSCRN.C */
void clrwin(int x1, int y1, int x2, int y2,       /* CLRWIN.C   */
            int c, int att);
void drawbox(int x1, int y1, int x2, int y2,      /* DRAWBOX.C  */
             int style, int att);
void fastwrite(char *str, int row, int col,       /* FASTWRIT.C */
               int att);
void gotoxy(char x, char y);                      /* GOTOXY.C   */
void setatt(int x1, int y1, int x2, int y2,       /* SETATT.C   */
            int att);
unsigned int dosversion();                        /* DOSVER.C   */
int exec(char *program, char *cmdtail);           /* EXEC.C     */
int memrls();                                     /* MEMRLS.C   */

/* global variables in TEENYLIB.LIB */
extern unsigned int far *scrnptr;                 /* INITSCRN.C */
extern int scrn;                                  /* INITSCRN.C */
extern int cols_per_row;                          /* INITSCRN.C */
extern int rows_on_scrn;                          /* INITSCRN.C */


unsigned char oldScrnColor;     /* for saving the DOS screen attribute */

#ifdef BATCH
  #include "menudatb.c"           /* definition for menu */
#else
  #include "menudatx.c"           /* definition for menu */
#endif

/************
 * drawmenu *
 ************/
int drawmenu(int m)
{

   int n;
   int key;
   int x,y,l,lmax;
   int xl,yl;
   int startx,starty;
   int menucount;
   int selection;

   selection = 0;

   ReDraw:
   /* draw the box around the edge of the screen */
   /* if some attribute other than 0x00 is specified for it */
   if (ScrnBoxColor[scrn] != 0)
   {
      drawbox(1,1,cols_per_row,rows_on_scrn,ScrnBoxStyle[scrn],
              ScrnBoxColor[scrn]);
      /* clear the screen inside box */
      clrwin(2,2,cols_per_row-1,rows_on_scrn-1,ScrnChar[scrn],ScrnColor[scrn]);
   }
   else
      /* clear the whole screen */
      clrwin(1,1,cols_per_row,rows_on_scrn,ScrnChar[scrn],ScrnColor[scrn]);

   /* find the longest string in the menu */
   /* and count the number of menu items  */
   lmax = 0;
   menucount = 0;
   n = 1;           /* the first actual menu entry is menu[m][1] */
   while ((l=strlen(menu[m][n])) != 0)
   {
      if (l > lmax) lmax = l;
      n += 3;                 /* skip over the commands in the array */
      menucount++;
   }

   /* check if the menu title is longer than the longest entry  */
   /* and if it is going to be positioned at the top of the box */
   /* we need to make the box long enough to fit.               */
   l = strlen(menu[m][0]);
   if (l > lmax  &&  MenuTitleLine[scrn] == 0) lmax = l;

   lmax++;    /* save on arithmetic later on */

   /* center the menu on the screen */
   startx = ((cols_per_row - lmax+2) >> 1);
   starty = ((rows_on_scrn - menucount+2) >> 1);

   /* check the border parameters for validity */
   x = startx-2-MenuBorderLt[scrn];
   if (x < 1) x = 1;
   y = starty-1-MenuBorderTop[scrn];
   if (y < 1) y = 1;
   xl = startx+lmax+MenuBorderRt[scrn];
   if (xl > cols_per_row) xl = cols_per_row;
   yl = starty+menucount+MenuBorderBot[scrn];
   if (yl > rows_on_scrn) yl = rows_on_scrn;

   /* set the attribute for the menu background */
   clrwin(x,y,xl,yl,' ',MenuColor[scrn]);

   /* draw a box around the menu if an attribute other */
   /* than 0x00 is specified for it */
   if (MenuBoxColor[scrn] != 0)
      drawbox(x,y,xl,yl,MenuBoxStyle[scrn],MenuBoxColor[scrn]);

   /* write the menu title if it is not a null string */
   if (menu[m][0][0] != 0)
   {
      x = ((cols_per_row - strlen(menu[m][0])+1) >> 1);
      if (MenuTitleLine[scrn] == 0)
         fastwrite(menu[m][0],y,x,MenuTitleColor[scrn]);
      else
         fastwrite(menu[m][0],MenuTitleLine[scrn],x,MenuTitleColor[scrn]);
   }

   /* draw in the menu items */
   for (n = 0; n < menucount; n++)
      fastwrite(menu[m][(n << 1) + n + 1],starty+n,startx,MenuColor[scrn]);

   /* set the lightbar on the first entry */
   x = startx-1;
   y = starty + selection;
   setatt(x,y,x+lmax,y,LightBarColor[scrn]);

   /* check for keystrokes and respond appropriately */
   while (TRUE)
   {
      key = bioskey();
      switch (key)
      {
        case UpArrow:
           setatt(x,y,x+lmax,y,MenuColor[scrn]);
           if (selection-1 < 0)
           {
              y = starty + menucount - 1;
              selection = menucount - 1;
           }
           else y = starty + --selection;
           setatt(x,y,x+lmax,y,LightBarColor[scrn]);
           break;
        case DnArrow:
           setatt(x,y,x+lmax,y,MenuColor[scrn]);
           if (selection+1 >= menucount)
           {
              y = starty;
              selection = 0;
           }
           else y = starty + ++selection;
           setatt(x,y,x+lmax,y,LightBarColor[scrn]);
           break;
        case PgDn:
           if (menu[m+1] != NULL) return(++m);
           break;
        case PgUp:
           if (m != 0) return(--m);
           break;
        case EscKey:
           clrwin(1,1,cols_per_row,rows_on_scrn,' ',oldScrnColor);
           gotoxy(1,1);
           exit(1);
        case EnterKey:
           /* compute the index for the program and command tail strings */
           n = (selection << 1) + selection + 2;

           /* see if this is a sub-menu link, if so return new menu number */
           if (menu[m][n+1][0] == 0)
              return((int) menu[m][n]);

           /* make the menu selection blink when selected */
           setatt(x,y,x+lmax,y,0x80+LightBarColor[scrn]);

           /* clear the screen if the command tail is flagged for it */
           /* or a pause command.                                    */
           if (menu[m][n+1][0] == 'c' || menu[m][n+1][0] == 'p')
              clrwin(1,1,cols_per_row,rows_on_scrn,' ',oldScrnColor);
           /* "un-lose" the cursor */
           gotoxy(1,1);

#ifdef BATCH
           fputsh(&menu[m][n+1][1],STDOUT);
           fputsh("\r\n",STDOUT);
           if (menu[m][n+1][0] == 'p')
              fputsh("@PAUSE\r\n",STDOUT);
           if (menu[m][n+1][0] == 'c' || menu[m][n+1][0] == 'p' )
              clrwin(1,1,cols_per_row,rows_on_scrn,' ',oldScrnColor);
           gotoxy(1,1);
           exit(0);
#else
           if (exec(menu[m][n],&menu[m][n+1][1]) != 0)
           {
              /* if the exec fails, show the failing command */
              fputsh("\x7",STDERR);
              fputsh(menu[m][n],STDERR);
              fputsh(" ",STDERR);
              fputsh(menu[m][n+1],STDERR);
              bioskey();
           }

           /* pause before redrawing menu if command tail is so flagged */
           if (menu[m][n+1][0] == 'p')
           {
              fputsh("\x10 Press any key \x11",STDERR);
              bioskey();
           }
           /* park the cursor off where we can't see it */
           gotoxy(rows_on_scrn,cols_per_row+1);

           goto ReDraw;
#endif
        default:;
      }
   }
}

/********
 * main *
 ********/

void main(void)
{
   /* "safe" variable located in the data segment, as it is initialized */
   int menunum = 0;

   /* this is code for reading the DOS command line */
   /* not used right now */
   /*
   unsigned char *cmdlin = (unsigned char*) 0x0080;

   if (cmdlin[0] > 2)
   {
     cmdlin[cmdlin[0]] = 0;
     cmdlin += 2;
   }
   else cmdlin[0] = 0;
   */

#ifndef BATCH
   /****************************************************************/
   /*  * W A R N I N G *  Do not allocate ANY automatic (stack)    */
   /*  * W A R N I N G *  variables in main() as we are swapping   */
   /*  * W A R N I N G *  to an internal stack and any BP relative */
   /*  *               *  offsets for these variables generated by */
   /*  *  TO WOULD-BE  *  the compiler will be invalid as BP will  */
   /*  *  MODIFIERS OF *  still pointing to the old stack offset   */
   /*  *  THIS PART OF *  set by the DOS loader.                   */
   /*  *  $2MENU.C     *  Exit the program ONLY via exit() so you  */
   /*  *               *  are not dependent on the stack contents  */
   /*  * W A R N I N G *  for a return to DOS via PSP[0].          */
   /*  * W A R N I N G *  This is the price you pay for trying to  */
   /*  * W A R N I N G *  minimize your RAM overhead!!!            */
   /****************************************************************/

   /* swap to an internal stack in the default DTA space so we can */
   /* use the memory space above our data segment contiguously.    */
   _SP = 0x00FE;

   /* exec() isn't saving the registers so DOS 2.x would crash */
   if (dosversion() < 0x0300)
   {
      fputsh("Need DOS 3.x/4.x\x7\r\n",STDERR);
      exit(1);
   }

   /* release the memory above the data segment */
   if (memrls() != 0) exit(2);
#endif

   /* initialize the globals for direct screen writes */
   initscrn();

   /* park the cursor off where we can't see it */
   gotoxy(rows_on_scrn,cols_per_row+1);

   /* remember the color of screen we started with */
   /* so we can restore it. Use x=1, y=1 location  */
   oldScrnColor = *(scrnptr) >> 8;

   /* main program loop */
   while (menunum != -1)
      menunum = drawmenu(menunum);

   exit(0);
}

