#include <stdio.h>
#include <dos.h>
#include "timer.h"

#ifdef TEST
main()
{
long t1,t2;
double time;

  initializetimer();

  t1 = readtimer();
  t2 = readtimer();
  elapsedtime(t1,t2,&time);
  printf("\nelapsed time (no delay) = %f\n",time);

  t1 = readtimer();
  delay(1);
  t2 = readtimer();
  elapsedtime(t1,t2,&time);
  printf("\nelapsed time (1 msec) = %f\n",time);

  t1 = readtimer();
  delay(20);
  t2 = readtimer();
  elapsedtime(t1,t2,&time);
  printf("\nelapsed time (20 msec) = %f\n",time);

  t1 = readtimer();
  delay(1000);
  t2 = readtimer();
  elapsedtime(t1,t2,&time);
  printf("\nelapsed time (1000 msec) = %f\n",time);

  printf("\npress a key to start/stop timer");
  while (!kbhit()); getch();
  t1 = readtimer();
  while (!kbhit()); getch();
  t2 = readtimer();
  elapsedtime(t1,t2,&time);
  printf("\nelapsed time = %f\n",time);

  restoretimer();
}
#endif /* TEST */

#define TimerResolution    1193181.667

void cardinal(long l, double *result)
{
  *result = ((l < 0) ? 4294967296.0 + (long) l : (long) l);
}

void elapsedtime(long start, long stop, double *result)
{
  double r;

  cardinal(stop - start,&r);
  *result = (1000.0 * r) / TimerResolution;
}

void initializetimer(void)
{

  outp(0x043,0x034);
  outp(0x040,0x000);
  outp(0x040,0x000);

}

void restoretimer(void)
{
  outp(0x043,0x036);
  outp(0x040,0x000);
  outp(0x040,0x000);

}

long readtimer(void)
{
__asm{
   cli                 /* Disable interrupts */
   mov  dx,020h        /* Address PIC ocw3   */
   mov  al,00Ah        /* Ask to read irr    */
   out  dx,al
   mov  al,00h         /* Latch timer 0 */
   out  043h,al
   in   al,dx          /* Read irr      */
   mov  di,ax          /* Save it in DI */
   in   al,040h        /* Counter --> bx*/
   mov  bl,al          /* LSB in BL     */
   in   al,040h
   mov  bh,al          /* MSB in BH     */
   not  bx             /* Need ascending counter */
   in   al,021h        /* Read PIC imr  */
   mov  si,ax          /* Save it in SI */
   mov  al,00FFh       /* Mask all interrupts */
   out  021h,al
   mov  ax,040h         /* read low word of time */
   mov  es,ax           /* from BIOS data area   */
   mov  dx,es:[06Ch]
   mov  ax,si           /* Restore imr from SI   */
   out  021h,al
   sti                  /* Enable interrupts */
   mov  ax,di           /* Retrieve old irr  */
   test al,001h         /* Counter hit 0?    */
   jz   done            /* Jump if not       */
   cmp  bx,0FFh         /* Counter > 0x0FF?    */
   ja   done            /* Done if so        */
   inc  dx              /* Else count int req. */
done:
   mov ax,bx            /* set function result */
   }
}

void delay(int ms)
{
long t;

   t = readtimer()+TimerResolution*ms/1000.00;
   while(readtimer()<t);
}
