* System       : <Fill it in>
* File         : zWINDOW.prg (Black Box)
* Called from  : Everywhere
* Description  : Pop's a window with shadow at caller specified location/color
* Databases    : None
* Calls        : None
* UDF Calls    : none
* Written      : 03/17/89 DKA
* Tested       :
* Parameters   : <top>,<left>,<bottom>,<right>,<color>,<border>,<shadow>
* Requirements : none - may use sCOLOR, see NOTE below.
*

******************************** NOTES ********************************
* COMMENTS:      Program will reset color to previous setting prior to return.
*
*                The GROW BOX code is currently remarked out.  This is because
*                on an IBM XT, the grow window was to slow.  Therefore I just
*                Use a clear to command, then put in shading.  For boxes to 
*                grow, just unremark lines 224 - 256.
*                
*                Also, I have two different shading routines in here.  You
*                can unremark whichever one you would like to use.  The current
*                one unremarked is the fastest on the XT, but the other one does
*                true shadowing of the background screen (Lines 270-298 & 300-363).
*
* PARAMETERS:    All parameters are REQUIRED.  You must pass something.
*      <Top>    - Numeric.  Top of box.
*      <Left>   - Numeric.  Left side of box.
*      <Bottom> - Numeric.  Bottom of box.
*      <Right>  - Numeric.  Right side of box.
*      <Color>  - Character.  Color to use for box and border.  Pass "" to use
*                 current color setting.
*      <Border> - Numeric.  Border Type  - 0 = none
*                                          1 = single line
*                                          2 = double line
*      <Shadow> - Numeric.  Shading Type - 0 = none
*                                          1 = Left
*                                          2 = Center
*                                          3 = Right
*
* USAGE: The code below puts up a red box with a white single line border at 
*        row 5, column 10 thats 9 deep and 60 wide, with a shadow along the 
*        bottom and right edges - 
*
*        do zWINDOW with 5,10,19,70,"+w/r",1,3 
*      
******************
*
******************************** NOTES ********************************

**** Receive passed parameters.
parameters mPARAM1,mPARAM2,mPARAM3,mPARAM4,mPARAM5,mPARAM6,mPARAM7

**** Private internal variables.
private mVAR
private mTOP,mLEFT,mBOTTOM,mRIGHT,mCOLOR,mBORDER,mSHADOW
private mTOP2,mLEFT2,mBOTTOM2,mRIGHT2
private mCOL,mCOLOR_OLD
private mCOUNT

**** Must pass 7 parameters
if pcount() # 7
   do zMESSAGE with "Invalid number of parameters, press any key...","+w/r"
   mVAR = inkey(0)
endif

**** Store passed parameters to variables.
mTOP    = mPARAM1
mLEFT   = mPARAM2
mBOTTOM = mPARAM3
mRIGHT  = mPARAM4
mCOLOR  = mPARAM5
mBORDER = mPARAM6
mSHADOW = mPARAM7

**** Ensure that each recieved parameter is right TYPE (from DOS, everything is CHAR!)
if type("mTOP") = "C"
   mTOP = val(mTOP)
endif
if type("mLEFT") = "C"
   mLEFT = val(mLEFT)
endif
if type("mBOTTOM") = "C"
   mBOTTOM = val(mBOTTOM)
endif
if type("mRIGHT") = "C"
   mRIGHT = val(mRIGHT)
endif
if type("mBORDER") = "C"
   mBORDER = val(mBORDER)
endif
if type("mSHADOW") = "C"
   mSHADOW = val(mSHADOW)
endif


**** Check for bad parameters - split up the if for readability.
if mTOP>mBOTTOM.or.;
   mLEFT>mRIGHT.or.;
   mLEFT<0.or.mLEFT>80.or.;
   mRIGHT<0.or.mRIGHT>80.or.;
   mTOP<0.or.mTOP>24.or.;
   mBOTTOM<0.or.mBOTTOM>24.or.;
   mBORDER<0.or.mBORDER>2.or.;
   mSHADOW<0.or.mSHADOW>3.or.;
   type("mCOLOR")<>"C"

   * What an if statement!  Phew!!!

   * Clear the screen to a lovely BLOOD red.
   set color to +w/r
   clear

   * Beep them they did something wrong.
   tone(880,6)

   * Display what they tried to use.
   @ 1,5 say "    PARAMETERS"
   @ 3,5 say "Top    " + chr(16) + " " + alltrim(str(mTOP))
   @ 4,5 say "Left   " + chr(16) + " " + alltrim(str(mLEFT))
   @ 5,5 say "Bottom " + chr(16) + " " + alltrim(str(mBOTTOM))
   @ 6,5 say "Right  " + chr(16) + " " + alltrim(str(mRIGHT))
   @ 7,5 say "Color  " + chr(16) + " " + iif(type("mCOLOR")="C",mCOLOR,"<- Invalid")
   @ 8,5 say "Border " + chr(16) + " " + iif(mBORDER=0,"None",iif(mBORDER=1,"Single",iif(mBORDER=2,"Double",alltrim(str(mBORDER)))))
   @ 9,5 say "Shadow " + chr(16) + " " + iif(mSHADOW=0,"None",iif(mSHADOW=1,"Left",iif(mSHADOW=2,"Centered",iif(mSHADOW=3,"Right",alltrim(str(mBORDER))))))

   * Tell them why they couldn't, lots of different possibilities!!!!
   mCOL = 11
   if mTOP > mBOTTOM
      @ mCOL,30  say "Top is below the bottom!"
      mCOL = mCOL + 1
      @ 3,25 say "<- INVALID"
      @ 5,25 say "<- INVALID"
   endif
   if mLEFT > mRIGHT
      @ mCOL,30  say "Left side to right of right side!"
      mCOL = mCOL + 1
      @ 4,25 say "<- INVALID"
      @ 6,25 say "<- INVALID"
   endif
   if mLEFT < 0 .or. mRIGHT < 0
      if mLEFT < 0
         @ 4,25 say "<- INVALID"
         @ mCOL,30  say "Left side off the screen, dude!"
         mCOL = mCOL + 1
      endif
      if mRIGHT < 0
         @ 6,25 say "<- INVALID"
         @ mCOL,30  say "Right side off the screen, dude!"
         mCOL = mCOL + 1
      endif
   endif
   if mRIGHT > 80 .or. mLEFT > 80
      @ mCOL,30 say "Sorry, 80 column monitor support only!"
      mCOL = mCOL + 1
      if mLEFT > 80
         @ 4,25 say "<- INVALID"
      endif
      if mRIGHT > 80
         @ 6,25 say "<- INVALID"
      endif
   endif
   if mTOP < 0 .or. mBOTTOM < 0
      if mTOP < 0
         @ 3,25 say "<- INVALID"
         @ mCOL,30 say "Top is to far up."
         mCOL = mCOL + 1
      endif
      if mBOTTOM < 0
         @ 5,25 say "<- INVALID"
         @ mCOL,30 say "Bottom is to far up."
         mCOL = mCOL + 1
      endif
   endif
   if mBOTTOM > 24 .or. mTOP > 24
      if mTOP > 24
         @ 3,25 say "<- INVALID"
         @ mCOL,30 say "Top is below bottom of screen, dude!"
         mCOL = mCOL + 1
      endif
      if mBOTTOM > 24
         @ 5,25 say "<- INVALID"
         @ mCOL,30 say "Bottom would be off the screen, dude!"
         mCOL = mCOL + 1
      endif
   endif
   if type("mCOLOR") <> "C"
      @ mCOL,30 say "The color setting must be passed as STRING."
      mCOL = mCOL + 1
      @ mCOL,30 say '(ie "+w/r", or "r/n", or whatever!)' 
      mCOL = mCOL + 1
   endif
   if mBORDER < 0 .or. mBORDER > 2
      @ mCOL,30 say "Please use 0, 1 or 2 for the border."
      mCOL = mCOL + 1
      @ mCOL,30 say "  (None, single line, double line)"
      mCOL = mCOL + 1
      @ 8,25 say "<- INVALID"
   endif
   if mSHADOW < 0 .or. mSHADOW > 3
      @ mCOL,30 say "Please use 0, 1, 2 or 3 for the shadow."
      mCOL = mCOL + 1
      @ mCOL,30 say "  (None, Throw Left, Throw Center, Throw Right)"
      mCOL = mCOL + 1
      @ 9,25 say "<- INVALID"
   endif

   * Put cursor on 20th line and cancel ("do cancelled" will appear there).
   @ 20,0 say ""
   cancel
endif

**** Okay, everything passed parameter checking, lets do the box

** Set up internal variables
* Store calling programs color setting for restoration prior to return.
mCOLOR_OLD = setcolor()   && sys(2001,"COLOR")
* If they passed a color, try to set to that color.  NOTE IF YOU PASS A BAD ONE, PROGRAM WILL CRASH!
if mCOLOR > "!"
   set color to (mCOLOR)
endif

************ GROWTH CODE REMARKED OUT ...
* 
* * Set beginning coordinates to a dot in the center of the requested POP area.
* mTOP2    = mTOP  + int((mBOTTOM-mTOP)/2)
* mLEFT2   = mLEFT + int((mRIGHT-mLEFT)/2)
* mBOTTOM2 = mTOP  + int((mBOTTOM-mTOP)/2)
* mRIGHT2  = mLEFT + int((mRIGHT-mLEFT)/2)
* 
* ** Expand BOX till you reach full size, starting in center of specs.
* do while mLEFT2>mLEFT .or. mTOP2>mTOP .or. mBOTTOM2<mBOTTOM .or. mRIGHT2<mRIGHT
*    * Clear the growing region
*    @ mTOP2,mLEFT2 clear to mBOTTOM2,mRIGHT2
*    * Increment the temp counters for position up/down by one
*    if mTOP2 > mTOP
*       mTOP2=mTOP2-1
*    endif
*    if mBOTTOM2 < mBOTTOM
*       mBOTTOM2=mBOTTOM2+1
*    endif
*    * Increment the left/right counters by two, making sure they don't go past.
*    if mLEFT2 > mLEFT
*       mLEFT2 = mLEFT2 - 2
*       if mLEFT2 < mLEFT
*          mLEFT2 = mLEFT
*       endif
*    endif
*    if mRIGHT2 < mRIGHT
*       mRIGHT2 = mRIGHT2 + 2
*       if mRIGHT2 > mRIGHT
*          mRIGHT2 = mRIGHT
*       endif
*    endif
* enddo

** Draw the full box.
@ mTOP,mLEFT clear to mBOTTOM,mRIGHT

** Draw a border, if requested.
if mBORDER > 0
   if mBORDER = 2
      @ mTOP,mLEFT to mBOTTOM,mRIGHT double
   else
      @ mTOP,mLEFT to mBOTTOM,mRIGHT
   endif
endif

**************** SHADING WITH @ CLEAR TO CODE
** Create that 3d awesome effect, if requested.
Do Case
   * Throw shadow left - first the left side, then the bottom - if there is room on screen for it.
   case mSHADOW = 1 .and. mLEFT > 1 .and. mBOTTOM < 24
      set color to w/n
      if mTOP <> mBOTTOM                            && No shadow on single line boxes.
         @ mTOP+1,mLEFT-2 clear to mBOTTOM,mLEFT-1
      endif
      if mLEFT <> mRIGHT                            && No shadow on single column boxes.
         @ mBOTTOM+1,mLEFT-2 clear to mBOTTOM+1,mRIGHT-2
      endif
   * Throw shadow CENTERED - just the bottom - if there is room on screen for it.
   case mSHADOW = 2 .and. mBOTTOM < 24
      set color to w/n                              && No shadow on single column boxes.
      if (mLEFT+2) < (mRIGHT-2)
         @ mBOTTOM+1,mLEFT+2 clear to mBOTTOM+1,mRIGHT-2
      endif
   * Throw shadow right - first the right side, then the bottom - if there is room on screen for it.
   case mSHADOW = 3 .and. mRIGHT < 79 .and. mBOTTOM < 24
      set color to w/n
      if mTOP <> mBOTTOM                            && No shadow on single line boxes.
         @ mTOP+1,mRIGHT+1 clear to mBOTTOM,mRIGHT+2
      endif
      if mLEFT <> mRIGHT                            && No shadow on single column boxes.
         @ mBOTTOM+1,mLEFT+2 clear to mBOTTOM+1,mRIGHT+2
      endif
endcase
**************** 

**************** SHADING WITH CHANGING COLOR ATTRIBUTE OF BACKGROUND SCREEN ***************
*
* Inspired by Nantucket News, 10/89, pg 21, "Finishing Touces: Three-Dimensional Windows"
* Thanks Steven Philbrick!!!
*
* ** Create that 3d awesome effect, if requested.
* private mTEMP1,mTEMP2
* mTEMP1 = ""
* mTEMP2 = ""
* Do Case
*    * Throw shadow left - first the left side, then the bottom - if there is room on screen for it.
*    case mSHADOW = 1 .and. mLEFT > 1 .and. mBOTTOM < 24
*       set color to w/n
*       if mTOP <> mBOTTOM                            && No shadow on single line boxes.
*          mTEMP1 = savescreen(mTOP+1,mLEFT-2,mBOTTOM,mLEFT-1)
*          for mCOUNT = 2 to len(mTEMP1) step 2
*             mTEMP1 = stuff(mTEMP1,mCOUNT,1,chr(8))
*          next
*       endif
*       if mLEFT <> mRIGHT                            && No shadow on single column boxes.
*          mTEMP2 = savescreen(mBOTTOM+1,mLEFT-2,mBOTTOM+1,mRIGHT-2)
*          for mCOUNT = 2 to len(mTEMP2) step 2
*             mTEMP2 = stuff(mTEMP2,mCOUNT,1,chr(8))
*          next
*       endif
*       if !mTEMP1==""
*          restscreen(mTOP+1,mLEFT-2,mBOTTOM,mLEFT-1,mTEMP1)
*       endif
*       if !mTEMP2==""
*          restscreen(mBOTTOM+1,mLEFT-2,mBOTTOM+1,mRIGHT-2,mTEMP2)
*       endif
*    * Throw shadow CENTERED - just the bottom - if there is room on screen for it.
*    case mSHADOW = 2 .and. mBOTTOM < 24
*       set color to w/n                              && No shadow on single column boxes.
*       if (mLEFT+2) < (mRIGHT-2)
*          mTEMP1 = savescreen(mBOTTOM+1,mLEFT+2,mBOTTOM+1,mRIGHT-2)
*          for mCOUNT = 2 to len(mTEMP1) step 2
*             mTEMP1 = stuff(mTEMP1,mCOUNT,1,chr(8))
*          next
*          restscreen(mBOTTOM+1,mLEFT+2,mBOTTOM+1,mRIGHT-2,mTEMP1)
*       endif
*    * Throw shadow right - first the right side, then the bottom - if there is room on screen for it.
*    case mSHADOW = 3 .and. mRIGHT < 79 .and. mBOTTOM < 24
*       set color to w/n
*       if mTOP <> mBOTTOM                            && No shadow on single line boxes.
*          mTEMP1 = savescreen(mTOP+1,mRIGHT+1,mBOTTOM,mRIGHT+2)
*          for mCOUNT = 2 to len(mTEMP1) step 2
*             mTEMP1 = stuff(mTEMP1,mCOUNT,1,chr(8))
*          next
*       endif
*       if mLEFT <> mRIGHT                            && No shadow on single column boxes.
*          mTEMP2 = savescreen(mBOTTOM+1,mLEFT+2,mBOTTOM+1,mRIGHT+2)
*          for mCOUNT = 2 to len(mTEMP2) step 2
*             mTEMP2 = stuff(mTEMP2,mCOUNT,1,chr(8))
*          next
*       endif
*       if !mTEMP1==""
*          restscreen(mTOP+1,mRIGHT+1,mBOTTOM,mRIGHT+2,mTEMP1)
*       endif
*       if !mTEMP2==""
*          restscreen(mBOTTOM+1,mLEFT+2,mBOTTOM+1,mRIGHT+2,mTEMP2)
*       endif
* endcase
**************** 

** Reset color to setting prior to call.
set color to (mCOLOR_OLD)
return
