*   USE_UDF function
*
*   Attempts to open a file for network use in either
*   SHARED or EXCLUSIVE use.
*   Parameters used:
*     1. File name (be sure to surround in quotation marks)
*     2. MODE (.T. = EXCLUSIVE .F. = SHARED)
*
*   Example usage:
*      IF USE_UDF("cust", .T.)
*         SET INDEX TO cust,lnam,bal
*      ELSE
*         CLEAR
*         RETURN
*      ENDIF
*

FUNCTION USE_UDF ( datfil, use_mode )
LOCAL delay := 5, lock, conf
IF use_mode =  NIL
	use_mode = .F.
ENDIF

DO WHILE .T.
	
	IF use_mode                       && Attempt to open exclusively.
		USE (datfil) EXCLUSIVE
	ELSE
		USE (DATFIL) SHARED        && Attempt to open in shared
		&& mode.
	ENDIF
	
	IF .NOT. NETERR()                 && File is opened successfully.
		RETURN(.T.)                    && Go back to calling procedure
		
	ELSE
		IF delay > 0
			INKEY(1)
			delay--
			LOOP
		ELSE
			lock := SAVESCREEN(8,15,20,60)
			conf := " "
			@8,15 CLEAR TO 20,60
			@8,15 TO 20,60 DOUBLE
			@10,20 SAY "Data File: " + datfil
			@12,20 SAY "This file is unavailable at this time."
			@14,20 SAY "Do you want to continue attempting"
			@16,20 SAY "to open it for another five seconds?"
			@18,20 SAY "           (Y/N)---->"
			WAIT "" TO CONF
			IF UPPER(conf)="Y"
				delay := 5
				RESTSCREEN(8,15,20,60,lock)
				LOOP
			ELSE
				RESTSCREEN(8,15,20,60,lock)
				RETURN .F.
			ENDIF
		ENDIF
	ENDIF
ENDDO
return nil


*  APND function
*
*  Attempts to append a blank record to the file and lock it.
*  If the append is successful, the function rturns .T.
*
*  Suggested usage:
*  IF .NOT. APND()
*     ...            && Error trapping code to exit the module
*  ENDIF

FUNCTION APND
LOCAL delay := 5, lock, conf

DO WHILE .T.
	
	APPEND BLANK
	IF .NOT. NETERR()
		RETURN .T.
	ENDIF
	
	IF delay > 0
		INKEY(1)
		delay--
		LOOP
	ELSE
		lock := SAVESCREEN(8,15,20,60)
		conf := " "
		@8,15 CLEAR TO 18,60
		@8,15 TO 18,60 DOUBLE
		@10,20 SAY "New record creation was unsuccessful."
		@12,20 SAY "Do you want to continue attempting."
		@14,20 SAY "to add it for another five seconds?"
		@16,20 SAY "             (Y/N)---->"
		WAIT "" TO CONF
		IF UPPER(conf) = "Y"
			delay := 5
			RESTSCREEN(8,15,20,60,lock)
			LOOP
		ELSE
			RESTSCREEN(8,15,20,60,lock)
			RETURN .F.
		ENDIF
	ENDIF
ENDDO
return nil


*  RLOK function
*
*  Attempts to lock the current record for temporary exclusive
*  use. No parameters are needed to be passed.
*
*  Example usage:
*     IF RLOK()
*        REPLACE FIELD1 WITH var1
*        REPLACE FIELD2 WITH var2
*        REPLACE FIELD1 WITH var1
*      ELSE
*        CLEAR
*        RETURN
*      ENDIF

FUNCTION RLOK
LOCAL delay := 5, lock, conf

DO WHILE .T.
	
	IF RLOCK()
		RETURN(.T.)
	ENDIF
	
	IF delay > 0
		INKEY(1)
		delay--
		LOOP
	ELSE
		lock := SAVESCREEN(8,15,20,60)
		conf := " "
		@8,15 CLEAR TO 18,60
		@8,15 TO 18,60 DOUBLE
		@10,20 SAY "Record locking was unsuccessful."
		@12,20 SAY "Do you want to continue attempting."
		@14,20 SAY "to lock it for another five seconds?"
		@16,20 SAY "             (Y/N)---->"
		WAIT "" TO CONF
		IF UPPER(conf) = "Y"
			delay := 5
			RESTSCREEN(8,15,20,60,lock)
			LOOP
		ELSE
			RESTSCREEN(8,15,20,60,lock)
			RETURN .F.
		ENDIF
	ENDIF
ENDDO
return nil


*  FLOK function
*
*  Attempts to lock the current file for temporary exclusive
*  use. No parameters are needed to be passed.
*
*  Example usage:
*     IF FLOK()
*        AVERAGE bal TO avbal FOR bal > 5000
*     ELSE
*        CLEAR
*        RETURN
*     ENDIF

FUNCTION FLOK
LOCAL delay := 5, lock, conf

DO WHILE .T.
	
	IF FLOCK()
		RETURN(.T.)
	ENDIF
	
	IF delay > 0
		INKEY(1)
		delay--
		LOOP
	ELSE
		lock := SAVESCREEN(8,15,20,60)
		conf := " "
		@8,15 CLEAR TO 18,60
		@8,15 TO 18,60 DOUBLE
		@10,20 SAY "File locking was unsccessful."
		@12,20 SAY "Do you want to continue attempting"
		@14,20 SAY "to lock it for another five seconds?"
		@16,20 SAY "             (Y/N)---->"
		WAIT "" TO CONF
		IF UPPER(conf) = "Y"
			delay := 5
			RESTSCREEN(8,15,20,60,lock)
			LOOP
		ELSE
			RESTSCREEN(8,15,20,60,lock)
			RETURN .F.
		ENDIF
	ENDIF
ENDDO
return nil





