/*
**
**  edits.prg
**        Project: Referral   (Striped for Zipcode)
**         Author: James W. Brooks
**        Created: 07/19/93
**    Last Update: 09/08/93
**
*/



/*
Richard, 
  This will update the zipcode file as they go along.  The first
  time they enter a new zipcode it will not find it in the zipcode.dbf.
  When they add the zipcode, city, state and areacode to the client
  it will also add it to the zipcode.dbf.  Soon they will have grown
  a list of zipcodes that they deal with.  You could start them off
  with a complete list of all the zipcodes in the U.S., but I find the 
  search is to slow so I usually grab the fields from another system 
  in the general area and start them with that. (note for this system
  most of the zipcode already in the dbf are from DE 19711,19702, etc.

                                  Comments are appreciated,
                                            Jim 76216,75


  Go to line 320 to see the zipcode Get part and notes.
  Run the M batch file to create this (if you use rtlink)

*/





#include "Dbstruct.ch"

#include 'inkey.ch'
#include 'box.ch'


#define GDISPLAYONLY  0
#define GADD          1
#define GEDIT         2
#define GDEL          3

#define GADDREF       5
#define GEDITREF      6
#define GDELREF       7

#define ECLIENT   1
#define ENAMES    3
#define ESALES    4

static lZipFound := .t.



// function to test zipcode
*************
function main
*************
local cStartColor := setcolor("W+/B,N/W")

if !checkindex(.f.)
	return nil
endif

if !open('Clients',.t.)
	return .f.
endif

select 0

if !open('Zipcodes',.t.)
	return nil
endif

select Clients

EditManager(ECLIENT)
setcolor(cStartColor)
cls
return nil




// this is actually called from within a TBrowse
//  and has 6 EditTypes.  I removed all but Client
//  for clearity.  JIM
******************************
function EditManager(EditType)
******************************
local xbar, ebar, edscrn
local getlist := {}
local sel := select()
local scrn
local lSameClient := .f.
local menuscrn
local topscrn


cls


menuscrn := savescreen(21,14,23,64)

while .t.
	GetClient(GDISPLAYONLY)
	
	
	* 				   "Next"    "Previous"    "Add"    "Edit"
	
	@ 22,20 prompt "Next"
	@ 22,30 prompt "Previous"
	@ 22,44 prompt "Add"
	@ 22,54 prompt "Edit"
	@ 21,14 TO 23,64 DOUBLE
	
	menu to xbar
	
	
	restscreen(21,14,23,64,menuscrn)
	
	do case
	case xbar == 0
		exit
		
	case xbar == 1
		SKIP
		if eof()
			TONE(300, 1)
			skip -1
		endif
		
		
	case xbar == 2
		
		SKIP -1
		if bof()
			TONE(300, 1)
		endif
		
		
	case xbar == 3
		GetClient(GADD)
		
	case xbar == 4
		GetClient(GEDIT)
		
	endcase
	cls
	
	lZipFound := .t.
enddo

select (sel)

if EditType == ECLIENT
	dbunlockall()
endif

return nil







*       ķ
*                                                                
*                        CLIENTS Screen Layout                   
*                                                                
*       Ľ
*


***************************
function GetClient(GetType)
***************************
local nCRecHold, nNewRecHold
local ret := .t.
//Structure for databse: CLIENTS.DBF
//local xRKey         //  N         6         0
local xTitle        //  C        11         0
local xLName        //  C        30         0
local xMi           //  C         1         0
local xFName        //  C        15         0
local xSuffix       //  C         8         0
local xAdd1         //  C        30         0
local xAdd2         //  C        30         0
local xCity         //  C        20         0
local xState        //  C         2         0
local xZip          //  C        10         0
local xHPhone       //  C        13         0
local xWPhone       //  C        13         0
local xContact      //  C        20         0
//xNumRefs          //  N         2         0
local xEnterDate    //  D         8         0

local cName
local cDeptPriority
local nSelectDp  := 0
local cDeptSelect


memvar getlist
private getlist:={}


@ 0, 0 say padc('R E F E R R A L     I N F O R M A T I O N',80)


do case
case GetType = GDISPLAYONLY
	
case GetType = GADD
	xEnterDate  :=  Date()
	nCRecHold:=Clients->(recno())
	
	if !Clients->(apnd())
		Clients->(dbgoto(nCRecHold))
		return .f.
	endif
	
case GetType = GEDIT
	if !Clients->(rlok())
		return .f.
	endif
	
	xEnterdate   :=   Clients->Enterdate
	
case GetType = GDELREF
	if Clients->(Rlok())
		if alert('Are you sure you want to delete this referral',;
			   {'Keep','Delete'})==2
			
			Clients->(dbdelete())
			
		endif
	endif
	return .t.
	
endcase




//xRKey     	 :=   Clients->RKey
xTitle    	 :=   Clients->Title
xLName    	 :=   Clients->LName
xMi       	 :=   Clients->Mi
xFName    	 :=   Clients->FName
xSuffix   	 :=   Clients->Suffix
xAdd1     	 :=   Clients->Add1
xAdd2     	 :=   Clients->Add2
xCity     	 :=   Clients->City
xState    	 :=   Clients->State
xZip      	 :=   Clients->Zip
xHPhone   	 :=   Clients->HPhone
xWPhone   	 :=   Clients->WPhone
xContact  	 :=   Clients->Contact
//xEnterdate   :=   Clients->Enterdate



@ 01,00 TO 3,79

@ 03,40 TO 12,78
@ 09,01 TO 12,39
@ 03,01 TO 09,39



@ 01,02 SAY "Doc No"
@ 01,09 SAY "Title"
@ 01,21 SAY "First"
@ 01,37 SAY "M"
@ 01,39 SAY "Last"
@ 01,70 SAY "Suffix"



@ 04,44 SAY "Existing Cust:   (Y/N/U)"
@ 05,44 SAY "Date Referred:"
@ 06,46 SAY "Referred by:"
@ 07,46 SAY "Employee No:"
@ 08,49 SAY "Phone No:"
@ 09,48 SAY "Center No:"
@ 10,49 SAY "Interest:"
@ 11,43 SAY "Call Ref Prior:"

@ 07,03 SAY "H:"
@ 07,23 SAY "W:"
@ 08,03 SAY "If Bus Contact:"
@ 10,03 SAY " Primary:"
@ 11,03 SAY "Selected:"



@ 02,09 GET xTitle when lastkey() != K_TAB //.and. PickList(,,,,,,'T')
@ 02,21 GET xFName when lastkey() != K_TAB
@ 02,37 GET xMi pict '!' when lastkey() != K_TAB
@ 02,39 GET xLName when lastkey() != K_TAB
@ 02,70 GET xSuffix when lastkey() != K_TAB //.and. PickList(,,,,,,'X')

@ 04,03 GET xAdd1
@ 05,03 GET xAdd2 when lastkey() != K_TAB

/*
-------------------------------------------------------------
THE ZIPCODE PART.  
Note: the zipcode will be edited before
the city and state.  If the zipcode
is initially found they will be put 
on the phone field.
If the zipcode is not found they will 
be put on the city field and the zipcode,
city, state and areacode will be added 
to the zipcode.dbf.  They always have 
the option of uparrowing and changing 
to the city and state fields.  JIM
-------------------------------------------------------------
*/

@ 06,28 GET xZip	  pict '99999-9999' ;
   when lastkey() != K_TAB .and. lastkey() != K_UP ;
   valid LookUpZipCode(xZip,@xCity,@xState,@xHPhone)

@ 06,03 GET xCity when lastkey() != K_TAB
@ 06,24 GET xState pict '!!' when lastkey() != K_TAB
@ 07,05 GET xHPhone pict '(999)999-9999' when lastkey() != K_TAB ;
   valid ZipAdd(xZip,xCity,xState,xHPhone)

//-------------------------------------------------------------



@ 07,25 GET xWPhone pict '(999)999-9999' when lastkey() != K_TAB
@ 08,18 GET xContact when lastkey() != K_TAB


@ 24,00 say padc('F1 - Help',80)


if GetType != GDISPLAYONLY
	
	setcursor(1)
	READ
	setcursor(0)
	
	if lastkey() != K_ESC
		
		//Clients->RKey         :=    xRKey
		Clients->Title        :=    xTitle
		Clients->LName        :=    xLName
		Clients->Mi           :=    xMi
		Clients->FName        :=    xFName
		Clients->Suffix       :=    xSuffix
		Clients->Add1         :=    xAdd1
		Clients->Add2         :=    xAdd2
		Clients->City         :=    xCity
		Clients->State        :=    xState
		Clients->Zip          :=    xZip
		Clients->HPhone       :=    xHPhone
		Clients->WPhone       :=    xWPhone
		Clients->Contact      :=    xContact
		Clients->Enterdate    :=    xEnterdate
		
		
	else
		
		
		if GetType = GADD
			if Clients->(rlok())
				Clients->(dbdelete())
				Clients->(dbgoto(nCRecHold))
			endif
			
			ret := .f.
			
		endif
	endif
	
	
else
	
	clear gets
	
endif

return ret



*************************************************
function LookUpZipCode(xZip,xCity,xState,xHPhone)
*************************************************
if !getactive():Changed()
	return .t.
endif

ZipCodes->(dbseek(xZip,.t.))
if ZipCodes->ZipCode = xZip .or. xZip = ZipCodes->ZipCode
	xCity := ZipCodes->City
	xState := ZipCodes->State
	if empty(substr(xHPhone,2,3))
		xHPhone := '('+ZipCodes->AreaCode+substr(xHPhone,5)
	endif
	keyboard chr(K_ENTER)+chr(K_ENTER)+chr(K_RIGHT)+chr(K_RIGHT)+chr(K_RIGHT)
else
	lZipFound := .f.
endif
return .t.


******************************************
function ZipAdd(xZip,xCity,xState,xHPhone)
******************************************
if !getactive():Changed()
	return .t.
endif

if !lZipFound
	if ZipCodes->(apnd())
		ZipCodes->ZipCode := xZip
		ZipCodes->City := xCity
		ZipCodes->State := xState
		ZipCodes->AreaCode := substr(xHPhone,2,3)
	endif
	lZipFound := .t.
endif
return .t.







************************
function open(file,excl)
************************

file := upper(file)

if !use_udf(file,excl)
	return .f.
endif


do case
	
case file == 'CLIENTS'
	set index to CLIENTS //, RKEY
	
case file == 'ZIPCODES'
	set index to ZIPCODES
	
otherwise
	alert('Programming Error;Opened an unknown file'+file)
	use
	return .f.
	
endcase

return .t.





******************************
function CheckIndex(lAllFiles)
******************************
local oldcolor := setcolor("N/W+")

field lname, fname, rkey, docno, skey, zipcode, needno
field listtype, okchoice, deptno, branch, CenterNo

cls
@ 9,19 to 14,59
@ 11,20 say padc(" WARNING!!! Do Not Touch this Computer",38) color "R*/W"
@ 12,20 say padc("until reindexing is completed!!!",38) color "R*/W"
setcolor(oldcolor)

@ 18,34 say "INDEXING..."

close databases


if lAllFiles .or. !file('Clients.ntx')
	if use_udf('clients',.t.)
		@ 18,34 say padr(alias(),11)
		pack
		index on upper(lname+fname) to clients
		//	index on rkey to rkey
	else
		return .f.
	endif
endif

if inkey() = K_ESC
	return .f.
endif


if lAllFiles .or. !file('ZipCodes.ntx')
	if use_udf("zipcodes",.t.)
		@ 18,34 say padr(alias(),11)
		pack
		index on zipcode to zipcodes
	else
		return .f.
	endif
endif

cls

/*
TONE(300, 1)
TONE(100, 1)
TONE(300, 1)
TONE(100, 1)
*/


return .t.
