;****************************************************************************
;*
;*		ysource.asm 		
;*		assembly source code for ymouse.lib
;*		
;*		notes:	This file includes 6 procedures for interfacing with
;*					the mouse. 
;*
;*		TY 2-26-92
;*
;****************************************************************************

.MODEL	LARGE

INCLUDE	EXTASM.INC
INCLUDE	MACROS.INC

PUBLIC	ChckClick, ShowMouse, StopMouse, GoMouse, Mposit, SetMPtr


.DATA

nNumClicks		DW		0
nButtons			DW 	0
nX					DW		0
nY					DW		0
nPress			DW		0
nXPosit			DW		0
nYPosit			DW		0
nXSize			DB		8
nYSize			DB 	8


.CODE

ChckClick		PROC		FAR
				
					PUSH		SI
					
					MOV		AX,@DATA
					MOV		DS,AX
					MOV		ES,AX
		
					MOV		AX,5
					MOV		BX,0
					INT		33h

					MOV		nNumClicks,BX

					RetInt	nNumClicks

					POP		SI

					RET

ChckClick		ENDP



ShowMouse		PROC		FAR
	
					PUSH		SI

					MOV		AX,0001h

					INT		33h
	
					RetNIL
	
					POP		SI

					RET

ShowMouse		ENDP


StopMouse		PROC		FAR
	
					PUSH		SI

					MOV		AX,0002h

					INT		33h
	
					RetNIL
	
					POP		SI

					RET

StopMouse		ENDP

GoMouse			PROC		FAR

					PUSH		SI

					MOV		AX,00000h
					INT		33h
					CMP		AX,0FFFFh
					JNE		Exit1
					RetTrue
					MOV		nButtons,BX
					
					CALL		ShowMousePointer
					JMP		Exit2

Exit1:			RetFalse

Exit2:			POP		SI

					RET

GoMouse			ENDP



MPosit			PROC		FAR

					PUSH		SI

					MOV		AX,0003h
					INT		33h
		
					MOV		AX,CX
					MOV		CX,3
					SHR		AX,CL
					MOV		nX,AX

					MOV		AX,DX
					MOV		CX,3
					SHR		AX,CL
					MOV		nY,AX
	
					CMP		BX,1
					JNE		BType1
					MOV		nPress,1
					JMP		Exit3
BType1:			CMP		BX,2
					JNE		BType2
					MOV		nPress,2
					JMP		Exit3
BType2:			CMP		BX,3
					JNE		BType3
					MOV		nPress,3	
					JMP		Exit3
BType3:			CMP		BX,4
					JNE		BType4
					MOV 		nPress,4
					JMP		Exit3
BType4:			CMP		BX,5
					JNE		BType5
					MOV		nPress,5
					JMP		Exit3
BType5:			CMP		BX,6
					JNE		BType6
					MOV		nPress,6
					JMP		Exit3
BType6:			CMP		BX,7
					JNE		BType0
					MOV		nPress,7
					JMP		Exit3
BType0:			MOV		nPress,0

Exit3:			StorInt  1,nX
					StorInt  2,nY
					StorInt  3,nPress

					POP		SI
	
					RET


MPosit			ENDP


ShowMousePointer	PROC		NEAR

						MOV		AX,0001h
						INT		33h

						RET

ShowMousePointer	ENDP




SetMPtr		PROC		FAR

				PUSH		SI

				MOV		AX,@DATA
				MOV		DS,AX
				MOV		ES,AX

				GetInt	1
				MOV		CL,nXSize
				MUL		CL
				MOV		nXPosit,AX
			
				GetInt	2
				MOV		CL,nYSize
				MUL		CL
				MOV		nYPosit,AX

				MOV		AX,4
				MOV		CX,nXPosit
				MOV		DX,nYPosit
				INT		33h

				POP		SI

				RET
	
SetMPtr		ENDP



END
		
				

*** End of assembly source code for ymouse.lib

				