* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*	File Name	:	xtract.prg
*
*	Program		:	xtract                          
*
*	Function(s)	:	none
*	Procedure(s)	:
*
*	Usage(s)	:	xtract ? <file> <proc> /V /L /P >prn
*
*	Parameter(s)	:	char <file_name> to extract from
*				char <func/proc> function or procedure name
*				to extract, or * for all funcs/procs
*				? will display help
*				/V will xtract in verbose mode
*				/L will only list procedures, and will
*				   not write them to a file
*				/P will pause after each procedure
*
*				you can redirect output when using the
*				/L and /V parameters      
*
*	Returns		:	nothing, seperates procs and funcs into
*				seperate files
*
*	Library		:	IDLibrary
*		
*	Created		:	12-03-87
*
*	Revised		:	none
*
*	Author		:	Dirk Lesko
*	Copyright		dLESKO ASSOCIATES  1987
*				320 York Street      
*				Jersey City, NJ 07302
*				(201)435-8401
*
*	Notes		:	Needs IDlibrary to compile correctly
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-
* Variable declarations  
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-
loop_flag 	= .T.		&& start loop flag at .T.
func_flag	= .F.		&& function found flag
func_name 	= ""		&& found the function name
f_name 		= ""		&& filename to open
f_spec 		= ""		&& function name to look for
f_line 		= ""		&& one line of text read in
disp_line 	= ""		&& line to display on screen
f_word 		= ""		&& a word read in to compare
f_newname 	= ""		&& new filename to create
prefice 	= ""		&& for filename prefice
temp 		= ""		&& temp variable for strings
esc		= 0		&& temp variable for integers
handle1 	= 0		&& first handle
handle2 	= 0		&& second handle
verb_flag	= .F.		&& verbose flag
list_flag	= .F.		&& just list them flag
pause_flag	= .F.		&& should we pause flag
switches	= ""		&& will use to hold command line switches
crlf		= chr(13)+chr(10)   && carriage return and line feed 
tab		= 8	 	&& default tab width

for l = 1 to 6			&& max 6 arguments

	switches = switches + " " + get_args(l) + " "

next
switches = uppe(switches)	&& ignore case sensitivity

if "?" $ switches .or. num_args() = 0     

	? "XTRACT - A Clipper/dBASE III+ (tm) Procedure Extracter  Version 1.00"
	? "Copyright (C) dLESKO ASSOCIATES 1987, 1988  All Rights Reserved"
	?
	? "        Purpose:"
	? "                  A program to xtract procedures and functions"
	? "                  from your Clipper/dBASE (tm) programs."
	?
	? "        Usage:"
	? "                  xtract ? <prog_name> <proc_name> /V /L /P"
	?  
	? "        Where:"
	? "                  ? or no command line parameters will display help."
	? "                  <prog_name> is the Clipper or dBASE program name to"
	? "                  check, default extension is PRG. <proc_name> is the"
	? "                  proc or func name to xtract. To xtract all funcs/procs"    
	? "                  from <prog_name> specify an * as the second parameter"
	? "                  /V will print funcs/procs to the screen as they're xtracted"
	? "                  /L will list funcs/procs without writing them out to a file"
	? "                  /P will pause between each func/proc after it is xtracted"
	? "                  you can redirect the output to the printer or to a file"
	? "                  with >prn. The disk file will use the first 6 letters of"
	? "                  the procedure xtracted preceded by a P_ for procedures"
	? "                  or an F_ for functions, with the extension .PRG"
	?
	quit

endif

? "XTRACT - Clipper/dBASE III+ (tm) Procedure Extracter  Version 1.00"
? "Copyright (C) dLESKO ASSOCIATES 1987, 1988  All Rights Reserved"
?
?

in_int24()			&& no critical errors please

f_name = uppe(get_args(1))	&& get the filename
f_spec = uppe(get_args(2))	&& get function name 

if "" == f_name			&& validate

	? "Invalid file name...."+chr(7)
	quit

endif

if .not. "." $ f_name

	f_name = f_name+".PRG"

endif

if "" == f_spec			&& validate

	? "Invalid procedure specification...."+chr(7) 
	quit

endif

if .not. isfile(f_name)		&& check for valid file name

	? "file &f_name not found...."+chr(7) 
	quit

endif

if " /V " $ switches            && turn switches on or off

	verb_flag = .T.

endif

if " /L " $ switches                

	list_flag = .T.
	handle2 = -1

endif

if " /P " $ switches                

	pause_flag = .T.

endif

handle1 = f_open(f_name,0)	&& open file in read only mode
if handle1 < 1			&& check handle

	? "Error opening file &f_name....."+chr(7)
	quit

endif

do read_line

do whil .T.			&& outer loop
do whil .T.         		&& loop one

	esc = inke()
	if esc = 27

		do good_bye     

	endif

	if "" == f_word .and. f_eof(handle1)                      

		if .not. func_flag

			?? "Procedure &f_spec not found....."+chr(7)+crlf

		endif 
		do good_bye     

	endif

	if ("FUNC" == left(f_word,4)) .or. ("PROC" == left(f_word,4))       

		if ("=" $ func_name) .or. ("&" $ func_name)

			do read_line
			loop

		endif

		if (f_spec == "*") .or. (f_spec == func_name)

			if .not. list_flag

			       	?? "extracting "+func_name+crlf+crlf

			endif

			if list_flag .and. .not. verb_flag

				print(f_line+crlf)

			endif

			func_flag = .T.
			prefice = left(f_word)+"_"	&& for _F or _P       
			exit				&& for filename

		endif

	endif
	do read_line

enddo

esc = inke()
if esc = 27

	do good_bye     

endif

if .not. list_flag

	f_newname = prefice+left(func_name,6)+".PRG"	&& create filename     
	if isfile(f_newname)				&& make sure we don't erase

		?? "file &f_newname exists, overwrite? (Y/N) " 
		temp = uppe(chr(inke(0)))
		?? iif((temp = "Y"),"Yes","No")+crlf+crlf

		if temp == chr(27)

		        do good_bye

		endif

		if temp <> "Y"

 			if f_spec == "*"

				do read_line
				loop 

		    	else

				do good_bye

			endif

		endif

	endif

endif

if .not. list_flag

	handle2 = f_create(f_newname)		&& try and create new file
	if handle2 < 1

		?? "Error opening file &f_newname....."+crlf+chr(7)
		f_close(handle1)
		quit

	endif

endif

do write_line             		&& write out the first line
do read_line				&& and get another line

do whil .T.      

	esc = inke()
	if esc = 27

		do good_bye     

	endif

	if "" == f_word .and. f_eof(handle1)

	        do good_bye

	endif

	if ("FUNC" == left(f_word,4)) .or. ("PROC" == left(f_word,4))

		if ("=" $ func_name) .or. ("&" $ func_name)

			do write_line
			do read_line
			loop

		endif

		f_close(handle2)		&& close the new file

		if f_spec != "*"

			f_close(handle1)
			quit

		endif

		if pause_flag  


			?? crlf+"Press any key to continue....."+crlf+crlf
			esc = inke(0)
			if esc = 27

				f_close(handle1)
				quit

			endif            

		endif
		exit			&& loop around again

	endif
	do write_line
	do read_line

enddo					&& second loop
enddo					&& outer loop
                                                    
** Procedures and Functions **

proc read_line				&& read a line in from .PRG file
					&& and remove tabs to xtract words
	f_line = f_readln(handle1)
	temp   = uppe(all_trim(chr_swap(f_line,chr(9)," ")))
	f_word = str_xtract(temp," ",1)

	temp = all_trim(substr(temp,len(f_word)+1,(len(temp)-len(f_word))))
	func_name = str_xtract(temp," ",1)

return

proc write_line				&& write a line to file or screen

	if .not. list_flag

		f_writeln(handle2,f_line)

	endif

	if verb_flag

		print(f_line+crlf)

	endif

return

proc good_bye				&& close all handles and exit

	f_close(handle1)
	f_close(handle2)
	quit

return

func print				&& print using DOS interrupt
para d_one				&& so that output can be redirected

	call set_seg with d_one		&& setup seg:off

	reg_ah(64)			&& load ah register with 40h
	reg_bx(1)			&& write to standard output
	reg_ds(seg())			&& load segment
	reg_dx(off())			&& load offset
	reg_cx(len(d_one))		&& number of bytes to write

	interrupt(33)			&& DOS interrupt

	reg_ah(3)			&& get cursor position
	reg_bh(0)			&& page 0
	interrupt(16)			&& video interrupt

	@ reg_dh(),reg_dl() say ""   	&& position cursor because
					&& Clipper keeps own position

return("")
