   NAME   EXTEND

   PUBLIC ISCOLOR
   PUBLIC ISPRINTER
   PUBLIC CURSOFF
   PUBLIC CURSON
   PUBLIC LOKON
   PUBLIC LOKOFF

; Clipper return value calls
   EXTRN   _RETC:FAR    ; return character string
   EXTRN   _RETDS:FAR   ; return date type from date string "YYYYMMDD"
   EXTRN   _RETL:FAR    ; return logical true or false
   EXTRN   _RETNI:FAR   ; return word as numeric
   EXTRN   _RETNL:FAR   ; return double word as numeric
   EXTRN   _RETND:FAR   ; return floating point as numeric

_PROG SEGMENT

         ASSUME CS:_PROG


ISCOLOR PROC FAR

         MOV      AH,15          ; current video status function
         INT      10H            ; read video status

         XOR      BX,BX          ; false
         CMP      AL,07          ; monochrome 80x25
         JE       RET_ISCOLOR    ; return false if other than above
         MOV      BX,1           ; true

RET_ISCOLOR:
         PUSH     BX             ; put return value on the stack
         CALL     _RETL          ; return logical value to Clipper
         POP      BX             ; restore the stack

         RET

ISCOLOR ENDP


ISPRINTER PROC FAR

         MOV      AH,2H          ; printer status function
         MOV      DX,0H          ; which printer to check
         INT      17H            ; read printer status

         XOR      BX,BX          ; false
         CMP      AH,90H         ; not busy or selected (90h = 10010000)
         JNE      RET_ISPRINTER  ; return false if other than above
         MOV      BX,1           ; true

RET_ISPRINTER:
         PUSH     BX             ; put return value on the stack
         CALL     _RETL          ; return logical value to Clipper
         POP      BX             ; restore the stack

         RET

ISPRINTER ENDP

                             ;for full documentation of the functions below
                             ; consult Ashton-Tate Technotes, Sept. 85

CURSOFF PROC FAR
        PUSH AX
        PUSH CX
        MOV AH,1
        MOV CX,8F8FH
        INT 10H
        POP CX
        POP AX
        RET
CURSOFF ENDP

CURSON PROC FAR
       PUSH AX
       PUSH CX
       INT 11H
       MOV CX,8687H
       AND AL,10H
       JZ CALL_ROM
       MOV CX,8B8CH

CALL_ROM:
       MOV AH,1
       INT 10H
       POP CX
       POP AX
       RET
CURSON ENDP

LOKON   PROC FAR
        PUSH AX
        PUSH DS
        PUSH SI
        PUSH CX
        MOV AX,40H
        MOV DS,AX
        MOV SI,17H
        MOV CX,2

LOOPER: MOV BL,[SI]
        OR  BL,20H
        MOV [SI],BL
        INC SI
        LOOP LOOPER
        POP CX
        POP SI
        POP DS
        POP AX
        RET
LOKON   ENDP     
      
LOKOFF  PROC FAR
        PUSH AX
        PUSH DS
        PUSH SI
        PUSH CX
        MOV AX,40H
        MOV DS,AX
        MOV SI,17H
        MOV CX,2

LOPER: MOV BL,[SI]
        AND BL,0DFH
        MOV [SI],BL
        INC SI
        LOOP LOPER
        POP CX
        POP SI
        POP DS
        POP AX
        RET
LOKOFF  ENDP     



_PROG ENDS

         END

