*-------------------------------------------------------------------------
* xstat.prg -- FORCE FAQ Example code to return the status for XMS memory
*-------------------------------------------------------------------------
#include io.hdr
#include string.hdr
#include system.hdr

#include alloc.hdr
#include undoc.hdr
#include xms.hdr

#pragma W_FUNC_PROC-
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\XMS\RCS\xstat.prg 0.11 1992/05/22 20:11:48 holmesda Exp holmesda $"
ENDDEF
*-------------------------------------------------------------------------
PROCEDURE force_main

   VARDEF
      UINT           k_left
      LONG           mem_left
      UINT           ax,bx,cx,dx,si,di,bp,ds,es
      INT            handle
      CHAR(20)       drv_address
   ENDDEF

   scrn_dos()
   ? "XSTAT " + substr( RCSid, at( "xstat.prg", RCSid ), 14 ) + " [ FORCE FAQ ] "
   ? "-----------------------------------------------------------------------"
   *---
   * The first number, the free conventional memory, will
   * be about 25K short of the value that CHKDSK returns, due
   * to things like the Environment, etc...
   *---
   mem_left = mavail() + filesize( "xstat.exe" )
   ? "Conventional Memory available:", mem_left / 1024, "K"
   if .not. xms_installed()
      ? "XMS Driver not installed."
      quit
   endif
   dec_hex( drv_address, xms_get_driver())
   ? "Extended Memory Driver Adress:  ", drv_address
   ? "XMS Driver version Number:      ", xms_get_version()
   if xms_get_version() < 200
      ? "Old driver, aborting..."
      quit
   endif
   ? "Extended Memory available:    ", xms_avail(), "K"
   ? "High Memory Area Status is:          "
   if hma_alloc()
      ?? "Free"
      hma_free()
   else
      do case
         case xms_get_error() = &X_VDISK
            ?? "Used by VDISK"
         case xms_get_error() = &X_NO_HMA
            ?? "No HMA"
         case xms_get_error() = &X_HMA_USED
            ?? "In USE"
         otherwise
            ?? "Error while testing HMA"
      endcase
   endif

   ax = &XMS_QUERY_A20
   call_driver( xms_get_driver(), ax, bx, cx, dx, si, di, bp, ds, es)
   if ax = 1
      ? "      A20 Line is Enabled."
   else
      ? "      A20 Line is Disabled."
   endif
   *---
   * Now we ask the driver to tell us the largest UMB available.  The
   * XMS specs say that if the driver cannot fulfill our request for
   * a specific amount of memory, it should return the length of the
   * largest block available.  So, we ask for 640k, which we know it
   * can't get.  It will return the length of the block in DX
   *---
   ax = 0x1000
   dx = 0xFFFF       && This should make it fail...
   call_driver( xms_get_driver(), ax, bx, cx, dx, si, di, bp, ds, es)
   if ax = 1
      ? "Something is terribly wrong..."  && If the driver gives us the
      ax = 0x1100                         && go ahead, it wrong, so free
      dx = bx                             && the UMB and quit
      call_driver( xms_get_driver(), ax, bx, cx, dx, si, di, bp, ds, es)
      quit
   endif
   xms_set_error( ax, bx )
   if xms_get_error() = &X_NO_UMB
      ? "There are NO UMBs available."
      quit
   else
      if xms_get_error() = &X_NOT_IMPLEMENTED
         ? "Driver will not return largest UMB size, error #",xms_get_error()
         quit
      endif
   endif

   ? "Largest UMB Available:        ", dx * 16, "bytes"

ENDPRO
*-- EOF: xms_stat.prg ----------------------------------------------------
