FUNCTION STUFF
* Syntax: STUFF( <expC1>, <expN1>, <expN2>, <expC2> )
* Return: <expC1> with the portion starting at <expN1> and
*         going for a length of <expN2> being replaced by <expC2>
*
PARAMETERS cl_string, cl_start, cl_len, cl_replace
RETURN SUBSTR(cl_string,1,cl_start-1) + cl_replace +;
       SUBSTR(cl_string,cl_start+cl_len)


FUNCTION RPAD
* Syntax: RPAD( <expC>, <pad char>, <length> )
* Return: <expC> padded right with <pad char> till LEN(<expC>) = <length>
*
PARAMETERS cl_str, cl_pad,cl_len
RETURN cl_str+REPLICATE(CL_PAD,ABS(cl_len-LEN(cl_str)))


FUNCTION IN_SERT
* Syntax: IN_SERT( <expC1>, <expN>, <expC2> )
* Return: <expC1> with the new expression <expC2> inserted to the right
*         of position <expN>

PARAMETERS cl_str,cl_pos,cl_new
RETURN SUBSTR(cl_str,1,cl_pos-1)+cl_new+SUBSTR(cl_str,cl_pos)


FUNCTION LPAD
* Syntax:LPAD( <expC>, <pad char>, <length> )
* Return: <expC> padded left with <pad char> till LEN(<expC>) = <length>
*
PARAMETERS cl_str, cl_pad,cl_len
RETURN REPLICATE(CL_PAD,ABS(cl_len-LEN(cl_str)))+cl_str
