*************************************************************
* xform - report form to program file converter Version 2.0 *
* xform is Copyright (c) 1990 by Michael F. Lavett          *

*************************************************************

* CONFIGURATION PARAMETERS
public fox, clipper, dbase

* TESTING AND DEBUGGING FLAGS
debug = .t.
if debug
  if fox .or. clipper
    set print to lpt.out
  endif
  set device to print
endif

* PAGE header variables
pagehdr0 = "Birds Residing in City Habitats"
pagehdrs = 1      && total number of page headers

* GROUP header variable
grouphdr = "SPECIES"

* GROUP SUB header variable
subhdr = "LOCATION BY OBSERVER"

* PAGE CONTROL variables
linespage   = 58   && lines per page
pagewidth   = 80   && total page width
totwidth    = 54   && total width of fields and spacing
leftmargin  =  8   && left margin
rightmargin =  0   && right margin
dblspace    = "N"  && double space
ejectag     = "N"  && eject after group
ejectap     = "N"  && eject after printing
ejectbp     = "Y"  && eject before printing
plainpage   = "N"  && plain page format
sumonly     = "N"  && summary report only

* PROGRAM CONTROL variables
linecount   =  0   && printed line count
pagecount   =  0   && printed page count
totalrec    =  0   && total records processed
fieldcount  =  4   && total field count
dbfname     = "birds"   && database name
ndxname     = "bird"   && index name
if dblspace = 'Y'
    lineincr= 2    && double space report
else
    lineincr= 1    && single space report
endif

* field subtotal and grand total accumulators
fsubtot0    =  0   && field 0 sub total
fgrptot0    =  0   && field 0 group total
fgndtot0    =  0   && field 0 grand total
fsubtot1    =  0   && field 1 sub total
fgrptot1    =  0   && field 1 group total
fgndtot1    =  0   && field 1 grand total
fsubtot2    =  0   && field 2 sub total
fgrptot2    =  0   && field 2 group total
fgndtot2    =  0   && field 2 grand total
fsubtot3    =  0   && field 3 sub total
fgrptot3    =  0   && field 3 group total
fgndtot3    =  0   && field 3 grand total

clear
use &dbfname index &ndxname
go top
grpcheck    = "species"    && group expression
subcheck    = "location+who"    && sub-group expression
grpeval     = ""      && evaluate group expression
subeval     = ""      && evaluate sub-group expression

* BEGIN PROGRAM!
if ejectbp = 'Y'
    eject
endif

do while .t.
    if linecount = 0 .or. linecount >= linespage
        linecount = 0      && always reset linecount
        if pagecount > 0
            eject
        endif
        pagecount = pagecount + 1
        * time to print a page header
        if pagecount = 0 .or. plainpage <> "Y"
            @ linecount,leftmargin say "Page No."+tran(pagecount,"999999")
            @ linecount,leftmargin+(totwidth-8) say dtoc(date())
            linecount = linecount + 2
            phdr = 0
            do while phdr < pagehdrs
                header = "pagehdr"+str(phdr,1)
                @ linecount,round((pagewidth-len(&header))/2,0) say &header
                linecount = linecount + 1
                phdr = phdr + 1
            enddo
            linecount = linecount + 1
        endif
    endif


    * Check Sub-Group Condition
    if len(trim(subcheck)) > 0      && sub-group condition specified
        if subeval <> &subcheck     && new sub-group encountered
            if totalrec > 0
                @ linecount, 8 say "-------------------------"
                @ linecount,34 say "------------"
                @ linecount,47 say "-------"
                @ linecount,55 say "-------"
                linecount = linecount + 1
                @ linecount, 8 say "Sub-Group Subtotals:"
                linecount = linecount + 1
                @ linecount,55 say fsubtot3 picture "#######"
                fsubtot3 = 0
                linecount = linecount + 1
                linecount = linecount + lineincr
            endif
            if eof()   && this forces us to process LAST record
                exit
            endif
            subeval = &subcheck     && reassign sub-group expression evaluation
            @ linecount,leftmargin say subhdr + " " + &subcheck
            linecount = linecount + 1
        endif
    endif

    * Check Group Condition
    if len(trim(grpcheck)) > 0     && group condition specified
        if grpeval <> &grpcheck    && new group encountered
            if totalrec > 0
                @ linecount, 8 say "-------------------------"
                @ linecount,34 say "------------"
                @ linecount,47 say "-------"
                @ linecount,55 say "-------"
                linecount = linecount + 1
                @ linecount,  8 say "Group Subtotals:"
                linecount = linecount + 1
                @ linecount,55 say fgrptot3 picture "#######"
                fgrptot3 = 0
                linecount = linecount + 2
            endif
            if eof()   && this forces us to process LAST record
                exit
            endif
            grpeval = &grpcheck    && reassign group expression evaluation
            @ linecount,leftmargin say grouphdr + " " + &grpcheck
            linecount = linecount + 1
            if sumonly <> "Y"
                * Print Field Headers
                @ linecount, leftmargin say "SPECIES NAME              LOCATION     SIGHTED  TOTAL  "
                linecount = linecount + 1
                @ linecount, leftmargin say "                          SIGHTED        BY    SIGHTED "
                linecount = linecount + 1
                @ linecount, leftmargin say "                                                       "
                linecount = linecount + 1
                @ linecount, leftmargin say "                                                       "
                linecount = linecount + 1
                if ejectag = "Y"
                    eject
                endif
            endif    && if totalrec > 0
        endif        && if grpeval <> grpcheck
    endif            && if len(grpcheck) > 0

    * Process Field Contents
    if sumonly <> "Y"
        @ linecount, 8 say SPECIES
        @ linecount,34 say LOCATION
        @ linecount,47 say WHO
        @ linecount,55 say SIGHTED picture "#######"
        linecount = linecount + lineincr
    endif

    * increment appropriate accumulators
    fsubtot3 = fsubtot3 + SIGHTED      && field 3 sub-subtotal 
    fgrptot3 = fgrptot3 + SIGHTED      && field 3 group subtotal 
    fgndtot3 = fgndtot3 + SIGHTED      && field 3 grand total 

    * Get Next Record
    totalrec = totalrec + 1
    skip 1
enddo

* End of MAIN Record Retrieval Loop
@ linecount,  8 say "Grand totals:"
linecount = linecount + 1
@ linecount,55 say fgndtot3 picture "#######"
if ejectap = "Y"
    eject
endif

* set printer and device output to default settings
set print to
set device to screen

* END OF PROGRAM!
