*:*********************************************************************
*:
*:        Program: BOX.PRG
*:
*:         System: Box String Extraction Test System
*:         Author: Dave Bruce
*:      Copyright (c) 1990, Office Automation Solutions, Guelph Ont.
*:  Last modified: 12/17/90     22:57
*:
*:  Procs & Fncts: GETSCREEN()
*:               : EXTRACTSCREEN()
*:               : PUTSCREEN()
*:               : BOX2COORD()
*:               : COORD2BOX()
*:
*:          Calls: GETSCREEN()    (function  in BOX.PRG)
*:               : EXTRACTSCREEN()(function  in BOX.PRG)
*:               : PUTSCREEN()    (function  in BOX.PRG)
*:
*:      Documented 12/17/90 at 22:57                SNAP!  version 4.02
*:*********************************************************************
*
*  I, like a million others, am trying to develop a 99% Clipper
*  coded Interface Library.  It goes at present using ProClip
*  for the windowing.  This works like a charm, but precludes the
*  release of the library as Shareware.
*
*  The solution seems quite simple.  Devise a black box that can
*  extract one screen string from another.  Then, using hybrids of
*  SAVESCREEN() and RESTSCREEN(), update the display.  I have coded
*  functions in Clipper to do this, but as might be guessed, it is
*  slow.  I have access to MS-C 5.1, how hard would it be to code
*  this in C?  Can anyone provide assitance on this?  I would like
*  to hear. Drop me EMail, or better, send comments through
*  NANFORUM for all to use.
*
*  Dave Bruce
*   12-17-90
*
*  PS: Feel free to use as you please.  The copyrights are there
*      to protect the larger work that these function stem from.
*

clear

* Make some boxes on the display
*
@ 10,10 to 19,19
@ 13,13 to 16,16 double

* Grab the signle bordered box
*
LCbox1= GetScreen(10,10,10,10)

* Extract the double border box from the single border box
*
LCbox2= ExtractScreen(LCbox1, 3, 3, 4, 4,13,25)

* Display the result
*
PutScreen(LCbox2)

return



*!*********************************************************************
*!
*!       Function: EXTRACTSCREEN()
*!
*!      Called by: BOX.PRG                       
*!
*!          Calls: BOX2COORD()    (function  in BOX.PRG)
*!               : COORD2BOX()    (function  in BOX.PRG)
*!
*!*********************************************************************
function ExtractScreen
*)
*) Syntax:     <box>= ExtractScreen(<box>,<t>,<l>,<h>,<w>[,<t1>,<l1>])
*)
*) Purpose:    To extract one box from another.
*)
*) Parameters: <box>       A box created with GetScreen()
*)
*)                         Format:  pos 1-4  t,l,h,w as chr()'s
*)                                  pos 5+   SAVESCREEN() data
*)
*)             <t>         extract box top      All are relative
*)             <l>         extract box left    to passed box.
*)             <h>         extract box height 
*)             <w>         extract box width  
*)
*)             <t1>        new box top  Screen relative
*)             <l1>        new box left
*)
*) Return:     <box>       A box of the above format having
*)                         dimensions of <h> x <w> with the
*)                         top,left positioned at <t1>,<l1>.
*)
*)        LNl1
*)   LNt1LCbox1Ŀ       LNt1,LNl1
*)                                   display relative
*)              LNl2       
*)         LNt2 Ŀ            LNt2,LNt1
*)              box2               relative LNt1,LNl1
*)                  LNh2 LNh1
*)                              LNh?,LNw?
*)                             specific height & width
*)               LNw2      
*)                                LNt,LNl
*)                 top,left for the extracted
*)              LNw1                   box (0,0 if not passed).
*)
*)    This diagram shows the positions of each of the dimension
*)    variables below.  I drew it 'cause they confuse the !@#$
*)    outta me.
*)
*) History: 12-17-1990 db: Creation
*)
parameters LCbox1, LNt2, LNl2, LNh2, LNw2, LNt, LNl

private LCbox2, LNt1, LNl1, LNh1, LNw1, LNpos, LNptr

* top,left of the new box
*  - default to 0,0 if not specified
*
LNt= if(type([LNt]) != "N", 0, LNt)
LNl= if(type([LNl]) != "N", 0, LNl)

* Get the coordinates of the passed box
*
store 0 to LNt1, LNl1, LNh1, LNw1
Box2Coord(LCbox1, @LNt1, @LNl1, @LNh1, @LNw1)

* Create the start of the box to be returned
*
LCbox2= Coord2Box("", LNt, LNl, LNh2, LNw2)

* Determine the extraction start position in the passed box
*
LNpos= ( (2 * LNw1 * LNt2) + (2 * LNl2) + 4 ) + 1

* Extract the individual lines in box 2 from box 1
*
for LNptr= 1 to LNh2
   
   * Grab a run of LNw2 doubled (for attributes)
   *
   LCbox2= LCbox2 + substr(LCbox1, LNpos, (2 * LNw2))
   
   * Position the start of the next line
   *
   LNpos= LNpos + (2 * LNw1)
   
next LNptr

* Voila, the extracted box
*
return LCbox2



*!*********************************************************************
*!
*!       Function: GETSCREEN()
*!
*!      Called by: BOX.PRG                       
*!
*!          Calls: COORD2BOX()    (function  in BOX.PRG)
*!
*!*********************************************************************
function GetScreen
*)
*) Syntax:     <box>= GetScreen(<t>,<l>,<h>,<w>)
*)
*) Purpose:    To save a portion of the display to a box string.
*)
*) Parameters: <t>,<l>     top,left of the region to save
*)             <h>,<w>     height,width of the save region
*)
*) Return:     <box>       A screen box suitable for use with
*)                         PutScreen()
*)
*)                         Format:  pos 1-4  t,l,h,w as chr()'s
*)                                  pos 5+   SAVESCREEN() data
*)
*) History: 12-17-1990 db: Creation
*)
parameters LNt, LNl, LNh, LNw

private LNb, LNr, LCs87box

* Calculate the bottom,right of the region to save
*
LNb= LNt + LNh - 1
LNr= LNl + LNw - 1

* Return the box in box format
*
return Coord2Box(savescreen(LNt,LNl,LNb,LNr), LNt, LNl, LNh, LNw)



*!*********************************************************************
*!
*!       Function: PUTSCREEN()
*!
*!      Called by: BOX.PRG                       
*!
*!          Calls: BOX2COORD()    (function  in BOX.PRG)
*!
*!*********************************************************************
function PutScreen
*)
*) Syntax:     <box>= PutScreen(<box>[,<top>,<left>])
*)
*) Purpose:    To restore a box string to the display.
*)
*) Parameters: <box>       The box string to display.
*)
*)             <t>,<l>     Optional top,left to use in place of those
*)                         store in the box string.
*)
*) Return:     none
*)
*) History: 12-17-1990 db: Creation
*)
parameters LCbox, LNt1, LNl1

private LCs87box, LNt, LNl, LNh, LNw, LNb, LNr

* Break the box into component parts
*
store 0 to LNt, LNl, LNh, LNw, LNb, LNr
LCs87box= Box2Coord(LCbox, @LNt, @LNl, @LNh, @LNw, @LNb, @LNr)

* Check for a forced top,left
*
LNt= if(type([LNt1]) != "N", LNt, LNt1)
LNl= if(type([LNl1]) != "N", LNl, LNl1)

* Restore the box from its components
*
restscreen(LNt, LNl, LNb, LNr, LCs87box)



*!*********************************************************************
*!
*!       Function: BOX2COORD()
*!
*!      Called by: EXTRACTSCREEN()(function  in BOX.PRG)
*!               : PUTSCREEN()    (function  in BOX.PRG)
*!
*!*********************************************************************
function Box2Coord
*)
*) Syntax:     <s87box>= Box2Coord(<box>,@<t>,@<l>,@<h>,@<w>,@<b>,@<r>)
*)
*) Purpose:    To extract the component parts of a box string
*)
*) Parameters: <box>       The box string to work on.
*)
*)             @<t>        Variables to store the top, left, height,
*)             @<l>        width, bottom, and right posotions of
*)             @<h>        the passed box string.
*)             @<w>
*)             @<b>        All must be passed by reference.
*)             @<r>
*)
*) Return:     <s87box>    A box string suitable for use with
*)                         RESTSCREEN()
*)
*) History: 12-17-1990 db: Creation
*)
parameters LCbox, LNt, LNl, LNh, LNw, LNb, LNr

* Extract the top,left,height,width
*  (less 1 to avoid chr(0))
*
LNt= asc(substr(LCbox,1,1)) - 1
LNl= asc(substr(LCbox,2,1)) - 1
LNh= asc(substr(LCbox,3,1)) - 1
LNw= asc(substr(LCbox,4,1)) - 1

* Calculate the bottom,right from above numbers
*
LNb= LNt + LNh - 1
LNr= LNl + LNw - 1

* Return the s87 box string portion
*
return substr(LCbox,5)



*!*********************************************************************
*!
*!       Function: COORD2BOX()
*!
*!      Called by: GETSCREEN()    (function  in BOX.PRG)
*!               : EXTRACTSCREEN()(function  in BOX.PRG)
*!
*!*********************************************************************
function Coord2Box
*)
*) Syntax:     <s87box>= Box2Coord(<box>,<t>,<l>,<h>,<w>)
*)
*) Purpose:    To convert a s87 box string to box string format.
*)
*) Parameters: <box>       The s87 box to work on.
*)
*)             <t>         The values for top, left, height, and
*)             <l>         width to affix to the front end of
*)             <h>         the s87 box string.
*)             <w>
*)
*) Return:     <box>       A box string suitable for use with
*)                         PutScreen().
*)
*) History: 12-17-1990 db: Creation
*)
parameter LCs87box, LNt, LNl, LNh, LNw

private LCbox

* Tack the t,l,h,w to the front of the s87 box string
*  (add 1 to the values to avoid chr(0))
*
return chr(LNt+1) + chr(LNl+1) + chr(LNh+1) + chr(LNw+1) + LCs87box




*: EOF: BOX.PRG
