
comment $**************************************************************

    This is hereby Public Domain stuff.  Accompanying files should be:
    Wunscrn.bin  -- the BIN file this makes
    Wunscrn.doc  -- documentation
    Wundemo.prg  -- demo program
    Synutils.doc -- more info and $ solicitation
    Wunescap.prg -- called by Wundemo, part of demo

    R. Russell Freeland
    1780 SW 43 Ave.
    Ft. Lauderdale, FL 33317
    Synergy Corp.
    (voice) 305/792-1866
    CIS:76146,371
   ********************************************************************$

CODESEG SEGMENT
      assume cs:CODESEG


wunscrn proc far
org 0
main: jmp begin

Copywrong       db      13,10,7,'Copywrong (c) RRF/Synergy 1987',13,10
phone           db      "wunscrn.asm,bin",26
save_which      db      ?
screen_mode     db      0FFh    ; screen mode, 7 = mono
screen_page     db      0       ; current page here
cursor_pos      dw      0       ; store cursor position here
screen_buffer   dw 2000 dup(?)  ; local screen buffer storage area

begin:
        push si
        push di
        push bx
        push ds
        push es
        push cs                         ; make ES point to our data
        pop  es
        cld                             ; clear direction flag for moves
        mov al,Byte Ptr DS:[bx]         ; get passed paramter first char
        and al,05Fh                     ; make sure it is upper case
        cmp al,'S'                      ; if Save screen
        je save_screen                  ;    jump to save screen routine
        cmp al,'R'                      ; if Restore screen
        je restore_screen               ;    jump to restore screen routine
        cmp al,'L'                      ; if Load screen
        je load_screen                  ;    jump to load screen routine
        cmp al,'W'                      ; if Write screen
        je write_screen                 ;    jump to write screen routine
        cmp al,"C"                      ; CLONE
        je clonit
nogood:
        jmp finish                      ; else return back to dBASEIII
clonit:
        CALL clone
        jmp finish

save_screen:
        CALL get_mode
        mov ax,0B000h                   ; preload mono buffer segment
        cmp Byte Ptr CS:screen_mode,07h ; is 7 if mono mode
        je save_mono
        mov ax,0B800h                   ; it is not mono mode
save_mono:
        mov ds,ax                       ; DS:SI must point to start of scn mem
        mov si,0
        push cs
        pop es                          ; ES:DI must point to screen buffer
        mov di,offset CS:screen_buffer
        xor ax,ax                       ; clear AX
        mov cx,2000                     ; number of words to save
        cmp Byte Ptr CS:screen_mode,07h ; is 7 if mono mode
        je  monosave_only
colorsave_only:
        mov     dx,3dah                 ; Point DX to CGA status port.
chek_retrace:
w1:     in      al,dx                   ; Get 6845 status.
        rcr     al,1                    ; Check horizontal retrace.
        jb      w1                      ; Loop if in horizontal retrace.
        cli                             ; No interrupt during critical section.
w2:     in      al,dx                   ; Get 6845 status.
        rcr     al,1                    ; Check for horizontal retrace.
        jnb     w2                      ; Loop if not in retrace.
        movsw                           ; move the screen memory to the buffer
        sti
        loop chek_retrace
monosave_only:
rep     movsw
        jmp finish
load_screen:
        CALL read_it
        jmp finish
write_screen:
        CALL write_it
        jmp finish
restore_screen:
        CALL get_mode                   ; get the screen type and cursor position
saved:  mov bh,Byte Ptr CS:screen_page  ; BH = current display page
        mov dx,Word Ptr CS:cursor_pos   ; DH,DL = row,col of current position
        mov ax,0200h                    ; function 2 sets cursor position with
        int 10h                         ; DH,DL=cursor row,col and BH = page
        mov ax,0B000h                   ; preload mono buffer segment
        cmp Byte Ptr CS:screen_mode,07h ; is 7 if mono mode
        je restore_mono
        mov ax,0B800h                   ; it is not mono mode
restore_mono:
        mov es,ax                       ; ES:DI must point start of screen memory
        mov di,0
        xor ax,ax
        mov si,offset CS:screen_buffer
        push cs
        pop ds                          ; DS:SI must point to screen buffer
        mov cx,2000                     ; number of words to restore
        cmp Byte Ptr CS:screen_mode,07h ; is 7 if mono mode
        je  monorest_only
colorrest_only:
        mov     dx,3dah                 ; Point DX to CGA status port.
check_retrace:
r1:     in      al,dx                   ; Get 6845 status.
        rcr     al,1                    ; Check horizontal retrace.
        jb      r1                      ; Loop if in horizontal retrace.
        cli                             ; No interrupt during critical section.
r2:     in      al,dx                   ; Get 6845 status.
        rcr     al,1                    ; Check for horizontal retrace.
        jnb     r2                      ; Loop if not in retrace.
        movsw                           ; move the buffer to the screen memory
        sti
        loop check_retrace
monorest_only:
        rep movsw
finish:
        pop es
        pop ds
        pop bx
        pop di
        pop si
        ret                             ; return

wunscrn endp

GET_MODE PROC NEAR
        xor al,al                       ; first get screen mode and page
        mov ah,15                       ; service 15 of int 10h; return mode in AL
        int 10h                         ; and page in BH
        mov Byte Ptr CS:screen_mode,al  ; store 'em
        mov Byte Ptr CS:screen_page,bh  ; for future use
        xor al,al                       ; now get the current cursor position
        mov ah,3                        ; function 3 reads cursor position
        int 10h                         ; returns DH,DL=cursor row,col
        mov Word Ptr CS:cursor_pos,dx   ; store it
        ret
GET_MODE ENDP



WRITE_IT PROC NEAR
        mov  dx,bx                      ; make DS:[dx] point to dBASE memvar
        inc   dx
        mov  ax,3c00h                   ; call 3ch (create file)
        mov  cx,0                       ; file attribute
        int  21h                        ; call DOS
        jc   no_create                  ; carry set, can't create
        mov  bx,ax                      ; save file handle in BX for "write to" func.
        xor  ax,ax
        push cs
        pop  ds                         ; DS:BX must point to screen buffer
        mov  dx,offset CS:screen_buffer ; now DS:BX points to screen buffer
        mov  cx,4000                    ; number of bytes to write
        mov  ah,40h                     ; "write to" function call
        int  21h                        ; call DOS
        mov  ax,3e00h                   ; close file handle function
        int  21h                        ; call DOS
no_create:
        ret

WRITE_IT ENDP

READ_IT PROC NEAR

        mov  dx,bx ;offset CS:file_name ; move the ASCIIZ name ptr to dx for DOS
        inc  dx                         ; skip "switch"
        mov  ah,3dh                     ; call 3dh (open file)
        mov  al,0                       ; open mode, read permission
        int  21h                        ; call DOS
        jc   badopen                    ; carry set, bad open
        push ax                         ; save handle
        xor  ax,ax                      ; nul AX
        push cs
        pop  ds                         ; DS:DX must point to buffer
        mov  dx,offset CS:screen_buffer
        mov  cx,4000                    ; number of bytes to read
        mov  ah,3fh                     ; "read from" function call
        pop  bx
        int  21h                        ; call DOS
        mov  ax,3e00h                   ; close file handle function
        int  21h                        ; call DOS
badopen:
        ret

READ_IT ENDP

CLONE PROC NEAR
        PUSH CS
        POP  DS
        mov  dx,offset CS:file_name
        mov  ax,3c00h                   ; call 3ch (create file)
        mov  cx,0                       ; file attribute
        int  21h                        ; call DOS
        jc   no_can_do                  ; carry set, can't create
        mov  bx,ax                      ; save file handle in BX for "write to" func.
        mov  dx,0                       ; now DS:DX points to WUNSCRN
        mov  cx,offset CS:end_prog         ; number of bytes to write
        mov  ah,40h                     ; "write to" function call
        int  21h                        ; call DOS
        mov  ax,3e00h                   ; close file handle function
        int  21h                        ; call DOS
no_can_do:
        RET
file_name db 'wunscrn.bin',0

CLONE ENDP
end_prog:
CODESEG ENDS
      END main

