/*
    FUNCTION:   WGETREADER( <OGET>, <HWND>, <AGETS>, <ABUTTONS>, <NBHEIGHT> )
    PURPOSE:    PROCESS ONE GET
                HEAVILY MODIFIED FOR USE WITH CLIP-4-WIN
    PARAMETERS: <OGET> - CURRENTLY ACTIVE GET OBJECT
                <HWND> - HANDLE TO CURRENT ACTIVE WINDOW
                <AGETS> - CURRENT GETLIST ARRAY (REQUIRED FOR RE-DRAWING -
                          SEE DRAWGETS() BELOW)
                <ABUTTONS> - ARRAY CONTAINING PUSHBUTTON WINDOW HANDLES
                             NECESSARY FOR RESIZING IN THE EVENT OF REDRAW
                <NBHEIGHT> - BUTTON HEIGHT (IBID)
    AUTHORS:    GREG LIEF AND JOHN SKELTON
    EXPLANATION:
                THE MAIN REASONS FOR THE EXISTENCE OF THIS READER ARE:
                    1.  TO ALLOW THE PROMPT TO BE KEPT WITH THE GET OBJECT
                        (THIS IS ENCAPSULATION, OF COURSE), E.G. TO BE
                        ABLE TO RE-DRAW THE PROMPTS AND GETS IN A WINDOW
                    2.  TO PROVIDE MOUSE CONTROL (POSSIBLE WITH CLIP-4-WIN'S
                        READMODELESS() GET SYSTEM AS STANDARD)
                    3.  TO SUPPORT PUSH BUTTONS
                OF COURSE, ITEM 1 SHOULD BE A NEW CLASS (GETWITHPROMPT),
                AS SHOULD ITEM 3.  ITEM 2 WOULD BE INHERITED BY THE NEW
                GETWITHPROMPT CLASS.  THE PAINFUL USE OF CARGO IN THIS
                READER BECOMES UNNECESSARY.
    MODIFICATIONS:
                JIM SANDERS - 08-26-93 SEE LINES SURROUNDED BY STARS
*/

#INCLUDE "GETEXIT.CH"
#INCLUDE "INKEY.CH"
#INCLUDE "WINDOWS.CH"
#INCLUDE "SET.CH"

* STRUCTURE FOR GET OBJECT'S CARGO ARRAY
#DEFINE GET_LENGTH    1   // REQUIRED FOR MOUSE JUMPS TO OTHER GETS
#DEFINE GET_PROMPT    2   // @..SAY ASSOCIATED WITH THIS GET
#DEFINE PROMPT_ROW    3   // ROW AT WHICH TO DISPLAY GET_PROMPT
#DEFINE PROMPT_COL    4   // COLUMN AT WHICH TO DISPLAY GET_PROMPT
#DEFINE PROMPT_COLOR  5   // COLOR IN WHICH TO DISPLAY GET_PROMPT
#DEFINE FORCE_FOCUS   6   // FORCES SETFOCUS() (SEE NOTES BELOW)
#DEFINE LASTGET       7   // FLAG INDICATING LAST GET

* MANIFEST CONSTANTS FOR GETCLIENTRECT() AND GETDIBRECT() ARRAYS
* NOTE THAT SINCE TOP AND LEFT ARE ALWAYS 0, THEY ARE UNUSED
#DEFINE W_RIGHT  3
#DEFINE W_BOTTOM 4

PROCEDURE WGETREADER( OGET, NEVENT, HWND, GETLIST, ABUTTONS, BUTTONHEIGHT )
LOCAL NNEWGET
LOCAL NBUTTONS
LOCAL ARECT
LOCAL X
LOCAL NWIDTH
STATIC LFIRSTTIME := .T.

* READ THE GET IF THE WHEN CONDITION IS SATISFIED
IF OGET:EXITSTATE == GE_NOEXIT .OR. ( GETPREVALIDATE(OGET) )
   * ACTIVATE THE GET FOR READING (BUT NOT FOR THE VERY FIRST GET BECAUSE
   * WE MUST FIRST SEND IT THROUGH THE RESIZING GRINDER, A/K/A DRAWGETS()).
   * HOWEVER, NOTE THAT IF WE HAVE USED THE PUSHBUTTONS TO MOVE THE RECORD
   * POINTER, THE GETS WILL ALREADY HAVE BEEN REDISPLAYED (IN THE INTEREST
   * OF PERFORMANCE).  THEREFORE, WE WILL "FORCE" FOCUS TO BE SET BY SETTING
   * A FLAG IN THE CARGO FOR THIS GET.
   IF ! LFIRSTTIME .OR. OGET:CARGO[FORCE_FOCUS]
      IF !OGET:HASFOCUS
         OGET:SETFOCUS()
      ENDIF
      OGET:CARGO[FORCE_FOCUS] := LFIRSTTIME := .F.
   ELSE
      * IF WE ARE HERE FOR THE FIRST TIME, TOGGLE THE "LASTGET" FLAG ON THE
      * LAST GET IN THE GETLIST ARRAY.  THIS IS NECESSARY FOR RESETTING THE
      * LFIRSTTIME FLAG BELOW IN THE EVENT THAT WE PRESS ENTER TO EXIT THE
      * READ.  THIS COULD PROBABLY BE DONE IN THE CALLING PROGRAM, BUT I
      * WANTED IT TO BE TRANSPARENT WHICH IS WHY IT IS HERE.
      ATAIL(GETLIST):CARGO[LASTGET] := .T.
   ENDIF

   WHILE ( OGET:EXITSTATE == GE_NOEXIT )

      * CHECK FOR INITIAL TYPEOUT (NO EDITABLE POSITIONS)
      ***********************************************************************
      IF !SET(_SET_CONFIRM) // WE MUST SEE IF SET CONFIRM IS OFF BEFORE     *
      *                        LOOKING AT TYPEOUT INSTANCE VARIABLE OR      *
      *                        GETS CAN BE EXITED WHETHER SET CONFIRM IS ON *
      *                        OR OFF                                       *
      ***********************************************************************
         IF ( OGET:TYPEOUT )
            OGET:EXITSTATE := GE_ENTER
         END
      END // ***************** YOU WILL NEED THIS END STATEMENT TOO! **********

      * APPLY KEYSTROKES UNTIL EXIT
      WHILE ( OGET:EXITSTATE == GE_NOEXIT )
         DO CASE
         *************************************
         *************************************
         *************************************
         *************************************
         * WILL IT RUN?
            CASE NEVENT == EVENT_LDBLCLK
               OGET:EXITSTATE := GE_ENTER
         *************************************
         *************************************
         *************************************
         *************************************
            CASE NEVENT == EVENT_KEY
               *****************************************************************************
               IF LASTKEY() = K_ESC                                                      //*
               * IF THEY EXITED A READ PRIOR TO STARTING CURRENT READ                      *
               * AND STARTED CURRENT READ WITHOUT PRESSING ANY KEY SINCE                   *
               * PRESSING ESCAPE THEN IF WE DO NOT EXTRACT THIS ESCAPE                     *
               * KEY WITH INKEY() THE CURRENT READ WILL NOT LET DATA BE                    *
               * INPUT TO THE FIRST GET OF THE CURRENT READ UNTIL                          *
               * INPUT FOCUS IS MOVED TO ANOTHER GET IN CURRENT READ                       *
               * AND THEN RETURNED TO THE FIRST GET                                        *
                  INKEY() // YANK ESCAPE OUT OF KEYBOARD BUFFER FROM PRIOR READ            *
               END        // IF PRIOR READ WAS ESCAPED FROM AND NO KEY HIT SINCE THIS READ *
               *****************************************************************************
               GETAPPLYKEY(OGET, INKEY(0) )
            CASE NEVENT == EVENT_LCLICK
               * CHECK THE MOUSE POSITION
               IF POSINGETLIST(GETLIST, MOUSEROW(), MOUSECOL()) == NIL
                  * NOT A CLICK IN ANY OF THE GETLIST
                  RETURN// WAIT FOR THE NEXT EVENT
               ENDIF

               * GETTING HERE MEANS IT'S A CLICK ON A GET
               * (THE CURRENT ONE IF MOUSEROW() == OGET:ROW
               * AND MOUSECOL() IS IN BOUNDS OF THIS GET'S EDIT BUFFER)
            *************************************************************
            * I MODIFIED THIS IF STATEMENT SO WREADER WILL WORK RIGHT   *
            * ON A GET WHERE MORE THAN 1 GET IS LOCATED ON THE SAME ROW *
            * AND NOW SHE WORKS PERFECTLY!!!!!!!!!!!!!!!!!!!!!!!!!!!!   *
               IF    MOUSEROW() == OGET:ROW                     .AND.;//*
                     MOUSECOL() >= OGET:COL                     .AND.;//*
                     MOUSECOL() < (OGET:COL + LEN(OGET:BUFFER))       //***************************************
                  OGET:POS = OGET:POS - ( COL() - MOUSECOL() ) // I TOOK OUT -= AS CODE IS EASIER TO READ NOW *
            ***************************************************// AND LESS LIKELY TO CONTAIN A BUG SINCE -=   *
                  OGET:DISPLAY()                               // HAS A NASTY HABIT OF REASSIGNING OPERATOR   *
               ELSE                                            // PRECIDENCE WHEN LEFT UNATTENDED             *
                  IF MOUSEROW() < OGET:ROW                     // *********************************************
                     OGET:EXITSTATE := GE_UP
                  ELSE
                     OGET:EXITSTATE := GE_DOWN
                  END
               END
            CASE NEVENT == EVENT_CONTROL    // I.E., A BUTTON WAS PUSHED
               OGET:EXITSTATE := GE_WRITE
            OTHERWISE
               DO CASE
                  * FORCE REDRAWING GETS UNLESS WINDOW WAS MINIMIZED
                  CASE NEVENT == EVENT_REDRAW .AND. ! ISICONIC(HWND)
                     HIDECARET(HWND)
                     DRAWGETS(GETLIST)
                     SHOWCARET(HWND)
                     * MUST NOW ACTIVATE FIRST GET IF WE'RE ON IT
                     IF LFIRSTTIME
                        LFIRSTTIME := .F.
                        OGET:SETFOCUS()
                     ENDIF
                     AEVAL(ABUTTONS, {|HBTN| INVALIDATERECT(HBTN)})
                  CASE NEVENT == EVENT_WINSIZE
                     * IF WE ARE USING PUSHBUTTONS AT THE BASE OF THE
                     * DATA ENTRY SCREEN, RESIZE THEM ACCORDINGLY
                     IF ABUTTONS <> NIL
                        NBUTTONS := LEN(ABUTTONS)
                        ARECT := GETCLIENTRECT(HWND)
                        NWIDTH := ARECT[W_RIGHT] / NBUTTONS
                        FOR X := 1 TO NBUTTONS
                           MOVEWINDOW(ABUTTONS[X], NWIDTH * (X - 1), ;
                                      ARECT[W_BOTTOM] - BUTTONHEIGHT, ;
                                      NWIDTH, BUTTONHEIGHT, .F.)
                        NEXT
                     ENDIF
                     INVALIDATERECT(HWND)
                  CASE NEVENT == EVENT_CLOSE .OR. ;
                       NEVENT == EVENT_DESTROY
********************* OGET:EXITSTATE := GE_ESCAPE// NOT NEEDED
               ENDCASE
         ENDCASE

         IF OGET:EXITSTATE == GE_NOEXIT
            RETURN  // WAIT FOR ANOTHER EVENT
         ENDIF

      ENDDO

      * DISALLOW EXIT IF THE VALID CONDITION IS NOT SATISFIED
      IF ( !GETPOSTVALIDATE(OGET) )
         OGET:EXITSTATE := GE_NOEXIT
         RETURN                         // WAIT FOR ANOTHER EVENT
      ENDIF

   ENDDO

   * DE-ACTIVATE THE GET
   OGET:KILLFOCUS()

   * IF WE JUST FINISHED THE READ, RESET STATIC FLAG
   IF OGET:EXITSTATE == GE_ESCAPE .OR. OGET:EXITSTATE == GE_WRITE .OR. ;
                 ( OGET:EXITSTATE == GE_ENTER .AND. OGET:CARGO[LASTGET] )
      LFIRSTTIME := .T.
   ENDIF

ENDIF
RETURN


/*
    DRAWGETS(<AGETLIST>)
    REDRAW GETS AND ACCOMPANYING STATIC TEXT, TWEAKING ::PICTURE IF
    NECESSARY TO MAKE GET FIT WITHIN WINDOW
*/
STATIC FUNCTION DRAWGETS(GETLIST)
LOCAL NGETS := LEN(GETLIST)
LOCAL X
LOCAL OGET
LOCAL NLEN
LOCAL NWIDTH
LOCAL Y
LOCAL LACTIVE := .F.
LOCAL OLDCOLOR
LOCAL R := ROW()
LOCAL C := COL()
FOR X := 1 TO NGETS
   OGET := GETLIST[X]
   SETPOS(OGET:CARGO[PROMPT_ROW], OGET:CARGO[PROMPT_COL])
   DISPOUT(OGET:CARGO[GET_PROMPT], OGET:CARGO[PROMPT_COLOR])

   * INITIALIZE GET COORDINATES IF NONE WERE SPECIFIED
   * (NOTE THAT CLIPPER INITIALIZES THEM TO 0, NOT NIL
   IF OGET:ROW == 0
      OGET:ROW := ROW()
   ENDIF
   IF OGET:COL == 0
      OGET:COL := COL() + 1
   ENDIF

   NLEN := LEN(TRANSFORM(OGET:VARGET(), ;
                                                             IIF(OGET:PICTURE == NIL, "", OGET:PICTURE)))
   NWIDTH := MAXCOL() - OGET:COL + 1

   * REMOVE PREVIOUS @S CLAUSE FROM PICTURE (IF APPLICABLE)
   * THIS IS NECESSARY IF THE GETS HAD TO BE TRUNCATED
   * BUT YOU HAVE JUST RESIZE THE WINDOW TO MAKE IT LARGER
   IF ( Y := AT("@S", OGET:PICTURE) ) > 0
      OGET:PICTURE := SUBSTR(OGET:PICTURE, 1, Y - 1)
   ENDIF

   * IF GET WON'T FIT WITHIN THIS WINDOW, USE @S PICTURE TO SCROLL IT
   IF NLEN > NWIDTH
      OGET:PICTURE := IF(OGET:PICTURE == NIL, '', OGET:PICTURE) + ;
                         "@S" + LTRIM(STR(NWIDTH))
      OGET:CARGO[GET_LENGTH] := NWIDTH
   ELSE
      OGET:CARGO[GET_LENGTH] := NLEN
   ENDIF
   OGET:DISPLAY()
   IF OGET:HASFOCUS
      * SENSIBLE PLACE FOR THE CARET (= CLIPPER CURSOR)
      R = ROW()
      C = COL()
   ENDIF
NEXT
SETPOS(R, C)
RETURN NIL
* END OF FILE WREADER.PRG
