Clipper UDF - Wrap_Field                           November 24, 1987 

Written by: George T. Neill  
            2140 Main Street
            La Crosse, WI  54601

This function is placed in the public domain with the hope of making
users lives easier.  It may be used 'as is' or modified and incorporated
in your programs without royalty or consideration.

The function below was written to provide word wrap capabilities for
my users when entering multiple comment lines.  There are a lot of 
situations where I prefer comment lines in my databases instead of
using memo fields and this makes their operation a little bit slicker. 

This function also illustrates the use of functions for data manipulation
within a single READ command.

Example usage:

      @ 14,15 get mCOMMENT_1 valid wrap_field()
      @ 15,15 get mCOMMENT_2 valid wrap_field()
      @ 16,15 get mCOMMENT_3 valid wrap_field()
      @ 17,15 get mCOMMENT_4 
      read

Note the valid function is not used on the last comment line since
there is no place to wrap the text.


***   Function: Wrap_Field
***     Author: George T. Neill
***    Purpose: Used with Clipper valid() to wrap text to next variable.
*** Parameters: None
***    Returns: .T.

FUNCTION wrap_field
   * ---- save current read variable
   var = readvar()                              
   * ---- save length of variable
   len = len(&var)                              
   if len(trim(&var)) < len            && if trimed(var) is < field length
   	return(.t.)                      &&   return true
   else                                && otherwise...
      * ---- save last word in text
   	last_word = substr(&var, atlast(' ',&var)+1)  
      * ---- strip last word from variable
   	&var=stuff(&var,atlast(' ',&var)+1,len(last_word),space(len(last_word)))
      * ---- redisplay variable - last word (with intensity off)
   	set color to W+/N,W/N   
   	@ row(),col()-len say &var + space(len-len(&var))   
   	set color to W/N,W+/N   
   endif
   keyboard last_word                  && put word in keyboard buffer
return(.t.)                            && return 'true' for valid
