*Clipper UDF - Wrap_Field                           November 24, 1987 
*
*Written by: George T. Neill  
*            2140 Main Street
*            La Crosse, WI  54601
*
*Modified by: Mike Abrahamsen                           March 1, 1988
*             Soft Solutions, Inc.
*             P.O. Box 152321
*             Arlington, Tx  76015
*             (817) 468-5384
*
*This function is placed in the public domain with the hope of making
*users lives easier.  It may be used 'as is' or modified and incorporated
*in your programs without royalty or consideration.
*
*The function below was written to provide word wrap capabilities for
*my users when entering multiple comment lines.  There are a lot of 
*situations where I prefer comment lines in my databases instead of
*using memo fields and this makes their operation a little bit slicker. 
*
*This function also illustrates the use of functions for data manipulation
*within a single READ command.
*
********************************************************************************
*                                                                              *
* (The original file is WRAPFLD.ARC on Silvercom's BBS)                        *
*                                                                              *
* Modifications to Mr. Neill's code:  Since I don't have Tom Rettig's 'ATLAST' *
* function, I had to kludge up one of my own.  It's ugly, but it works.  I     *
* also added an optional parameter (second example) which allows wrapping at a *
* point prior to the last word... but just now, I can't remember why.  Anyhow, *
* it's an optional variable, so the call will work like the original.  I also  *
* added an optional variable to the 'ATLAST' function to allow the search from *
* a point other than the end of the string, which is sometimes handy.          *
*                                                                              *
* Incidentally, this program will compile under Clipper the way it is.         *
*                                                                              *
********************************************************************************
*
*Example usage:
*
@ 0,0 CLEAR
STORE SPACE(20) TO comment_1,comment_2,comment_3,comment_4
*
      @ 4,30 GET comment_1 VALID WRAP_FIELD()
      @ 5,30 GET comment_2 VALID WRAP_FIELD()
      @ 6,30 GET comment_3 VALID WRAP_FIELD()
      @ 7,30 GET comment_4 
      READ
*
STORE SPACE(40) TO comment_1,comment_2,comment_3,comment_4
*
      @ 10,20 GET comment_1 VALID WRAP_FIELD(30)
      @ 11,20 GET comment_2 VALID WRAP_FIELD(30)
      @ 12,20 GET comment_3 VALID WRAP_FIELD(30)
      @ 13,20 GET comment_4 
      READ
*
*Note the valid function is not used on the last comment line since
*there is no place to wrap the text.
*
*
***   Function: Wrap_Field
***     Author: George T. Neill  -  modified a wee bit by Mike Abrahamsen
***    Purpose: Used with Clipper VALID() to wrap text to next variable.
*** Parameters: optional break point
***    Returns: .T.
*
FUNCTION wrap_field
PRIVATE var,len,pos,max
STORE 0 TO max
PARAMETERS max
var = READVAR() 									&& ---- save current read variable
len = LEN(&var)									&& ---- save length of variable
max = IF(max>0,max,len)							&& ---- check for breaklength < length
IF SUBSTR(&var,max) = SPACE(len-max+1)		&&	IF clear from breaklength
	RETURN(.T.)										&&		RETURN true
ELSE													&&	otherwise...
	pos = ATLAST(" ",&var,max)					&& ---- find last break
	IF pos < 1
		RETURN(.T.)
	ELSE
		last_word = SUBSTR(&var,pos+1)				&& save last word in text
		&var=SUBSTR(&var,1,pos)+SPACE(len-pos)		&& strip off last word
		SET COLOR TO N/W,W/N,,,W/N						&& reverse color for SAY
		@ row(),col()-len SAY &var						&& redisplay variable
		SET COLOR TO										&& put back to normal
	ENDIF
ENDIF
KEYBOARD last_word				&& put word in keyboard buffer
RETURN(.T.)								&& return 'true' for valid
*
********************************************************************************
* note on SET COLOR TO stuff - I never DID really understand that stuff, so I  *
* just plinked around until it worked.  There's probably a better way to get   *
* the reverse video 'SAY' to work, but for my purposes, 'If it ain't broke,    *
* don't fix it...'                                                             *
*                        Mike                                                  *
********************************************************************************
*
***   Function: atlast
***     Author: Mike Abrahamsen
***    Purpose: Simulate Tom Rettig's 'atlast' function, 'cause I ain't got it.
*** Parameters: Character to search for,variable to be searched,start position
***    Returns: Position in which found
*
FUNCTION atlast
PRIVATE findchar,charstring,lastchar,x,y,z
STORE 0 TO lastchar,z
PARAMETERS findchar,charstring,lastchar
x = IF(lastchar>0,lastchar,LEN(charstring))
FOR y = x TO 1 STEP-1
	IF SUBSTR(charstring,y,1) = findchar
		z = y
		y = 1
	ENDIF
NEXT
RETURN z
