* WR.PRG
*
parameters CRITERIA
set talk off
set safety off
set deleted on
clear
? "INTELLI-TRIEVE (tm)"
? "copyright 1987 by Richard Ray Viets"
?
*
if .not. file(CRITERIA)                && if criteria file not found
   ? error(1,CRITERIA)                 &&    display error and end
endif
*
* Get name of output file to create (in weighted order)
*
accept "ENTER NAME OF OUTPUT FILE TO CREATE: " to OUT_FILE
if "" = trim(OUT_FILE)                 && if no output file entered
   ? error(2,"")                       &&    display error and end
endif
OUT_FILE = upper(ltrim(trim(OUT_FILE))) && trim blanks, capitalize
if substr(OUT_FILE,len(OUT_FILE)-3,4) <> ".DBF" && if not dbf file
   ? error(3,OUT_FILE)                          &&    error and end
endif
*
use WORK.DBF                           && open work database
zap                                    && clean it up
append from &CRITERIA sdf              && pull in ASCII criteria file
*
* Delete all blank lines and comment lines
*
delete all for "" = trim(WORKLINE) .or. substr(WORKLINE,1,1) = "*"
goto top
*
* force all lines to upper case and flush left
*
replace all WORKLINE with upper(ltrim(WORKLINE))
*
* position record pointer to any nonblank, noncomment line which does
*    not begin with a valid keyword.
*
locate for .not. substr(WORKLINE,1,10) $;
   "DATA_FILE=DBF_FIELD=GOAL_VALU=RANGE_MIN=RANGE_MAX="+;
   "MATCH_VAL=NOMCH_VAL=SKIP_NULL=FIELDTYPE="
*
if found()                             && if any invalid lines found
   ? error(4,WORKLINE)                 &&    display error and end
endif
*
MAXFIELDS = int((lastrec()-1)/4)       && compute maximum # of fields
*
declare aDBF_FIELD[MAXFIELDS]          && declare arrays big enough
declare aGOAL_VALU[MAXFIELDS]          &&    for maximum number of
declare aRANGE_MIN[MAXFIELDS]          &&    criteria occurances
declare aRANGE_MAX[MAXFIELDS]          &&    about to be loaded
declare aMATCH_VAL[MAXFIELDS]
declare aNOMCH_VAL[MAXFIELDS]
declare aSKIP_NULL[MAXFIELDS]
declare aFIELDTYPE[MAXFIELDS]
*
goto top
if substr(WORKLINE,1,10) <> "DATA_FILE=" && if 1st line not data_file
   ? error(5,WORKLINE)                   &&    display error and end
endif
DATA_FILE = substr(WORKLINE,11,len(trim(WORKLINE))-10)
if OUT_FILE == DATA_FILE               && if input/output files same
   ? error(11,WORKLINE)                &&    display error and end
endif
*
if .not.file(DATA_FILE)                && if input file not found
   ? error(12,DATA_FILE)               &&    display error and end
endif
select 2
use &DATA_FILE alias DBF               && open source database
select WORK
skip                                   && get next line
*
i = 1                                  && initialize array index
do while .not. eof()
*                                         set validation switches off:
   GOAL_SET = .F.                      &&    'goal' specified
   RANGE1_SET = .F.                    &&    'min_range' specified
   RANGE2_SET = .F.                    &&    'max_range' specified
   MV_SET = .F.                        &&    'match value' specified
   NMV_SET = .F.                       &&    'nomatch value' specified
   aMATCH_VAL[i] = 0                   && set 'default 'match value'
   aNOMCH_VAL[i] = 0                   && set 'default 'nomatch value'
   aSKIP_NULL[i] = .F.                 && set 'default 'null switch'
*
if substr(WORKLINE,1,10) <> "DBF_FIELD=" && if line not fieldname
   ? error(6,WORKLINE)                   &&    display error and end
endif
LINE = substr(WORKLINE,11,len(trim(WORKLINE))-10)
s = 1                                  && set subscript to 1
select DBF
do while .t.
   if type(fieldname(s)) = 'U'         && if no fieldname match found
      ? error(15,LINE)                 &&    display error and end
   endif
   if fieldname(s) == LINE             && if fieldname valid
      aFIELDTYPE[i] = type(fieldname(s)) && save type
      aDBF_FIELD[i] = LINE             && put fieldname in array
      select WORK
      exit
   endif
   s = s + 1                           && set subscript up 1
enddo fieldname scan
*
if aFIELDTYPE[i] = 'M'                 && if field is MEMO
   ? error(7,LINE)                     &&    display error and end
endif
skip                                   && get next line
*
* Process each keyword parameter for this field specification
*
do while substr(WORKLINE,1,10) <> "DBF_FIELD=" .and. .not. eof()
   LINE = substr(WORKLINE,11,len(trim(WORKLINE))-10) && extract parm
   do case
      case substr(WORKLINE,1,10) = "GOAL_VALU="
         if .not. aFIELDTYPE[i] $ "CL" && if type ne char or logical
            ? error(9,LINE)            &&    invalid use of 'GOAL'
         endif
         if aFIELDTYPE[i] = "L"         && if fieldtype eq logical
            if LINE = ".T."            &&    and goal eq 'true'
               aGOAL_VALU[i] = .T.     &&       put .t. in array
            else
               aGOAL_VALU[i] = .F.     &&       put .f. in array
            endif
         else                          && else is character, so
            aGOAL_VALU[i] = LINE       &&    put string in array
         endif
         GOAL_SET = .T.                && set 'goal' specified
      case substr(WORKLINE,1,10) = "RANGE_MIN="
         if .not. aFIELDTYPE[i] $ "DN" && if type ne date or numeric
            ? error(10,LINE)           &&    invalid use of 'RANGE'
         endif
         if aFIELDTYPE[i] = "D"         && if fieldtype eq date
            aRANGE_MIN[i] = ctod(LINE) &&    put date in array
         else                          && else is numeric, so
            aRANGE_MIN[i] = val(LINE)  &&    put number in array
         endif
         RANGE1_SET = .T.              && set 'min_range' specified
      case substr(WORKLINE,1,10) = "RANGE_MAX="
         if .not. aFIELDTYPE[i] $ "DN" && if type ne date or numeric
            ? error(10,LINE)           &&    invalid use of 'RANGE'
         endif
         if aFIELDTYPE[i] = "D"         && if fieldtype eq date
            aRANGE_MAX[i] = ctod(LINE) &&    put date in array
         else                          && else is numeric, so
            aRANGE_MAX[i] = val(LINE)  &&    put number in array
         endif
         RANGE2_SET = .T.              && set 'max_range' specified
      case substr(WORKLINE,1,10) = "MATCH_VAL="
         aMATCH_VAL[i] = val(LINE)     &&    put number in array
         MV_SET = .T.                  && set 'match value' specified
      case substr(WORKLINE,1,10) = "NOMCH_VAL="
         aNOMCH_VAL[i] = val(LINE)     &&    put number in array
         NMV_SET = .T.                 && set 'nomatch value' specified
      case substr(WORKLINE,1,10) = "SKIP_NULL="
         if LINE = ".T."               &&    load
            aSKIP_NULL[i] = .T.        &&       .t. in array
         else
            aSKIP_NULL[i] = .F.        &&       or .f. in array
         endif
   endcase
   skip                                && get next line
enddo while within a field specification
*
* If field criteria didn't include a GOAL_VALU or RANGE, error
if .not. (GOAL_SET .or. (RANGE1_SET .and. RANGE2_SET))
   ? error(13,aDBF_FIELD[i])           &&     display error and end
endif
*
if .not. (MV_SET .or. NMV_SET)         && if neither value set
   ? error(14,aDBF_FIELD[i])           &&    display error and end
endif
i = i+1                                && increment array index
enddo while within the criteria file
*
?
? "PERFORMING WEIGHTED RETRIEVAL . . ."
?
? "OPENING THE SOURCE DATABASE . . ."
select DBF
set deleted off                        && set for entire file copy
*
?
? "PERFORMING THE WEIGHTED RETRIEVAL CALCULATIONS . . ."
?
? ltrim(str(lastrec()))+" Total Records"
?
? space(len(ltrim(str(lastrec()))))+" Records Processed"
*
index on WQP() to WQP.NTX             && perform calculation and index
*
goto top
?
? "GENERATING THE OUTPUT DATABASE . . ."
*
* CLIPPER ANOMOLY: IF '.DBF' IS PART OF FILE TO 'COPY TO', THEN RESULT
* WILL NOT BE A 'DBASE FILE' ACCORDING TO DBASE
*
OUT_FILE = substr(OUT_FILE,1,len(OUT_FILE)-4) && trim off '.DBF'
copy to &OUT_FILE
*
?
? DATA_FILE+" COPIED TO "+OUT_FILE+".DBF IN WEIGHTED ORDER"
?
close databases
return
*
* The code in this function is executed sequentially for each record
*    in the database, with the for/next loop executed once for each
*    field criteria which was specified and loaded into the array
*
function WQP
private mI, mWC, mWQP, mWP
*
* mWC is WEIGHTED COUNT, the actual score
* mWP is WEIGHTED POTENTIAL, which is:
*          POTENTIAL COUNT - (MATCH VALUE(valid null fields) / 2)
* mWQP is WEIGHTED QUALIFICATION PERCENTAGE, which is:
*                      mWC / mWP
private mNULL
*
mWC=0                                  && initialize counters
mWP=0                                  &&    for each record
*
INDEX_END = i-1                        && set loop control for record
for i = 1 to INDEX_END
*
   mWP = mWP+aMATCH_VAL[i]             && accumulate field's match value
   mFIELD = aDBF_FIELD[i]              && move element to work variable
*
   mNULL = FLD_NULL(aDBF_FIELD[i],aFIELDTYPE[i])  && set 'null' switch
*
* determine if field matches goal or range, adjust accumulator
*
   do case
      case aFIELDTYPE[i] = "N"         && case field eq numeric
         if &mFIELD >= aRANGE_MIN[i] .and. ;
            &mFIELD <= aRANGE_MAX[i]      && if within target range
               mWC = mWC + aMATCH_VAL[i]  &&    add MV to count
         else
            if (!mNULL) .or. (!aSKIP_NULL[i]) &&if present or not ignore
               mWC = mWC - aNOMCH_VAL[i]      &&   subtract NMV
            else
               mWP = mWP - (aMATCH_VAL[i] / 2) &&  else adjust for null
            endif
         endif
*
      case aFIELDTYPE[i] = "D"         && case field eq date
         if &mFIELD >= aRANGE_MIN[i] .and. ;  && (same as case eq
            &mFIELD <= aRANGE_MAX[i]          &&  'numeric)
               mWC = mWC + aMATCH_VAL[i]
         else
            if (!mNULL) .or. (!aSKIP_NULL[i])
               mWC = mWC - aNOMCH_VAL[i]
            else
               mWP = mWP - (aMATCH_VAL[i] / 2)
            endif
         endif
*
      case aFIELDTYPE[i] = "C"         && case field eq character
         if " "+aGOAL_VALU[i] $ " "+upper(trim(&mFIELD))
            mWC = mWC + aMATCH_VAL[i]
         else
            if (!mNULL) .or. (!aSKIP_NULL[i])  && (same as case eq
               mWC = mWC - aNOMCH_VAL[i]       &&   'numeric)
            else
               mWP = mWP - (aMATCH_VAL[i] / 2)
            endif
         endif
*
      case aFIELDTYPE[i] = "L"         && case field eq logical
         if aGOAL_VALU[i] = &mFIELD    && (same as case eq 'numeric'
            mWC = mWC + aMATCH_VAL[i]  &&  except nulls not applicable)
         else
            mWC = mWC - aNOMCH_VAL[i]
         endif
   endcase
*
* Show the record counter on the screen as we index to show progress
*
if .not. eof()
   @ 14,0 say ltrim(str(recno()))
endif
next
*
mWQP = int((mWC / mWP) * 1000000)      && move decimal pt to right
return (1000000 - mWQP)                && reverse for correct collating
