/* WPMERG2.PRG
   Create a WordPerfect 5.1 secondary merge file from a DBF file
   with support for translation of accented letters from 128 to 144,
   147 to 154 and 160 to 165.
   First Author: Glenn Alcott (CIS 76044,747)
   2nd Edition: Robert Noel (CIS 72611,1315)
*/

proc main
use rrunin
wp_merge("rrunin","merge.doc")
quit

FUNCTION WP_MERGE (DBF_FILE,WP_FILE,FILTER_BLK,FIELD_LIST)

/* Parameters:
   DBF_FILE: Name of database file (must already be in use, with desired
   index set)
   WP_FILE:  Name of WP merge file to be created
   FILTER_BLK: Code block containing a filter condition for records to be
   output.  Omit this parameter to include all records (if you omit this
   but include the next parameter, be sure to include a comma in the
   parameter list as a "place holder".)
   FIELD_LIST: An array of field names to be included - must be in upper
   case.  Omit this parameter to include all fields.
*/

* WP generic file header -
local wp_header := chr(255)+"WPCL"+repl(chr(0),3)+chr(1)+chr(10)+    ;
                   chr(0)+chr(1)+repl(chr(0),4)+chr(251)+chr(255)+   ;
                   chr(5)+chr(0)+"2"+repl(chr(0),5)+chr(6)+chr(0)+   ;
                   chr(8)+repl(chr(0),3)+"B"+repl(chr(0),3)+chr(8)+  ;
                   chr(0)+chr(2)+repl(chr(0),3)+"J"+repl(chr(0),23)+ ;
                   chr(8)+chr(0)+"|"+chr(0)+"x"+repl(chr(0),5)

/* The following codes were obtained by looking into a few WP 5.1 files using
Norton Utilities. Few corrections on 2nd Edition - Field name start code
                                                   Field name end code
                                                   Shorter record separator */

* WP "field names" start code
local fname_start := +chr(222)+"b"+chr(4)+chr(0)+chr(4)+chr(0)+"b"+chr(222)

* WP "field names" end code
local fname_end := "~"+chr(222)+"4"+chr(6)+chr(0)+chr(1)+chr(0)+ ;
                   chr(6)+chr(0)+"4"+chr(222)+chr(12)

* WP record separator
local rec_sep := chr(222)+"4"+chr(6)+chr(0)+chr(6)+chr(0)+chr(6)+ ;
                 chr(0)+"4"+chr(222)+chr(12)

* WP field separator
local field_sep := chr(222)+"1"+chr(4)+chr(0)+chr(4)+chr(0)+"1"+ ;
                   chr(222)+chr(10)

local wp_handle,fc,x,d,f,l,tran_str,incl_fld

wp_handle:=fcreate(wp_file)
select (dbf_file)

fwrite(wp_handle,wp_header+fname_start) // File header & and field names start

fc:=fcount()
tran_str:=array(fc)
incl_fld:=array(fc)
for x=1 to fc
  incl_fld[x]=iif(field_list=NIL .or. ascan(field_list,fieldname(x))>0,.T.,.F.)
  if incl_fld[x]
    fwrite(wp_handle,fieldname(x)+"~")
  endif
  ftype:=valtype(fieldget(x))
  do case
  case ftype $ "CM"  // no conversion for character or memo fields
    tran_str[x]:=""
  case ftype="N"     // numeric
  * Use the maximum length of 19 digits - it will be trimmed when written
    tran_str[x]:="9,999,999,999,999,999,999"
    f:=str(fieldget(x))
    d:=at(".",f)
    l:=len(f)
    if d>0  // if field has decimals, add decimal places to the string
      tran_str[x]:=tran_str[x]+"."+repl("9",l-d)
    endif
  case ftype="D"    // date
    tran_str[x]:="@D"
  case ftype="L"    // logical
    tran_str[x]:="L"
  endcase
next
fwrite(wp_handle,fname_end)

* Write the records meeting the filter to the output file
do while .not. eof()
  if filter_blk=NIL .or. eval(filter_blk)
    for x=1 to fc
      if incl_fld[x]
        if tran_str[x] == ""   &&  apply wp_accent function
          fwrite(wp_handle,alltrim(wp_accent(transform(fieldget(x),tran_str[x])))+field_sep)
        else
          fwrite(wp_handle,alltrim(transform(fieldget(x),tran_str[x]))+field_sep)
        endif
      endif
    next
    fwrite(wp_handle,rec_sep)
  endif
  skip
enddo

fclose(wp_handle)
return NIL

function wp_accent(string)
local i,pos
local in_string  := { chr(128),chr(129),chr(130),chr(131),chr(132), ;
                      chr(133),chr(134),chr(135),chr(136),chr(137), ;
                      chr(138),chr(139),chr(140),chr(141),chr(142), ;
                      chr(143),chr(144),chr(147),chr(148),chr(149), ;
                      chr(150),chr(151),chr(152),chr(153),chr(154), ;
                      chr(160),chr(161),chr(162),chr(163),chr(164),chr(165) }

/*                           { "","","","","", ;
                               "","","","","", ;
                               "","","","","", ;
                               "","","","","", ;
                               "","","","","", ;
                               "","","","","","" }            */

local out_string := { chr(38),chr(71),chr(41),chr(29),chr(31), ;
                      chr(33),chr(35),chr(39),chr(43),chr(45), ;
                      chr(47),chr(53),chr(51),chr(55),chr(30), ;
                      chr(34),chr(40),chr(61),chr(63),chr(65), ;
                      chr(69),chr(73),chr(75),chr(62),chr(70), ;
                      chr(27),chr(49),chr(59),chr(67),chr(57),chr(56) }

   for i := 1 to len(in_string)
     do while .T.
       pos := at(in_string[i],string)
       if pos > 0
          string := stuff(string,pos,1,chr(192)+out_string[i]+chr(1)+chr(192))
       else
          exit
       endif
     enddo
   next
return string
