// "The Worm" - A funny kind of screen saver to use in your Clipper
//              programs!
//
//  A couple of years ago I got this idea of a worm/snake crawling around
//  on the screen eating up what was there!  The problem of how to make
//  the thing move the way I wanted it to just set in the back of my head
//  until one day I sat down with a fresh bottle of scotch and decided to
//  make it work.  What you get here is the fruit of that effort.
//
//  Designed as a screen saver that could be plugged into my Clipper programs
//  since I long ago observed that most users tend to just let their machine
//  sit there with the same thing on the screen for hours (mostly the
//  main menu screen).  I use a standard menu system that includes a timeout
//  feature to call "The Worm" at a user set invterval.  The approach you
//  take in your programs is up to you.  There is a file in NANFOURM some
//  where that lets you have timeouts in your reads (I have forgotten the
//  name - sorry!).  I also set a hotkey (ALT-B) so my users can invoke
//  "The Worm" at will.  Since most of my applications are network ones I
//  use a password system and have "The Worm" call a login routine to
//  make sure the person who walks up and presses a key is authorized to
//  use the application currently running.  You can pass "The Worm" a
//  codeblock to call so you can also include a password system if you
//  like.
//
//  I have not included the source code for "The Worm" as you can see.  If
//  you would like the source code then send me a check for the price of
//  a GOOD bottle of scotch and I will send it to you!!!

//  Hugh A. Lokey
//  2635 Portsmouth Place
//  Hephzibah, Georgia 30815

//  Ok, here is how you call "The Worm"
//
//  Worm(aWorm ,;    array containing your worm
//       nRest ,;    number of iterations of the worm before starting over
//       nWait ,;    seconds to wait before moving the worm each time
//       bcBlk ,;    optional codeblock to use when a key is pressed
//       nMinR ,;    optional minimum row
//       nMinC ,;    optional minimum column
//       nMaxR ,;    optional maximum row
//       nMaxC  )    optional maximum column

//   If not specified nMinR = 0
//                    nMinC = 0
//                    nMaxR = 24
//                    nMaxC = 79


//  All of the parameters are optional except the array with your worm.
//  The worm array is structured as follows:

//  {{nRow,nCol,cChar,cColor},;
//   {nRow,nCol,cChar,cColor}
//  nRow   = Initial starting row for this segment of the worm
//  cCol   = Initial starting column for this segment of the worm
//  cChar  = The character to use for this segment of the worm
//  cColor = The color to use when displaying this segment of the worm

//  Hope you can find use for "The Worm".  Let me know what you think
//  and if you have any suggestions on how to improve it!

//  Modified 04/20/92 - Added nMinR,nMinC,nMaxR,nMaxC
//                      Restricts worm to area of screen specified


         GoWorm()

FUNCTION GoWorm
         LOCAL nCtr
         LOCAL cNbrs := "0123456789"
         LOCAL aWorm := {{12,29,'',"GR+/N"},;
                         {12,30,'P',"W+/B" },;
                         {12,31,'',"W+/B" },;
                         {12,32,'R',"W+/B" },;
                         {12,33,'',"W+/B" },;
                         {12,34,'E',"W+/B" },;
                         {12,35,'',"W+/B" },;
                         {12,36,'S',"W+/B" },;
                         {12,37,'',"W+/B" },;
                         {12,38,'S',"W+/B" },;
                         {12,39,'',"GR+/N"},;
                         {12,40,'',"W+/R" },;
                         {12,41,'A',"W+/R" },;
                         {12,42,'',"W+/R" },;
                         {12,43,'',"GR+/N"},;
                         {12,44,'K',"W+/G" },;
                         {12,45,'',"W+/G" },;
                         {12,46,'E',"W+/G" },;
                         {12,47,'',"W+/G" },;
                         {12,48,'Y',"W+/G" },;
                         {12,49,'',"GR+/N"}}

         FOR nCtr := 0 TO 24
             @ nCtr,0 SAY REPLICATE(cNbrs,10)
         NEXT

         Worm(aWorm,;
                 40,;          // restore the screen after 40 moves
                  0,;          // no wait between moves
              {||WormRet()},;  // call this guy when a key is pressed
                  6,;          // Worm limited to row 6
                  4,;          // column 4
                 18,;          // To row 18
                 75)           // column 75
RETURN(NIL)

STATIC FUNCTION WormRet
       LOCAL GetList := {}
       LOCAL cPass   := SPACE(4)
       LOCAL cTmpscr := SAVESCREEN(24,0,24,79)

       @ 24,10 SAY "Password? " COLOR "W+/R" GET cPass PICTURE "@!" COLOR "W+/B"
       READ
       RESTSCREEN(24,0,24,79,cTmpscr)
       IF cPass == "FIFI"
          RETURN(.T.)
       ELSE
          TONE(440,1)
       ENDIF
RETURN(.F.)
