                     Working Day Calculator
       (PC Magazine Vol 5 No 16 Sept 30, 1986 Power User)

     WORKDAYS.PRG uses dBASE's DOW() function to calculate elapsed
business days (excluding weekends and company holidays) between any
two dates.  This is useful, for example, in determining how long it
takes to process insurance claims, how long it takes for sales to
show up in bank deposits, etc.  It can also help in projecting lead
times for scheduling production or in writing proposals.  If you
declare the opening variables PUBLIC rather than PRIVATE, the results
will be available to the calling program.
     Editor's Note:  A few lines have been added to you can also use
it to forecast a future promise date, and also so you can pass the
parameters as date variables as well as character strings.  The
resulting program handles a variety of inputs.
     To use WORKDAYS.PRG for calculating business days elapsed, you
pass two parameters -- the start and end dates -- to the program:

DO workdays with "04/06/86","05/06/86"

     Note that the final /86 may be omitted from either or both
character strings.  You can also pass date variables: dBASE's TYPE()
function is used to determine what kind of input you've passed, and,
if it's a string, it is converted to date format.  The five lines of
code that begin IF LEN(p1)=5 can be replaced with this one-line IIF()
statement if you're using dBASE III Plus:

p1=CTOD(IIF(LEN(p1)=5,p1+"/"+STR(YEAR(DATE())-1900,2),p1))

If you'd like to use WORKDAYS to calculate promist dates, the first
parameter is the start date as show above, and the second is the number
of business days until delivery.  For example:

DO workdays with "05/28",35

The program will return 07/17/86, 35 weekdays (excluding Memorial Day
and the 4th of July).

*** WORKDAYS.PRG: Calculates business days elapsed, past or future

* p1 may be 5 or 8 character or a dBASE date; p2 may also be a number
PRIV holidays,days,start,end
PARA p1,p2
SET TALK OFF
* Enter your company's holidays; these must be edited each year
STOR 0 TO start,days
holidays='01/01, 02/17, 05/26, 07/04, 09/01, 10/13, 11/27, 11/28, 12/25, 12/26'
IF TYPE('p1')='C'
  IF LEN(p1)=5
    p1=CTOD(p1+"/"+STR(YEAR(DATE())-1900,2))
  ELSE
    p1=CTOD(p1)
  ENDIF
ENDIF p1 is the date if it entered as a string

IF TYPE('2')$'CD'
  * if p2 is a string or date
  IF TYPE('p2')='C'
    IF LEN(p2)=5
      p2=CTOD(p2+"/"+STR(YEAR(DATE())-1900,2))
    ELSE
      p2=CTOD(p2)
    ENDIF
  ENDIF p2 is now a date
  start=p1
  DO WHILE start<p2
    IF STR(DOW(start),1)$'23456' .AND..NOT. SUBS(DTOC(start),1,5)$holidays
      days=days+1
    ENDIF
    start=start+1
  ENDDO
  ? "Work days between",01,"&",p2,"--"+STR(days,4),"days."
ELSE
  * if p2 was a number
  end=p1
  DO WHILE days<p2
    IF STR(DOW(end),1)$'23456' .AND..NOT. SUBS(DTOC(end),1,5)$holidays
      days=days+1
    ENDIF
    end=end+1
  ENDDO
  DO WHILE STR(DOW(end),1)$'17' .OR> SUBS(DTOC(end),1,5)$holidays
    end=end+1
  ENDDO
  ? p1,"plus"+STR(p2,4)+" work days:",end
ENDIF
