/* WORDPERF.C
** Daniel L. Martinez, D.D.S.
** 8/6/88
** Routine in C to convert an ASCII Delimited text file to a WordPerfect
** formatted merge file.
** Syntax: WORDPERF(file_handle1,file_handle2);
** int file_handle1 == opened by Clipper(ASCII Delimited file)
** int file_handle2 == opened by Clipper(WordPerfect Merge file)
**
** Compile with: cl /c /AL /Zl /Oalt /FPa /Gs wordperf.c
** Link with: PLINK86 fi word,wordperf lib clipper,extend,llibca
*/

#include <stdio.h>
#include <io.h>

/* you may change these pathnames if necessary for you environment */
#include "\clipper\extenlib\nandef.h"
#include "\clipper\extenlib\extend.h"

int wp_convert(char *,char *,int);	/* function prototype 			*/
char f_buffer[500];				/* buffer for reads 			*/
char convert_buffer[500];		/* buffer for conversion storage 	*/

CLIPPER WORDPERF()
{
	int c_handle1,c_handle2,bytes_read,bytes_converted;
	
	c_handle1 = _parni(1);		/* get source handle passed from Clipper*/
	c_handle2 = _parni(2);		/* and handle of file to write to 		*/
	
	lseek(c_handle1,0L,SEEK_SET);	/* go to beginning of file */
	
	bytes_read = read(c_handle1,f_buffer,500);
	while(bytes_read)
	{
		bytes_converted = wp_convert(f_buffer,convert_buffer,bytes_read); /*convert*/ 
		write(c_handle2,convert_buffer,bytes_converted);	/* write to merge */
		bytes_read = read(c_handle1,f_buffer,500);		/* read some more */
	}
		
	return;
}

int wp_convert(char *file_buff1,char *file_buff2,int bytes_in_buffer)
{
	int i = 0,byte_count=0;
	
	for(i = 0; i < bytes_in_buffer;i++,file_buff1++)
	{
		switch(*file_buff1)
		{
			case '"':			/* string delimiter - strip off */
				break;
			case ',':			/* field delimiter - convert to ^R */
				*file_buff2++ = 18;
				*file_buff2++ = 10;
				byte_count += 2;
				break;
			case 0xA:			/* record delimiter - convert to  ^E */
				*file_buff2++ = 5;
				*file_buff2++ = 10;
				byte_count += 2;
				break;
			default:			/* no conversion - place in buffer */
				*file_buff2++ = *file_buff1;
				byte_count++;
				
		}
		
	}
	return(byte_count);
}
