* WORD.PRG
* Author.....Daniel L. Martinez, D.D.S.
* Date.......8/6/88
*
* This file is a calling procedure that uses a C function called WORDPERF()
* to convert ASCII DELIMITED text files created with the COPY TO <filename>
* DELIMITED command in Clipper, to WordPerfect (R) merge files.  The advantage
* of using the COPY TO command is that ALL fields are placed into the ASCII
* file.  If you desire more control over fields you might create a temporary
* database to hold the specific fields and then COPY TO from the temporary
* database.
* A close examination of the .TXT file as compared to the .MRG file will reveal
* their relationships.  
*
* The C source was compiled with Microsoft C 5.1 and has not been tested with
* other C compilers.  For individuals that do not have a C compiler an .OBJ 
* file has been included in the archive.
*
* See the WORDPERF.C file for info on compiling and linking.
*

SELECT 1
USE Word

COPY TO word.txt DELIMITED		&& create ASCII DELIMITED file

* Call the Clipper function WP_CONVT() which in turn will call the
* C function WORDPERF().

WP_CONVT("WORD.TXT","WORD.MRG")

USE
RETURN

*******************
FUNCTION WP_CONVT
*******************
* The purpose of this function is to simplify the opening and creation
* of the source and destination files, respectively.  Since the parameters
* passed are the filenames to be used, the file names may be passed through
* variables, macros, or as literals.  Must include EXTEND.LIB in linking to
* use the low level DOS functions.  This function gets the handles from DOS
* for the files used and then passes them to the C function for use in the
* conversion.

PARAMETER source,dest
PRIVATE handle1,handle2

handle1 = FOPEN(source)		
handle2 = FCREATE(dest)		&& note that all previous contents are destroyed

WORDPERF(handle1,handle2)	&& pass handles to C function and convert

FCLOSE(handle1)
FCLOSE(handle2)
RETURN(.T.)