* ͻ
*  Procedure to wipe clear a window from left to right.       
*    Passed parameters:                                       
*    T_ROW = top row of defined window                        
*    S_COL = starting column                                  
*    B_ROW = bottom row of defined window                     
*    E_COL = last column of defined window                    
*         internal memory variables:                          
*         L_COL = left column to begin clear (always 0)       
*                                                             
*      EXAMPLE:                                               
*                                                             
*          DEFINE WINDOW W1 FROM 5,10 TO 10,70                
*          ACTIVATE WINDOW W1                                 
*          .....                                              
*          .....                                              
*          .....                                              
*          .....                                              
*          DO WIPE WITH 5,10,10,70                            
*          .....                                              
*          .....                                              
* ͼ


PROCEDURE WIPE
    PARAMETER t_row,s_col,b_row,e_col

    PRIVATE t_row,s_col,b_row,e_col,l_col

    l_col = 0
    b_row  = b_row - t_row - 2
    e_col =  e_col - s_col - 2

    DO WHILE l_col+2 < e_col
        @ 0,l_col CLEAR TO b_row,l_col + 2
        l_col = l_col  + 2
        ENDDO
        @ 0,e_col-2 CLEAR TO b_row,e_col - 1
 RETURN

* 


