*************** Beispielprogramme Nantucket Tools II / 5.0 ***************
*
* Programm    : WINTRACK.PRG
* Copyright   : (c) 1991, Nantucket  Corp.  Alle Rechte vorbehalten.
* Datum       : 20.11.91
* Autor       : Lothar Bongartz
* Beschreibung: virtuelles Verschieben von Fenstern
* Compilieren : CLIPPER WINTRACK
* Linken      : RTLINK FI Wintrack, NT2GR50 LIB NT250
* Bemerkungen : -
*
**************************************************************************

#define nVirtRow   203
#define nUpRow       4
#define cUpArrow   CHR(24)
#define cDownArrow CHR(25)

* Scrollende GET-Masken mit den Nantucket Tools II
*
 LOCAL InVar[nVirtRow], getList := {}, nCol := MAXCOL() +1, i
 PUBLIC nMaxRow := MAXROW()

 WMODE(.T., .F., .F., .F.)   // Oberkante fr Unterschieben freigeben
 WSTEP(10, 3)                // Schrittweite fr die WMOVE() in WTRACK

* Aufbau eines Rahmens, der nur zur Veranschaulichung dient
*
 SCROLL()                    // Bildschirm l., ohne Cur.-Pos. zu ndern
 @ 1, 0 SAY CENTER( "Taste 'Rollen', dann " +cUpArrow +cDownArrow )

  FOR i = 0 TO nMaxRow
   @ i, 1 SAY STR(i, 3)
   @ i, nCol -12 SAY i
  NEXT

 SHOWTIME(1, 62)             // Dazu ist es ist nie zu spt ...

 SETMAXROW(nVirtRow -1)      // virtueller Bildsch. ohne Auto-Tracking
 WBOX(12)

* Den fr Fenster gltigen Bereich definieren, und damit alle
* anderen Bereiche quasi 'schtzen'!
*
 WBOARD ( nUpRow  , 10, nVirtRow -1, nCol -11 )

* Das gltige Window-Board wird umrahmt (Rahmen gehrt nicht mit dazu)
* und dann mit dem Zeichen CHR(176) gelscht. Das Fenster wird dann
* ber die gesamte Flche des Board geffnet und ebenfalls mit CHR(176)
* gelscht.
*
 DISPBOX( nUpRow-1,  9, nVirtRow   , nCol -10 )

 SETCLEARB(176)
 SCROLL( nUpRow  , 10, nMaxRow,     nCol -11 )
 WOPEN ( nUpRow  , 10, nVirtRow -1, nCol -11, .T. )

* Aufbau der GET. Jede zweite Zeile 2 Felder ber den
* gesamten Bildschirm.
*
 FOR i = 1 TO MAXROW() STEP 2
   InVar[i]    := i
   InVar[i +1] := i +1
   @ i, 2 SAY "Var_" + NTOC(i,    10, 3, "0") GET InVar[i]
   @ i,40 SAY "Var_" + NTOC(i +1, 10, 3, "0") GET InVar[i +1]
 NEXT i

 SETPOS(0, 0)               // Cursor in Zeile 0, Spalte 0
 TRAPINPUT("WTRACK", .T.)   // kontinuierliche berwachung der
                            // Cursor-Position

 READ
RETURN

*****************
* Track-Prozedur
*
* Hat der Cursor den sichtbaren Bereich des Bildschirms verlassen,
* wird das Fenster entsprechend verschoben. Da diese Prozedur durch
* TRAPINPUT() jedesmal aufgerufen wird, wenn Clipper auf eine
* Tastatur-Eingabe prft, ist eine kontinuierliche berwachung
* gegeben.
*
 PROCEDURE WTRACK
  DO CASE
   CASE WROW() +ROW() >= nMaxRow        // Abs. Cur.-Pos. > Unterkante ?
    WMOVE((nMaxRow -1) -ROW(), WCOL())
   CASE WROW() +ROW() <= nUpRow         // WROW() kann auch negative Werte
                                        // liefern. Das Fenster ist dann
                                        // nach oben verschoben.
    WMOVE((nUpRow +1) -ROW(), WCOL())
  ENDCASE
 RETURN
*
* eof wintrack.prg
