/*
 * File          : win2.C
 * Author        : Peter Kulek
 * Compuserve ID : 100140,1220
 * Date          : $Date:   1990 $
 * Revision      : $Revision:   1993  $
 * 
 * Copyright (c) Peter Kulek
 *
 * You can you use this code as you please but please keep copyright notice.
 *
 * Experimental Window routines for clipper 
 * seems to slow down with clipper wrap around.
 * will convert to full clipper one day.
 * No Documentation at present but self explanitory from demo.
 * Able to move a window within a stack and keep its
 * place.
 * also able to send window to back or front of Que
 * Needs MSC Ver 6 to recompile
 *
 * If you want the C primitives source code please leave a 
 * message on compuserve on my ID.
 *
 * Modification history:
 * ---------------------
 *
 */

#include "extend.h"
#include "win1.h"
#include "gt.api"


CLIPPER W_INIT(){ // initialise a window do not show
    WINDOW *wnd;
    _retni(-1);
    if ( ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4) ) {
        int height = _parni(3) - _parni(1) ;
        int width  = _parni(4) - _parni(2) ;
        char * title = ISCHAR(5) ? _parc(5) : ""; 
        wnd = WInit(_parni(1),_parni(2),height,width,title);
        _retni(WINNUMBER);
    }    
}

CLIPPER W_OPEN(){ // initialise and open a window
    WINDOW *wnd;
    _retni(-1);
    if ( ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4) ) {
        int height = _parni(3) - _parni(1) ;
        int width  = _parni(4) - _parni(2) ;
        char * title = ISCHAR(5) ? _parc(5) : ""; 
        wnd = WInit(_parni(1),_parni(2),height,width,title);
        Wshow(wnd);
        _retni(WINNUMBER);
    }    
}

CLIPPER W_SHOW() { // show a hidden window
    WINDOW *wnd;
    if ( ISNUM(1) ) {
        wnd = Wselect((unsigned char)_parni(1));
        Wshow(wnd);
    }
}

CLIPPER W_SELECT(){ // select a window to front
    WINDOW *wnd;
    if ( ISNUM(1) ) {
        wnd = Wselect((unsigned char)_parni(1));
        Wforefront(wnd);
    }    
}

CLIPPER W_MOVE(){ // move window number of columns or rows
    WINDOW *wnd;
    if ( ISNUM(1) ) {
        int row = ISNUM(2) ? _parni(2) : 0 ;
        int col = ISNUM(3) ? _parni(3) : 0 ;
        wnd = Wselect((unsigned char)_parni(1));
        Wrmove(wnd,col,row);
    }    
    _ret();
}

CLIPPER W_POSZ() {       // move window to back or front of Queue 
    WINDOW *wnd;         // Next stage move window in any position
    if ( ISNUM(1) ) {
        int nPos = ISNUM(2) ? _parni(2) : 1 ;
        wnd = Wselect((unsigned char)_parni(1));
        switch (nPos) {
             case 1: Wforefront(wnd);
                     break;
             case 0: Wrear(wnd);
                     break;
             default:    break;
        }
    }    
    _ret();
}

CLIPPER W_SETCOLOR() { // set colors
    WINDOW *wnd;
    if ( ISNUM(1) ) {
        int nMask    = ISNUM(2) ? _parni(2) : WIN_BORDER ;
        int nFg      = ISNUM(3) ? _parni(3) : BLACK ;
        int nBg      = ISNUM(4) ? _parni(4) : BLACK ;
        int nIntense = ISNUM(5) ? _parni(5) : DIM ;
        wnd = Wselect((unsigned char)_parni(1));
    	Wsetcolour(wnd, nMask,nBg, nFg, nIntense);
    }    
    _ret();
}

CLIPPER W_SAY() {  // Write string to window starting at 0,0
    WINDOW *wnd;
    unsigned char Attr = 7 ;
    if ( ISNUM(1) && ISCHAR(4) ) {
        int nRow     = ISNUM(2) ? _parni(2) : 0 ;
        int nCol     = ISNUM(3) ? _parni(3) : 0 ;
        char *cString   = _parc(4) ;
        if (ISNUM(5))
             Attr =  (unsigned char)_parni(5) ;
        wnd = Wselect((unsigned char )_parni(1));
        Wprintstr(wnd,nRow,nCol,cString,Attr) ;
    }    
    _ret();
}

CLIPPER W_HIDE() { // hide window
    WINDOW *wnd;
    if ( ISNUM(1) ) {
        wnd = Wselect((unsigned char )_parni(1));
        Whide(wnd) ;
    }    
    _ret();
}




