
#ifdef    TRUE
     #undef    TRUE
#endif
#ifdef    FALSE
     #undef    FALSE
#endif
#ifdef    ERROR
     #undef    ERROR
#endif
#ifdef    OK
     #undef    OK
#endif

#define   TRUE         1
#define   FALSE        0
#define   ERROR        -1
#define   OK           0
#define   ON           1
#define   OFF          0

#define   TABS         4

#define MK_FP(seg,ofs)  ((void far *)(((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#define FP_SEG(fp) (*((unsigned *)&(fp) + 1))
#define FP_OFF(fp) (*((unsigned *)&(fp)))    

#define   SCREENWIDTH  ( (*(unsigned char far *)0x0040004a) & 255 )
//#define   SCREENHEIGHT     (visvga() || visega() ? (*(unsigned char far *)0x00400084)+1 : 25)
#define   SCREENHEIGHT     25

#define   VIDEO            0x010   /* video interrupts */
#define   KEYBRD           0x016   /* keyboard interrupts */
#define   DOS              0x021   /* dos interrupts */
#define   CRIT             0x024   /* critical error handler */
#define   MOUSE            0x033   /* mouse interrupts */
#define   KBUSYLOOP        0x028   /* keyboard busy loop, intr handler */

#define BLACK             0
#define BLUE              1
#define GREEN             2
#define CYAN              3
#define RED               4
#define MAGENTA           5
#define BROWN             6
#define LIGHTGRAY         7
#define DARKGRAY          8
#define LIGHTBLUE         9
#define LIGHTGREEN       10
#define LIGHTCYAN        11
#define LIGHTRED         12
#define LIGHTMAGENTA     13
#define YELLOW           14
#define WHITE            15

typedef struct _wnd {
        int WinVis;                  /* true if window is visible     */
        int WinHide;                 /* true if window was hidden     */
        char *WinSave;               /* points to window save block   */
        char *WinTitle;              /* points to window title        */
        int Just;                    /* title justification           */
        int WinTop;                  /* nw x coordinate               */
        int WinLeft;                 /* nw y coordinate               */
        int WinWidth;                /* window width                  */
        int WinHeight;               /* window height                 */
        int WinSavep;                /* scroll pointer                */
        int WinCursor;               /* cursor x location             */
        int WinBorder;               /* border type                   */
    	int WinColor[5];             /* colours for window            */
        int WinPNColor;              /* previous normal colour        */
        struct _wnd *WinNext;        /* points to next window         */
        struct _wnd *WinPrev;        /* points to previous window     */
        unsigned char WinNo;         /* Window No                     */
} WINDOW;

#define   WIN_BORDER       0x000           /* border or frame */
#define   WIN_TITLE        0x001           /* title area  */
#define   WIN_ACCENT       0x002           /* accent or highlight bar  */
#define   WIN_FACE         0x003           /* window face */
#define   WIN_FLDFACE      0x004           /* window field face */
#define   WIN_HOTKEY       WIN_FLDFACE     /* hot-key used for menu windows */
#define   WIN_ALL          0x005           /* all above components */
#define   BRIGHT           0x008           /* high intensity  */
#define   DIM              0x000           /* low intensity  */

#define   BRD_SPACE        0x000           /* single line */
#define   BRD_SINGLE       0x001           /* single line */
#define   BRD_DOUBLE       0x002           /* double line */
#define   BRD_DOUBLESIDE   0x003           /* double sides & single top */
#define   BRD_DOUBLETOP    0x004           /* double top & single sides */
#define   BRD_SINGLESIDE   BRD_DOUBLETOP   /* ditto */
#define   BRD_SINGLETOP    BRD_DOUBLESIDE  /* ditto */

#define   BRD_PULLDOWN     0x005           /* used in pulldown menus */


#define   JUST_C           0x000           /* centre justify */
#define   JUST_L           0x001           /* left justify */
#define   JUST_R           0x002           /* right justify */

#define SAV              (wnd->WinSave)
#define WTITLE           (wnd->WinTitle)
#define TJUST            (wnd->Just)
#define COL              (wnd->WinTop)
#define ROW              (wnd->WinLeft)
#define WIDTH            (wnd->WinWidth) 
#define HEIGHT           (wnd->WinHeight) 
#define SCROLL           (wnd->WinSavep)
#define WCURS            (wnd->WinCursor)
#define WBORDER          (wnd->WinColor[WIN_BORDER])
#define WTITLEC          (wnd->WinColor[WIN_TITLE])
#define WACCENT          (wnd->WinColor[WIN_ACCENT])
#define WFACE            (wnd->WinColor[WIN_FACE])
#define WFIELD           (wnd->WinColor[WIN_FLDFACE])
#define PWIN_FACE        (wnd->WinPNColor)
#define BTYPE            (wnd->WinBorder)
#define NEXT             (wnd->WinNext)
#define PREV             (wnd->WinPrev)
#define WCOLOUR          (wnd->WinColor)
#define VISIBLE          (wnd->WinVis)
#define HIDDEN           (wnd->WinHide)
#define WINNUMBER        (wnd->WinNo)

#define NW               (wcs[wnd->WinBorder].topleft)
#define NE               (wcs[wnd->WinBorder].topright)
#define SE               (wcs[wnd->WinBorder].botright)
#define SW               (wcs[wnd->WinBorder].botleft)
#define SIDE             (wcs[wnd->WinBorder].vert)
#define LINE             (wcs[wnd->WinBorder].hor)

void    Wclear           (WINDOW *);
void    Wcloseall        (void);
void    Wcursor          (WINDOW *, int, int);
void    Wdelete          (WINDOW *);
void    Wemsg            (char *);
void    Wemsgclear       (void);
WINDOW *Wselect(unsigned char ) ;
WINDOW *WInit(int , int , int , int , char *);
int     Wgetsel          (WINDOW *, int, char *);
void    Whide            (WINDOW *);
void    Wprintf          (WINDOW *, char *, ...);
void    Wprompt          (WINDOW *, int, int, char *);
void    Wputch           (WINDOW *, int);
void    Wputchat         (WINDOW *, int , int , int , int);
void    Wsetborder       (WINDOW *, int);
void    Wsetcolour       (WINDOW *, int, int, int, int);
void    Wsetintensity    (WINDOW *, int);
void    Wsettitle        (WINDOW *, char *, int);
void    Wshow            (WINDOW *);
void    Wprintstr(WINDOW *, int,int, char *,unsigned char);

#define Wforefront(wnd)  repos_wnd(wnd, 0, 0, 1)
#define Wmove(wnd,x,y)   repos_wnd(wnd, COL-x, ROW-y, 0)
#define Wrear(wnd)       repos_wnd(wnd, 0, 0, -1)
#define Wresetvideo(wnd) wnd->WinColor[WIN_FACE]=wnd->WinPNColor
#define Wrevvideo(wnd)   wnd->WinColor[WIN_FACE]=wnd->WinColor[WIN_ACCENT]
#define Wrmove(wnd,x,y)  repos_wnd(wnd, x, y, 0)

int  kgetch              (void);
int  kkeyhit             (void);
int  far *kstate         (void);


void    accent           (WINDOW *);
void    deaccent         (WINDOW *);
void    scroll           (WINDOW *, int);
void    repos_wnd        (WINDOW *, int, int, int);
void    acline           (WINDOW *, int);
void    displ            (WINDOW *wnd, int x, int y, int ch, int at);

#define accent(wnd)      acline(wnd, WACCENT)
#define deaccent(wnd)    acline(wnd, WFACE)

#define CLR(bg,fg,in)    ((fg)|(bg<<4)|(in))
#define VCH(ch,at)       ((ch&255)|(at<<8))
#define VAD(x,y)         ((y)*(SCREENWIDTH*2)+(x)*2)
#define VIDMODE          *(unsigned char far *) 0x00449lu
#define MONOSEG          0xb0000000L
#define COLORSEG         0xb8000000L
#define VIDSEG           (unsigned char far *) \
                         ((7 == VIDMODE) ? MONOSEG : COLORSEG )
#define ISMONO()         (VIDMODE == 7)
#define ISTEXT()         (VIDMODE < 4)


int  vblinkbit           (int flag);
void vclearrline         (unsigned char,unsigned char);
void vcls                (unsigned char);
void vfill               (int x, int y, int yy, int xx, int c, int a);
int  vget                (int x, int y);
int  vgeta               (int x, int y);
int  vgetac              (void);
int  vgetch              (int x, int y);
int  vgetchc             (void);
void vgetcur             (int *x, int *y);
void vhidecur            (void);
int  visega              (void);
int  visvga              (void);
void vnormalcur          (void);
void vpopcur             (void);
void vpopscreen          (void);
void vpushcur            (void);
int  vpushscreen         (void);
void vputch              (int x, int y, unsigned char a,
                          register unsigned char c);
void vputf               (int x, int y, unsigned char a, char *fmt, ...);
void vputfc              (int y, unsigned char attrib, char *fmt, ...);
void vputs               (int x, int y, unsigned char a, register char *s);
void vputsc              (int y, unsigned char a, char *s);
void vset25              (void);
void vset43              (void);
void vset50              (void);
void vsetcur             (int x, int y);
void vsetcurtype         (unsigned t);
void vshowcur            (void);


