
typedef   unsigned char bool;
typedef   unsigned char byte;
typedef   unsigned int  uint;
typedef   struct   MEvent   EVE    ,*EVEP ;




int _IsMouse(void) ;
//  externals
extern void ( interrupt far *_getvector( unsigned int))();
extern uint _SetBit(uint , uint) ;


#define   BOOL bool
#define   BYTE byte
#define   UINT uint

#define   TRUE              1
#define   FALSE             0

#define MAXEVENT      64  /* this is enough, but enlarge you as you want */

#define MOUSEMOVE   (1 << 0)
#define PRESS1      (1 << 1)
#define RELEASE1    (1 << 2)
#define PRESS2      (1 << 3)
#define RELEASE2    (1 << 4)
#define SHIFT_KEYR  (1 << 5)
#define SHIFT_KEYL  (1 << 6)
#define CTRL_KEY    (1 << 7)
#define ALT_KEY     (1 << 8)

// Macros to switch between text and graphical coordinates
#define TextToGraph(x)  (((x) - 1) << 3)
#define GraphToText(x)  (((x) >> 3) )   

#define MK_FP(seg,ofs)  ((void far *)(((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#define FP_SEG(fp) (*((unsigned *)&(fp) + 1))
#define FP_OFF(fp) (*((unsigned *)&(fp)))    

#define ASMSTART    _asm{
#define ASMEND      }
#define IF(x)       if (x) {
#define ELSE        } else {
#define ELSEIF(x)   } else if(x) {
#define ENDIF       }

#define MALLOC(x)    _xalloc(x)
#define FREE(x)      _xfree(x)

#define PEEK_TIME      *(unsigned long far *)0x0040006c
#define PEEK_SHIFT     *(byte far *)0x00400017
#define PEEK_EXTSHIFT  *(byte far *)0x00400018

#define MouPtrMask( z, f )\
  ( (( (unsigned long) f) >> 8 << 24) + (((unsigned long) z) >> 8 << 16) +\
    (((f) & 255) << 8) + ((z) & 255) )
#define PTRSAMECHAR   ( 0x00ff )        /* Same character            */
#define PTRDIFCHAR(z) ( (z) << 8 )      /* Other characters          */
#define PTRSAMECOL    ( 0x00ff )        /* Same color                */
#define PTRINVCOL     ( 0x7777 )        /* Inverse color             */
#define PTRSAMECOLB   ( 0x807f )        /* Same color (blinking)     */
#define PTRINVCOLB    ( 0xF777 )        /* Inverse color (blinking)  */
#define PTRDIFCOL(f)  ( (f) << 8 )      /* Other color               */
#define PTRDIFCOLB(f) (((f)|0x80) << 8) /* Other color (blinking)    */

#define EVE_KEYBOARD   0
#define EVE_MOUSE      1
#define EVE_REGION     2
#define EVE_TIMER      3
#define EVE_MENU       4
#define EVE_HOTOBJECT  5
#define EVE_GRID       6
#define EVE_DCLICK     7
#define EVE_MACRO      8

#define MEVENT_MOVE       0
#define MEVENT_PRESS1     1
#define MEVENT_RELEASE1   2
#define MEVENT_PRESS2     3
#define MEVENT_RELEASE2   4

#define SHIFT_SHIFTKEYR      0
#define SHIFT_SHIFTKEYL      1
#define SHIFT_CTRLKEY        2
#define SHIFT_ALTKEY         3
#define SHIFT_SCROLLOCK      4
#define SHIFT_NUMLOCK        5
#define SHIFT_CAPSLOCK       6
#define SHIFT_INSERT         7

#define EXSHIFT_CTRLKEY        0
#define EXSHIFT_ALTKEY         1
#define EXSHIFT_SYSREQ         2
#define EXSHIFT_PAUSE          3
#define EXSHIFT_BREAK          5
#define EXSHIFT_NUMLOCK        5
#define EXSHIFT_CAPSLOCK       6
#define EXSHIFT_INSERT         7


#define CHK_KEYBOARD           1
#define CHK_XPOS               2
#define CHK_YPOS               3
#define CHK_PRESS1             4
#define CHK_PRESS2             5
#define CHK_PRESS1AND2         6
#define CHK_RELEASE1           7
#define CHK_RELEASE2           8
#define CHK_RELEASE1AND2       9
#define CHK_SCANCODE          10
#define CHK_ASCIICODE         11
#define CHK_EXTENDCODE        12
#define CHK_TIMEOUT           13
#define CHK_MMOVE             14
#define CHK_SHIFTKEYR         15
#define CHK_SHIFTKEYL         16
#define CHK_SHIFTKEY          17
#define CHK_CTRLKEY           18
#define CHK_ALTKEY            19
#define CHK_SCROLLOCK         20
#define CHK_NUMLOCK           21
#define CHK_CAPSLOCK          22
#define CHK_INSERT            23
#define CHK_SYSREQ            24
#define CHK_PAUSE             25
#define CHK_BREAK             26
#define CHK_CURREGION         27
#define CHK_REGION            28
#define CHK_TIMER             29
#define CHK_STARTTIME         30
#define CHK_EVENTFLAG         31
#define CHK_NUMROWS           32
#define CHK_NUMCOLS           33
#define CHK_CHEIGHT           34


struct MEvent {
     int            event;
     short          x;
     short          y;     
     uint           scan ;
     uint           shift ;
     uint           exshift ;
     uint           MEvent ;
     int            lastarea;
     int            CurArea;
     unsigned long  startTime ;
     unsigned long  time;
     byte           mode    ; // current video mode
     byte           numrows ; // number of displayed text rows
     byte           numcols ; // number of displayed text columns
     byte           cheight ; // character height in pixels
     byte           textmode; // are we in text mode or graphics
     bool           samepos ;
  } ;
















